/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.core.meta.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import net.sf.thirdi.validation.config.BeanValueParameter;
import net.sf.thirdi.validation.spec.ConstraintValidator;
import net.sf.thirdi.validation.util.ReflectionUtils;

public class ValidationUtils {

	public static boolean isConstraintAnnotation(Annotation annotation) {

		if (annotation == null)
			throw new NullPointerException("annotation parameter is null.");

		ConstraintValidator constraintValidator = annotation.annotationType()
				.getAnnotation(ConstraintValidator.class);
		if (constraintValidator == null) {
			return false;
		}

		if (!hasMethod(annotation, "message", String.class)) {
			return false;
		}

		if (!hasMethod(annotation, "groups", String[].class)) {
			return false;
		}

		return true;
	}

	public static boolean isBeanValueParameterAnnotation(Annotation annotation) {
		if (annotation == null)
			throw new NullPointerException("annotation parameter is null.");

		BeanValueParameter constraintValidator = annotation.annotationType()
				.getAnnotation(BeanValueParameter.class);
		if (constraintValidator == null) {
			return false;
		} else {
			return true;
		}
	}

	public static boolean hasMethod(Annotation annotation,
			String parameterName, Class<?> type) {

		// null check
		if (annotation == null)
			throw new NullPointerException("annotation parameter is null.");
		if (parameterName == null || "".equals(parameterName))
			throw new NullPointerException(
					"parameterName parameter is null or empty.");
		if (type == null)
			throw new NullPointerException("type parameter is null.");

		try {
			Method m = annotation.getClass().getMethod(parameterName);
			Object o = m.invoke(annotation);
			if (o.getClass().getName().equals(type.getName())) {
				return true;
			} else {
				return false;
			}
		} catch (NoSuchMethodException e) {

			return false;
		} catch (Exception e) {
			return false;
		}
	}

	public static Object getFieldValue(Field field, Object object) {

		if (field == null)
			throw new NullPointerException("field parameter is null.");

		Object value = null;

		if (!Modifier.isPublic(field.getModifiers())) {
			ReflectionUtils.setAccessible(field);
		}
		try {
			value = field.get(object);
		} catch (IllegalAccessException ignore) {
		}

		return value;
	}

	public static Object getMethodValue(Method method, Object object) {

		if (method == null)
			throw new NullPointerException("method parameter is null.");

		Object value = null;

		if (!Modifier.isPublic(method.getModifiers())) {
			ReflectionUtils.setAccessible(method);
		}

		try {
			value = method.invoke(object, new Object[] { null });
		} catch (IllegalArgumentException e) {
		} catch (IllegalAccessException e) {
		} catch (InvocationTargetException e) {
		}
		return value;
	}
	
	public static <T> T  getFieldValue(Field field, Object object,Class<T> clazz) {

		if (field == null)
			throw new NullPointerException("field parameter is null.");

		Object value = null;

		if (!Modifier.isPublic(field.getModifiers())) {
			ReflectionUtils.setAccessible(field);
		}
		try {
			value = field.get(object);
		} catch (IllegalAccessException ignore) {
		}

		return clazz.cast(value);
	}

	public static <T> T getMethodValue(Method method, Object object,Class<T> clazz) {

		if (method == null)
			throw new NullPointerException("method parameter is null.");

		Object value = null;

		if (!Modifier.isPublic(method.getModifiers())) {
			ReflectionUtils.setAccessible(method);
		}

		try {
			value = method.invoke(object, new Object[] { null });
		} catch (IllegalArgumentException e) {
		} catch (IllegalAccessException e) {
		} catch (InvocationTargetException e) {
		}
		return clazz.cast(value);
	}

	public static boolean isPresent(String className) {

		try {
			Class.forName(className, true, Thread.currentThread()
					.getContextClassLoader());
			return true;
		} catch (ClassNotFoundException e) {
		}

		try {
			Class.forName(className, true, ClassLoader.getSystemClassLoader());
			return true;
		} catch (ClassNotFoundException e) {
			return false;
		}
	}

	public static boolean isValidTarget(Field field) {

		if (Modifier.isPrivate(field.getModifiers())
				|| Modifier.isFinal(field.getModifiers())) {
			return false;
		} else {
			return true;
		}
	}

	public static boolean isBooleanValue(String value) {
		if (value == null || "".equals(value))
			return false;
		if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
			return true;
		} else {
			return false;
		}
	}

}
