/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.util;

import java.util.Map;

public class JavaScriptUtil extends AbstractScriptUtil {

	private static JavaScriptUtil instance = new JavaScriptUtil();

	static {
		sd = new JavaScript();
		initialize();
	}

	static class JavaScript implements ScriptDescriptor {

		public String getKey() {
			return "js";
		}

		public String getName() {
			return "JavaScript";
		}
	}

	public static Object evaluate(final String expression,
			final Map<String, ?> values) {

		if (instance == null)
			instance = new JavaScriptUtil();
		return  instance.eval(expression, values);
	}

	public static Object evaluate(final String expression, String key,
			Object bean) {

		if (instance == null)
			instance = new JavaScriptUtil();
		return instance.eval(expression, key, bean);
	}

}
