/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.util;

import java.util.Set;

import net.sf.thirdi.validation.message.MessageEditorImpl;
import net.sf.thirdi.validation.spec.ConstraintViolation;
import net.sf.thirdi.validation.spec.MessageEditor;
import net.sf.thirdi.validation.spec.Validation;
import net.sf.thirdi.validation.spec.Validator;
import net.sf.thirdi.validation.spec.ValidatorFactory;
import net.sf.thirdi.validation.spec.ValidatorFactoryBuilder;

@SuppressWarnings("all")
public class ValidatorUtil {

	private static MessageEditor messageresolver = new MessageEditorImpl();

	private static Validator va;

	private static Validator getValidator() {

		if (va == null) {
			ValidatorFactoryBuilder vfb = Validation.getBuilder();
			ValidatorFactory vf = vfb.build();
			va = vf.getValidator();
		}

		return va;

	}

	public static boolean isError(Set errors) {
		return !errors.isEmpty();
	}

	public static <T> Set<ConstraintViolation<T>> validate(T o) {
		return getValidator().validate(o, null);
	}

	// public static ActionErrors validateActionErrors(Object o) {
	// Set<ConstraintViolation<Object>> s= getValidator().validate(o, null);
	//		
	// ActionErrors ae = new ActionErrors();
	//		
	// for (Iterator iterator = s.iterator(); iterator.hasNext();) {
	// ConstraintViolation<Object> constraintViolation =
	// (ConstraintViolation<Object>) iterator
	// .next();
	// ActionMessage am = new ActionMessage(
	// constraintViolation.getMessage()
	// );
	// ae.add(constraintViolation.getMessage(),am);
	// //System.out.println(constraintViolation.getMessage());
	// }
	//		
	// return ae;
	// }

	public MessageEditor getMessageresolver() {
		return messageresolver;
	}

	public void setMessageresolver(MessageEditor messageresolver) {
		this.messageresolver = messageresolver;
	}
}
