#
# --- grubmenu ---
#
# utils.py
#
# This is the utility function of grubmenu.
#
# Copyright (c) 2003 by kaepapa <kaepapa@kaepapa.dip.jp>

import os
import re
import copy
import gettext

import constants

from os.path import isdir
from string import maketrans
from string import translate

## Searching direcotry
# This function detects the directory which exists really from the list of arguments.
# However, when the directory which exists really is found,
# detection is stopped and the directory is returned.
#
# dirs : directory list
#
# return : searched directory

def search_dir(dirs):
    result = ""

    for x in dirs:
        if isdir(x):
            result = x
            break

    return result



## Searching device
# This function detects the device in which the directory specified by the argument
# from the /etc/fstab file exists.
# However, the directory which is not described by the /etc/fstab file is undetectable.
#
# path : directory
#
# return : device name

def search_dev(path):
    result = ""

    try:
        f = file(constants.FSTAB_FILE, 'r')
        while 1:
            line = f.readline()
            if line == "":
                break

            if re.match("\s*^#", line) == None:
                if line.split()[1] == path:
                    result = line.split()[0]
                    break
    finally:
        f.close

    return result



##  check number
# This function judges whether Argument num (character sequence) is a number.
# Moreover, it judges whether it is smaller than Argument max.
#
# num : The number to judge (character sequence)
# max : Maximum (integer)
#
# return : boolean

def check_number(num, max):

    if re.match("[0-9]",num) == None:
        return 1
    elif int(num) > max:
        return 1

    return 0



## device name exchange
# this function changes a device name (ex./dev/hda1) into grub form (ex. (hd 0,0)).
#
# dev : device name
#
# return : grub from device name

def dev_name_exchange(dev):
    result = ""

    num = len(dev)

    if num == 9:
        dev_str = dev[num-2:num-1]
    else:
        dev_str = dev[num-3:num-2]

    par_str = dev[8:]

    table = maketrans('abcdefgh','01234567')

    dev_num = translate(dev_str, table)
    par_num = int(par_str) - 1

    result = "(hd" + dev_num + "," + str(par_num) + ")"

    return result



## check answer yes
# As for this function, the character sequence of an argument checks that it is Yes.
#
# ans : The character sequence of an answer
#
# return : 0 will be returned if it is yes.

def check_answer_yes(ans):

    if (ans == "y") | (ans == "Y") | (ans == "yes") | (ans == "Yes") | (ans == "YES"):
        return 0
    else:
        return 1


## extract boot directory
# This function extracts the list of kernel images, or the list of a kernel image and initrd images
# below from a boot directory.
#
# target : linuz (kernel image list)
#          list (kernel image and initrd image list)
#
# return : list

def ext_vm(target):
    result = []

    bootlist = os.listdir(constants.BOOT)

    for img in bootlist:
        if target == 'linuz':
            if img.startswith('vmlinuz'):
                result.append(img)

        elif target == 'list':
            if img.startswith('vmlinuz'):
                tmp = []
                tmp.append(img)
                for img_ in bootlist:
                    if (img_.endswith(img[8:len(img)])) & (img_.startswith('initrd')):
                        tmp.append(img_)

                tmp.sort()
                tmp.reverse()

                result.append(tmp)

    result.sort()
    result.reverse()

    return result

    
## create entry list
# This function generates the list of entry.
#
# conf : class of config
#
# result : entry list

def make_entry_list(conf):
    tmp = []
    result = []

    for vm in conf.IMG_LIST:
        for op in conf.OPTION_LIST:
            if vm[0] == op[0]:
                #['vmlinuz-2.4.20',['yes','initrd.img-2.4.20'],single(yes or no),[boot_option]]
                tmp1 = []
                tmp1.append(vm[0])
                if len(vm) > 1:
                    tmp1.append(['yes',vm[1]])
                else:
                    tmp1.append(['no'])
                tmp1.append('no')
                tmp2 = []
                for opt in op:
                    if vm[0] != opt:
                        tmp2.append(opt)
                tmp1.append(tmp2)

                tmp.append(tmp1)

    if conf.SINGLE != "none":
         if conf.SINGLE == "ALL kernel-image":
            tmp1 = []
            for vm in tmp:
                single = copy.copy(vm)
                single.remove('no')
                single.insert(2,'yes')
                tmp1.append(single)

            for t1, t2 in zip(tmp, tmp1):
                result.append(t1)
                result.append(t2)
         else:
            single = copy.copy(tmp[conf.VM_LIST.index(conf.SINGLE)])
            single.remove('no')
            single.insert(2,'yes')
            tmp.append(single)

            result = tmp
    else:
        result = tmp

    return result

## get Defalut image number
# get number of image list for default boot kernel
#
# name: boot image name
# img: image list of kernels
# win: conf.WIN entry
#
# result: number of image list

def getNumberFromList(name,img,win):
    result = ""

    try:
        result = str(img.index(name))
    except:
        if (name == "Windows95/98/2000/XP") & (win != ""):
            result = str(len(img))
        else:
            print _("The image specified does not exist. 0 is specified as a default.")
            result = "0"

    return result













