#
# --- grubmenu ---
#
# ui_default.py
#
# This is the function group of a default user interface.
#
# Copyright (c) 2003 by kaepapa <kaepapa@kaepapa.dip.jp>

import re
import gettext

from common import constants
from common import utils

from string import atoi
from os.path import isfile

# Color setup Configration
def select_color(color):
    result = []

    if color != "":
        ans = raw_input(_("Clear setup?? (y/N)"))

        if utils.check_answer_yes(ans) == 0:
            result = ['none']
            return result

    _front_color = "\n"
    i = 0
    for c in constants.STR_COLOR:
        _front_color = _front_color + str(i) + ": " + c + "\n"
        i = i + 1

    _back_color = "\n"
    i = 0
    for c in constants.BG_COLOR:
        _back_color = _back_color + str(i) + ": " + c + "\n"
        i = i + 1

    print _front_color
    char = ""
    ans = raw_input(_("Please select number of character color:"))
    if utils.check_number(ans, len(constants.STR_COLOR)-1) == 0:
        char = constants.STR_COLOR[atoi(ans)]

    print _back_color
    bg = ""
    ans = raw_input(_("Please select number of background color:"))
    if utils.check_number(ans, len(constants.BG_COLOR)-1) == 0:
        bg = constants.BG_COLOR[atoi(ans)]

    print _front_color
    sel_char = ""
    ans = raw_input(_("Please select number of selected character color:"))
    if utils.check_number(ans, len(constants.STR_COLOR)-1) == 0:
        sel_char = constants.STR_COLOR[atoi(ans)]

    print _back_color
    sel_bg = ""
    ans = raw_input(_("Please select number of selected background color:"))
    if utils.check_number(ans, len(constants.BG_COLOR)-1) == 0:
        sel_bg = constants.BG_COLOR[atoi(ans)]

    if (char != "") & (bg != "") & (sel_char != "") & (sel_bg != ""):
        result = [char, bg, sel_char, sel_bg]
    else:
        print _("Invalid number was specified.")
        result = ['none']
        
    return result

# check for timeout
def set_time(conf):
    ans = raw_input(_("Please set up the timeout. (default ") + conf.TIME + "):")
    if ans != "":
        if re.match("[0-9]",ans) != None:
            conf.TIME = ans
            print _("The timeout was set up.") + conf.TIME
        else:
            print _("Invalid character sequence.\nThe default was set up.\n")
    else:
        print _("The default timeout was set up.\n")

# check for splash path
def set_splash(conf):
    _splash = _("Please set to path of splash :")
    if conf.SPLASH == "":
        _splash = _splash + " (default not set) :"
    else:
        _splash = _splash + " (default " + conf.SPLASH + ") :"

    ans = raw_input(_splash)
    if ans != "":
        if isfile(ans):
            if conf.COLOR != "":
                ans2 = raw_input(_("A color option will become invalid if a splash is set up. Is it all right? (y/N):"))
                if utils.check_answer_yes(ans2) == 0:
                    conf.SPLASH = ans
                    conf.COLOR = ""
                    print _("The splash file was set up :") + conf.SPLASH
                else:
                    print _("Splash is not set\n")
            else:
                conf.SPLASH = ans
                print _("The splash file was set up :") + conf.SPLASH
        else:
            print _("Invalid path of splash.\nThe default was set up.\n")
    else:
        if conf.SPLASH == "":
            print _("Splash is not set\n")
        else:
            print _("The splash file was set up :") + conf.SPLASH

# check for color
def set_color(conf):
    def setup(conf):
        if conf.COLOR == "":
            print _("The color option is not set.")
        else:
            print _("The color option is set as below. (") + conf.COLOR + ")"

        color = select_color(conf.COLOR)
        if len(color) == 4:
            conf.COLOR = color[0] +"/" + color[1] + " " + color[2] + "/" + color[3]
            print _("The color option was set up.\n")
        elif color[0] == 'none':
            conf.COLOR = ""
            print _("The color option was cleared.")
        else:
            print _("Set up of color option is imcomplete.\n")

    if conf.SPLASH == "":
        setup(conf)
    else:
        ans = raw_input(_("Is it all right, although a splash option will be cleared, if a color option is set up? (y/N):"))
        if utils.check_answer_yes(ans) == 0:
            setup(conf)
            conf.SPLASH = ""
        else:
            print _("A setup of a color option was stopped.\n")
        
# check for jp106 Correspondence
def set_jp(conf):
    _jp = _("Is jp 106 keyboard used ? (y/N)")
    
    ans = raw_input(_jp)
    if utils.check_answer_yes(ans) == 0:
        conf.JP = "yes"
        print _("jp 106 keyboard enabled.\n")
    else:
        conf.JP = "no"
        print _("jp 106 keyboard disabled.\n")

# set for single mode entry
def set_single(conf):

    _kernel_list = "\n"

    i = 0
    for img in conf.VM_LIST:
        _kernel_list += str(i) + ": " + img + "\n"
        i += 1

    _kernel_list += str(i) + ": ALL kernel-image\n"

    print _kernel_list
    ans = raw_input(_("Please choose the kernel-image which creates the entry of single mode. (default :") + \
                    conf.SINGLE + ") :")
    if utils.check_number(ans, len(conf.VM_LIST)) == 0:
        if ans == str(len(conf.VM_LIST)):
            conf.SINGLE = "ALL kernel-image"
        else:
            conf.SINGLE = conf.VM_LIST[int(ans)]
    else:
        if ans != "":
            if conf.SINGLE != "none":
                print _("Invalid character sequence, set default the singe mode entry.")
            else:
                print _("Invalid character sequence, any image was set the single mode entry.")
        
    print _("set kernel-image name which creates the entry of single mode :") + conf.SINGLE

# check for default boot kernel image
def set_default(conf):

    max = len(conf.IMG_LIST) -1
    _kernel_list = "\n"

    i = 0
    for img in conf.IMG_LIST:
        _kernel_list += str(i) + ": " + img[0] + "\n"
        i += 1

    if conf.WIN != "":
        _kernel_list += str(i) + ": "+constants.WINDOWS+"\n"
        max += 1

    print _kernel_list
    ans = raw_input(_("Please choose the kernel-image number booted by the default. :"))
    if utils.check_number(ans, max) == 0:
        try:
            default = conf.IMG_LIST[int(ans)][0]
        except:
            default = constants.WINDOWS
            
        print _("set default kernel-image :") + default
        conf.DEFAULT = default
    else:
        print _("Invalid character sequence. It does not set up.")

# check for kernel boot options
def set_option(conf):
        
    # Kernel list creation
    _kernel_list = "\n"

    i = 0
    for img in conf.VM_LIST:
        _kernel_list = _kernel_list + str(i) + ": " + img + "\n"
        i = i + 1

    _kernel_list += str(i) + _(": The present option is displayed.\n")

    # A menu is displayed.
    print _kernel_list

    # An item is chosen.
    ans = raw_input(_("Please choose the kernel image which sets up boot option. :"))
    print ""
    if utils.check_number(ans, len(conf.VM_LIST)-1) == 0:
        option = [conf.VM_LIST[atoi(ans)]]

        # The input of a starting option.
        print _("Please input a boot option.")
        ans = raw_input(_("When you specify more than one, please divide in a space.(ex. apm=on acpi=off) :"))

        # Momentary deletion of an option list
        for opt in conf.OPTION_LIST:
            if option[0] == opt[0]:
                conf.OPTION_LIST.remove(opt)
                break

        # Option specification.
        if ans != "":
            option.extend(ans.split())
        else:
            option.append('none')
        conf.OPTION_LIST.append(option)

        conf.OPTION = conf.OPTION_LIST
    elif ans == str(i):
        conf.OPTION_LIST.sort()
        conf.OPTION_LIST.reverse()

        # Booting option list display.
        if len(conf.OPTION_LIST) !=0:
            for opt in conf.OPTION_LIST:
                _option = opt[0] + " :"
                for op in opt:
                    if op != opt[0]:
                        _option += op + " "
                print _option
        else:
            print _("The boot option is not set up now.")
    else:
        print _("Invalid character sequence. Please try again.")

# check for win option
def set_win(conf):
    ans = raw_input(_("Please set up, if the partition with which Windows is installed exists. (ex. /dev/hda1) :"))
    if re.match("^/dev/.*", ans) != None:
        try:
            __damy = utils.dev_name_exchange(ans)
            conf.WIN = ans
        except:
            print _("Invalid character sequence, a setup was reset.")
            conf.WIN = ""

        if conf.WIN != "":
            print _("The Windows partition was set as below. :") + conf.WIN
    else:
        print _("Invalid character sequence, a setup was reset.")
        conf.WIN = ""

    return 0

# main fanction
def cui_config(conf):

    # Menu list view
    _menu = _("\n==== grubmenu CUI ====\n"
             "1: Boot timeout.\n"
             "2: Path of splash.\n"
             "3: Color option.\n"
             "4: Enable of jp106 keyboard.\n"
             "5: Single mode entry.\n"
             "6: Default boot kernel-image.\n"
             "7: Boot options.\n"
             "8: Windows partition\n"
             "9: Show this menu.\n"
             "0: Quit this menu."
             )

    print _menu
    while 1:
        conf.readconf()
        ans = raw_input(_("\ngrubmenu (9:show menu)>"))
        if ans == "1":
            set_time(conf)
        elif ans == "2":
            set_splash(conf)
        elif ans == "3":
            set_color(conf)
        elif ans == "4":
            set_jp(conf)
        elif ans == "5":
            set_single(conf)
        elif ans == "6":
            set_default(conf)
        elif ans == "7":
            set_option(conf)
        elif ans == "8":
            set_win(conf)
        elif (ans == "9") | (ans == "m") | (ans == "menu"):
            print _menu
        elif (ans == "0") | (ans == "q") | (ans == "quit"):
            break
        else:
            print _("Please check a menu and choose again.")
            pass
        conf.writeconf()

    return 0



