<?
/*----------------------------------------------------

  WikiCommonLibClass  For ThreadWiki

  ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.

------------------------------------------------------*/

require_once( 'Wiki/BasicDefinition.php' );

class WikiCommonLib
{

/*----------------------------------------------------

  WikiNameå
  
  return
   "ok" : 
   "invalid_name" : 
   "name_too_long": Ĺ
   
------------------------------------------------------*/
function check_wiki_name_valid( $wiki_name )
{
	if(preg_match("/[\[\|\~\^\(\)\"\'\]]/",$name)){
		return "invalid_name";
	}
	if(strlen($name) > 100){
		return "name_too_long";
	}
	
	return "ok";
}
//-----------------------------------------------------

/*----------------------------------------------------

 ǥեȥ̵

------------------------------------------------------*/
function convert_slashes( $target_data )
{
	if(get_magic_quotes_gpc()){
		$target_data =  stripslashes($target_data);
	}
	return $target_data;
}
//-----------------------------------------------------

/*----------------------------------------------------
  
  üʸΥ׽
  
------------------------------------------------------*/
function convert_control_char($target_data)
{
	//Nullʸ
	$target_data = str_replace("\0","",$target_data);
	
	//ǸιɤȤꤵ
	$target_data = preg_replace("/\r?\n$/","",$target_data);

	//ޥå̵
	if(get_magic_quotes_gpc()){
		$target_data =  stripslashes($target_data);
	}
	
	//ʸλȤ
	$target_data = preg_replace("/&/","&amp;",$target_data);
	$target_data = preg_replace("/</","&lt;",$target_data);
	$target_data = preg_replace("/>/","&gt;",$target_data);
	$target_data = preg_replace("/\"/","&quot;",$target_data);
	
	return $target_data;
}
//-----------------------------------------------------

/*----------------------------------------------------
  
  üʸΥ׽
  
------------------------------------------------------*/
function convert_control_char_in_array($target_array)
{
	$escaped_data = array();
	while(list($key_name,$value) = each($target_array))
	{
		if(is_array($value)){
			$escaped_data[$key_name] = WikiCommonLib::convert_control_char_in_array($value);
		}
		else{
			$escaped_data[$key_name] = WikiCommonLib::convert_control_char($value);
		}
	}
	
	return $escaped_data;
}
//-----------------------------------------------------


/*----------------------------------------------------

  WikiName
  $row_name          : о
  $base_namespace    : Ȥʤ̾
  &$regularized_data : Ϥؤλ

------------------------------------------------------*/
function regulate_wikiname($row_name,$base_namespace,&$regularized_data)
{
	$regularized_data = array();
	
	// ꥢ뤫
	if(preg_match("/^(.+?)\&gt\;(.+)$/",$row_name,$match_data))
	{
		$regularized_data['alias'] = $match_data[1];
		$row_name = $match_data[2];
	}
	
	if(preg_match("/^#(.+)$/",$row_name,$match_data))
	{
		$regularized_data['pointing_self'] = "on";
		$regularized_data['headlinename']  = $match_data[1];
		return;
	}

	// URL
	$url_valid = 's?https?:\/\/[-_\.!~*\'\(\)a-zA-Z0-9;\/\?:@&=+$,%#]+';
	if(preg_match("/^({$url_valid})/",$row_name,$match_data))
	{
		$base_namespace = "";
		$regularized_data['url'] = $match_data[1];
	}
	elseif(preg_match("/^\/(.*)$/",$row_name,$match_data))
	{
		//Хѥ
		$base_namespace = "";
		$row_name = $match_data[1];
	}
	elseif(preg_match("/^((\.\.\/)+)(.*)$/",$row_name,$match_data))
	{
		// ̶ֻ
		$row_name = $match_data[3];
		$base_namespace = WikiCommonLib::reduce_namespace($base_namespace,strlen($match_data[1])/3);
	}
	elseif(preg_match("/^(?:\.\/)?(.*)$/",$row_name,$match_data))
	{
		// л
		$row_name = $match_data[1];
	}
	
	if(preg_match("/^(.+)\/([^\/]*)$/",$row_name,$match_data)){
		$regularized_data['namespace'] = "";
		if($match_data[1] == ""){
			$regularized_data['namespace'] = $base_namespace;
		}
		else{
			if($base_namespace != ""){
				$regularized_data['namespace'] = $base_namespace . "/" . $match_data[1];
			}
			else{
				$regularized_data['namespace'] = $match_data[1];
			}
		}
		$regularized_data['pagename'] = $match_data[2];
	}
	else
	{
		$regularized_data['namespace'] = $base_namespace;
		$regularized_data['pagename'] = $row_name;
	}
	
	if(preg_match("/^(.*?)#(.+)$/",$regularized_data['pagename'],$match_data))
	{
		$regularized_data['pagename'] = $match_data[1];
		$regularized_data['headlinename'] = $match_data[2];
	}
}
//-----------------------------------------------------



/*----------------------------------------------------
  ץȼȤƤӽФURL
------------------------------------------------------*/
function make_myself_url($mode,$pagename,$namespace,$anchor="",$other="")
{
	$param_text = "md=$mode&amp;pg=" .urlencode($pagename) . "&amp;ns=" . urlencode($namespace);
	if($other)
	{
		$param_text .= "&amp;".$other;
	}
	if($anchor)
	{
		$param_text .= "#". crc32($anchor);
	}
	return $_SERVER['PHP_SELF']."?$param_text";
}


/*----------------------------------------------------
  ץȼȤƤӽФHTML󥯤
------------------------------------------------------*/
function make_link_html($display_text,$mode,$pagename,$namespace,$anchor="",$other="")
{
	return "<a href='".WikiCommonLib::make_myself_url($mode,$pagename,$namespace,$anchor,$other)."'>$display_text</a>";
}

//-----------------------------------------------------


/*----------------------------------------------------
  WikiNameʬHTML֤
------------------------------------------------------*/
function make_wikiname_html($display_text,&$wiki_data,$type="hit")
{
	switch($type){
	case('hit_upper_namespace'):
		return "<span class='upper'>" . 
		WikiCommonLib::make_link_html($display_text,"read",$wiki_data['pagename'],$wiki_data['namespace'],$wiki_data['headlinename']) .
		WikiCommonLib::make_link_html("*","edit",$wiki_data['pagename'],$wiki_data['namespace'],$wiki_data['headlinename']) .
		"</span>";
		break;
	
	case('not_found'):
		return "<span class='nopage'>" .$display_text . 
		WikiCommonLib::make_link_html("?","edit",$wiki_data['pagename'],$wiki_data['namespace'],$wiki_data['headlinename']) .
		"</span>";
		break;
	
	case('hit_index_page'):
		return WikiCommonLib::make_link_html($display_text,"read",$wiki_data['pagename'],$wiki_data['namespace'],$wiki_data['headlinename']);
		
		break;
	case('hit'):
	default:
		return WikiCommonLib::make_link_html($display_text,"read",$wiki_data['pagename'],$wiki_data['namespace'],$wiki_data['headlinename']);
		break;
	}
}
//-----------------------------------------------------


/*----------------------------------------------------
  ֤̾ޡ
------------------------------------------------------*/
function marge_namespace($namespace,$add_namespace)
{
	if($namespace == ""){
		return $add_namespace;
	}
	else{
		return $namespace . "/" . $add_namespace;
	}
}
//-----------------------------------------------------

/*----------------------------------------------------
  ֤̾򿼤ۤʬ
------------------------------------------------------*/
function reduce_namespace($namespace,$count_num)
{
	if($namespace == "" || $count_num==0){return "";}
	
	$name_space_array = split("/",$namespace);
	$new_name = "";
	
	for($i=0;$i<count($name_space_array) - $count_num;$i++){
	
		$new_name .= $name_space_array[$i] . "/";
	}
	
	$new_name = preg_replace("/\/$/","",$new_name);
	
	return $new_name;

}
//-----------------------------------------------------


/*----------------------------------------------------
  ߻ޥä
------------------------------------------------------*/
function get_microtime()
{
	list($usec, $sec) = explode(" ",microtime()); 
	return ((float)$sec + (float)$usec); 
} 
//-----------------------------------------------------

}

?>
