<?php
/*----------------------------------------------------

  TextDatabaseץ饰  
     ƥȥեѤWikiǡ١ץ饰

------------------------------------------------------*/

require_once( 'Wiki/TwDatabase.php' );
require_once( 'Wiki/WikiCommonLib.php' );
require_once( 'FLATz/FileControlLib.php' );

class TextDatabase extends TwDatabase
{

var $db_dir;
var $lock_file_handle;
var $check_cache;
var $check_cache_filename;
var $recent_change_list_cache;
var $recent_change_list_file;

/*----------------------------------------------------

  Sw_db_txt($db_dir)  󥹥ȥ饯

  $config  WikiStatus饹֥

------------------------------------------------------*/
function TextDatabase(&$config)
{
	parent::TwDatabase($config);
	$this->db_dir = $config->data['txt_database_dir'];
	$this->lock_file_handle = array();
	$this->check_cache = array();
	$this->check_cache_filename = array();
	$this->recent_change_list_cache = array();
	$this->recent_change_list_file = $this->db_dir . "/recentchange";
}
//-----------------------------------------------------


/*----------------------------------------------------

 self_check()  ʿ
 
  return  error or ok

------------------------------------------------------*/
function self_check()
{
	$test_file = "$this->db_dir/test.dat";

	if($fp = fopen($test_file,"a")){

		$write_result = fwrite($fp,"success");
		fclose($fp);
		$unlink_result = unlink($test_file);
		
		if(!$unlink_result){return "file_delete_error";}
		if($write_result == -1){return "file_write_error";}
		
		return "ok";
	
	}
	return "file_create_error";
}
//-----------------------------------------------------

/*----------------------------------------------------

  convert_dir_from_namespace($namespace) 
     ꤷ֤̾ǥ쥯ȥ̾Ѵ
    
    $name_space   ̾

------------------------------------------------------*/
function convert_dir_from_namespace($namespace)
{
	if($namespace == ""){return "";}
	
	$name_space_array = split("/",$namespace);
	$dir_name = "";
	
	for($i=0;$i<count($name_space_array);$i++){
		$dir_name .= $this->convert_filename_from_wikiname($name_space_array[$i]) . "/";
	}
	
	$dir_name = preg_replace("/\/$/","",$dir_name);
	
	return $dir_name;
}
//-----------------------------------------------------


/*----------------------------------------------------

  convert_filename_from_wikiname($wikiname)
      WikiNameбե̾Ѵ

------------------------------------------------------*/
function convert_filename_from_wikiname($wikiname)
{
	$encode_name = "";
	$char_list = preg_split("//", $wikiname, -1, PREG_SPLIT_NO_EMPTY);
	
	foreach($char_list as $char)
	{
		$encode_name .= sprintf("%02x", ord($char));
	}
	return $encode_name;

}
//-----------------------------------------------------

/*----------------------------------------------------

  decode_filename_from_filename($filename)
      WikiName᤹

------------------------------------------------------*/
function decode_filename_from_filename($filename)
{
	return preg_replace_callback("/([0-9a-fA-F][0-9a-fA-F])/",array($this,"decode_callback"),$filename);
}
//-----------------------------------------------------

/*----------------------------------------------------

  ִѥХåؿ

------------------------------------------------------*/
function decode_callback( $match_text )
{
	return chr(HexDec($match_text[1]));
}
//-----------------------------------------------------



/*----------------------------------------------------

   lock_target_file($filename) оݥեå

   $filename  оݤȤʤե̾
   return     0= 1=

------------------------------------------------------*/
function lock_target_file($filename)
{
	$fh = fopen($filename .".tmp","w+");
	if($fh){
		$lock_result = flock($fh,2);
		
		if($lock_result){
			$this->lock_file_handle[$filename] = $fh;
			return 1;
		}
	}
	return 0;
}
//-----------------------------------------------------

/*----------------------------------------------------

   unlock_target_file($filename) оݥեΥå
   
   $filename  оݤȤʤե̾
   return     0= 1= -1=ȤȥåƤʤ

------------------------------------------------------*/
function unlock_target_file($filename)
{
	if($this->lock_file_handle[$filename]){
		$unlock_result = flock($this->lock_file_handle[$filename],3);
		
		if($unlock_result){
			$this->lock_file_handle[$filename] = "";
			unlink($filename .".tmp");
			return 1;
		}
		else{
			return 0;
		}
	}
	return -1;
}
//-----------------------------------------------------


/*----------------------------------------------------

   encode_filestream($save_data) : ǡƥȥեľ

   $save_data  ֥ǡϥå
   return      ƥȥեΥǡ

------------------------------------------------------*/
function encode_filestream($save_data)
{
	
	$stream = "";
	
	reset($save_data);
	
	while (list($hashkey, $value) = each ($save_data)) {
		if($hashkey != "body" && $hashkey != ""){
			$stream .= $hashkey . ":" . $value ."\n";
		}
	}
	
	$stream .= "\n";
	
	for($i=0;$i<count($save_data['body']);$i++){
		$stream .= $save_data['body'][$i] . "\n";
		
	}
	return $stream;

}
//-----------------------------------------------------


/*----------------------------------------------------

   decode_filestream($stream)  ƥȷ顢ǡϥåѴ
   
   $stream  ƥȷȥ꡼
   return   ǡϥå

------------------------------------------------------*/
function decode_filestream($stream)
{
	
	$data_hash = array();
	$data_hash['body'] = array();
	$row_data_array = split("\r?\n",$stream);
	
	$body_flag = 0;
	for($i=0;$i<count($row_data_array);$i++){
		
		if($body_flag){
			$data_hash['body'][] = $row_data_array[$i];
			continue;
		}
		
		if($row_data_array[$i] == ""){
			$body_flag = 1;
			continue;
		}
		else{
			if(preg_match("/^(.+?):(.*)$/",$row_data_array[$i],$hit_data)){
				$data_hash[$hit_data[1]] = $hit_data[2];
			}
		}
	}
	
	return $data_hash;
	
}
//-----------------------------------------------------

/*----------------------------------------------------

  search_wikifile($wikiname,$namespace,$mode)  оݥե֤̾
    
    $wikiname   wikiname
    $namespace  ̾
    $mode       ư⡼ɤλ
       search = ֤̾ޤƹϤʥ
       target_level_only = о֤̾Τߥ

   return       ե̾

------------------------------------------------------*/
function search_wikifile($wikiname,$namespace,$mode)
{
	list($result,$filename) = $this->check_file_exist($wikiname,$namespace,$mode);
	return $filename;
}
//-----------------------------------------------------


/*----------------------------------------------------

  make_dir($target_dir)  оݥǥ쥯ȥ

------------------------------------------------------*/
function make_dir($target_dir)
{
	return FileControlLib::make_dir($target_dir,0777);
}
//-----------------------------------------------------

/*----------------------------------------------------

  set_cache($wikiname,$namespace,$cache_data,$cache_filename)
     å򥻥å

------------------------------------------------------*/
function set_cache($wikiname,$namespace,$cache_data,$cache_filename)
{
	$encoded_wikiname  = $this->convert_filename_from_wikiname($wikiname);
	$encoded_wikiname  = ($encoded_wikiname == "")?"X":$encoded_wikiname;
	$encoded_namespace = $this->convert_filename_from_wikiname($namespace);
	$encoded_namespace = ($encoded_namespace == "")?"X":$encoded_namespace;
	
	$this->check_cache[$encoded_wikiname][$encoded_namespace] = $cache_data;
	$this->check_cache_filename[$encoded_wikiname][$encoded_namespace] = $cache_filename;
}
//-----------------------------------------------------

/*----------------------------------------------------

  check_cache(&$set_result_array,$wikiname,$namespace)
     åå

------------------------------------------------------*/
function check_cache(&$set_result_array,$wikiname,$namespace)
{
	$encoded_wikiname  = $this->convert_filename_from_wikiname($wikiname);
	$encoded_wikiname  = ($encoded_wikiname == "")?"X":$encoded_wikiname;
	$encoded_namespace = $this->convert_filename_from_wikiname($namespace);
	$encoded_namespace = ($encoded_namespace == "")?"X":$encoded_namespace;

	if(isset($this->check_cache["$encoded_wikiname"]["$encoded_namespace"])){
		$set_result_array = array($this->check_cache["$encoded_wikiname"]["$encoded_namespace"],
		                          $this->check_cache_filename["$encoded_wikiname"]["$encoded_namespace"]);
		return true;
	}
	return false;
}
//-----------------------------------------------------

/*----------------------------------------------------

  convert_real_filename($wikiname,$namespace)
    WikiNameºݤоݥե̾Ѵ

------------------------------------------------------*/
function convert_real_filename($wikiname,$namespace)
{
	if($wikiname == "")
	{
		return $target_file = $this->convert_dir_from_namespace($namespace) . "/root.dat";
	}
	
	return $target_file = $this->convert_dir_from_namespace(WikiCommonLib::marge_namespace($namespace,$wikiname)) . ".dat";
}
//-----------------------------------------------------


/*----------------------------------------------------

  function check_file_exist($wikiname,$namespace,$mode,$recheck_flag=0)
       оݥڡե뤬¸ߤƤ뤫å

  $wikiname   wikiname
  $namespace  ̾
  $mode       ư⡼ɤλ
                search = ֤̾ޤƹϤʥ
                target_level_only = о֤̾Τߥ

  $recheck_flag : оݥڡƥå뤫ɤ

  return[0] : "hit" = ¸ߤ
              "not_found" = ¸ߤʤ
              "hit_upper_namespace" = ̤֤̾¸ߤƤ
              "hit_index_page" = оWikiName֤̾ȤȤIndexPageҥå

  return[1] :  ե̾

------------------------------------------------------*/
function check_file_exist($wikiname,$namespace,$mode,$recheck_flag=0)
{
	// åå
	if($recheck_flag == 0 && $mode== "search")
	{
		$cache_data_array = array();
		if($this->check_cache($cache_data_array,$wikiname,$namespace)){
			return $cache_data_array;
		}
	}
	
	//ɸå
	$target_file = $this->db_dir . "/latest/" . $this->convert_real_filename($wikiname,$namespace);
	if(file_exists($target_file)){
		$this->set_cache($wikiname,$namespace,"hit",$target_file);
		return array("hit",$target_file);
	}
	elseif($mode == "target_level_only"){
		return array("not_found","");
	}
	
	
	//̳ؤΥå
	$upper_namespace = $namespace;
	while(1){
		$upper_namespace = WikiCommonLib::reduce_namespace($upper_namespace,1);
		$target_file = $this->db_dir . "/latest/" . $this->convert_real_filename($wikiname,$upper_namespace);
		if(file_exists($target_file)){
			$this->set_cache($wikiname,$namespace,"hit_upper_namespace",$target_file);
			return array("hit_upper_namespace",$target_file);
		}
		elseif($upper_namespace == ""){
			$this->set_cache($wikiname,$namespace,"not_found","");
			return array("not_found","");
		}
	}
}
//-----------------------------------------------------

/*----------------------------------------------------

  check_exist($wikiname,$namespace)
       оݥڡ¸ߤƤ뤫å
      
  return : "hit" = ¸ߤ
           "not_found" = ¸ߤʤ
           "hit_upper_namespace" = ̤֤̾¸ߤƤ
           "hit_index_page" = оWikiName֤̾ȤȤIndexPageҥå

------------------------------------------------------*/
function check_exist($wikiname,$namespace)
{
	list($result,$filename) = $this->check_file_exist($wikiname,$namespace,"search");
	return $result;
}
//-----------------------------------------------------



/*----------------------------------------------------

  load(&$wikidata_object,$wikiname,$namespace,$mode)  оݥǡ
    
    $wikidata_object : ɤ߹PageData֥
    $wikiname   wikiname
    $namespace  ̾
    $mode       ư⡼ɤλ
       search = ֤̾ޤƥʥǥեȡ
       target_level_only = о֤̾Τߥ

   return       true  : ɤ߹
                  false : ɤ߹߼

------------------------------------------------------*/
function load(&$wikidata_object,$wikiname,$namespace,$mode="search")
{
	$filename = $this->search_wikifile($wikiname,$namespace,$mode);
	return $this->load_use_filename($wikidata_object,$filename);
}
//-----------------------------------------------------

/*----------------------------------------------------

  load_use_filename(&$wikidata_object,$filename)

------------------------------------------------------*/
function load_use_filename(&$wikidata_object,$filename)
{
	if($filename){
		if(!is_file($filename)){return false;}
		
		$data_stream = "";
		if($fh = fopen($filename,"r")){
			$data_stream = fread ($fh, filesize ($filename));
			fclose($fh);
			
			$wikidata_object->clear();
			$wikidata_object->data = $this->decode_filestream( $data_stream );
			return true;
		}
	}
	return false;
	
}
//-----------------------------------------------------


/*----------------------------------------------------

  load_header(&$wikidata_object,$wikiname,$namespace,$mode)  оݥǡإåΤߥ
    
    $wikidata_object : ɤ߹WikiData֥
    $wikiname   wikiname
    $namespace  ̾
    $mode       ư⡼ɤλ
       search = ֤̾ޤƥʥǥեȡ
       target_level_only = о֤̾Τߥ

   return       true  : ɤ߹
                  false : ɤ߹߼

------------------------------------------------------*/
function load_header(&$wikidata_object,$wikiname,$namespace,$mode="search")
{
	$filename = $this->search_wikifile($wikiname,$namespace,$mode);
	
	if($filename){
		if($this->load_header_use_filename($wikidata_object,$filename)){
			return true;
		}
	}
	return false;

}
//-----------------------------------------------------

/*----------------------------------------------------

  load_header_use_filename(&$wikidata_object,$filename)
     оݥե̾ꤷǡإåΤߥ

------------------------------------------------------*/
function load_header_use_filename(&$wikidata_object,$filename)
{

	if(!is_file($filename)){return false;}
	
	$data_stream = "";
	if($fh = fopen($filename,"r")){
		
		while (! feof($fh) ) {
			$line = fgets($fh, 4096);
			if($line == "\n" || $line == ""){break;}
			$data_stream .= $line;
		}
		fclose($fh);
		
		$wikidata_object->clear();
		$wikidata_object->data = $this->decode_filestream($data_stream);
		return true;
	}
	return false;

}
//-----------------------------------------------------



/*----------------------------------------------------

   save(&$page_object)  Ϥ줿ǡ¸
   
   $page_object  ¸ڡ饹֥
   return       "ok" = 
                  "freezed"  = ¾Ԥˤä 
                  "modifyed" = ̤οʹ֤˽줿
                  "_error"    = ͽ̥顼

------------------------------------------------------*/
function save(&$page_object)
{
	$name_dir = $this->convert_dir_from_namespace($page_object->data['name_space']);
	$target_filename_row  = $this->convert_real_filename($page_object->data['name'],$page_object->data['name_space']);
	$target_filename  = $this->db_dir . "/latest/" . $target_filename_row;
	
	if( $this->check_exist_namespace($page_object->data['name_space'])=="not_found" )
	{
		$default_namespace_data = new NamespaceData();
		$default_namespace_data->data['name']  = $page_object->data['name_space'];
		$default_namespace_data->data['owner'] = $page_object->data['owner'];
		$default_namespace_data->data['group'] = $page_object->data['group'];
		
		if( !$this->make_namespace($default_namespace_data) )
		{
			return "make_dir_error";
		}
		
	}
	
	
	// 
	if($this->history_flag != 0){
		if(is_file($target_filename)){
		
			if(!$this->make_dir($this->db_dir . "/history/" .$name_dir)){
				return "make_dir_error";
			}
			
			$old_time = preg_replace("/\.[0-9]+$/","",$page_object->data['last_modify']);
			if(!copy($target_filename, $this->db_dir . "/history/" . $target_filename_row . "." . $old_time)){
				return "history_error";
			}
			
			if(!$this->clear_old_history_log($page_object->data['name'],$page_object->data['name_space']))
			{
				return "history_log_delete_fail_error";
			}
			
		}
	}
	
	if(!$this->lock_target_file($target_filename)){return "lock_error";}
	
	$check_result = $this->check_save($page_object);
	if($check_result == "ok"){
		$fh = fopen($target_filename,"w");
		if($fh){
			$page_object->data['last_modify'] = WikiCommonLib::get_microtime();
			$save_stream = $this->encode_filestream($page_object->data);
			$write_result = fwrite($fh,$save_stream);
			$close_result = fclose($fh);
			if(!$this->unlock_target_file($target_filename)){return "unlock_error";}
			
			if($write_result == -1 || $close_result == false){
				return "error";
			}
			// եκƥåʡå奯ꥢ
			list($check_result,$filename) = 
			    $this->check_file_exist($page_object->data['name'],$page_object->data['name_space'],"target_level_only",1);
			if($check_result != "hit"){
				return "file_check_error";
			}
			//ǶιꥹȤɲ
			$this->add_recent_change_list($page_object->data['name'],$page_object->data['name_space']);
			return "ok";
		}
	
		$this->unlock_target_file($target_filename);
		return "file_open_error";
	}
	else{
		if(!$this->unlock_target_file($target_filename)){return "unlock_error";}
		return $check_result;
	}

}
//-----------------------------------------------------


/*----------------------------------------------------

  function delete_page(&$page_object)
       оݥڡ
      
  return : "ok" = 
           "not_found" = ¸ߤʤ
           "freezed"   = ¾Ԥˤä 
           "modifyed"  = ̤οʹ֤˽줿
           "error"     = ͽ̥顼

------------------------------------------------------*/
function delete_page(&$page_object)
{
	$valid_result = $page_object->check_valid();
	if($valid_result != "ok"){return $valid_result;}
	
	$target_filename = $this->db_dir . "/latest/" . $this->convert_real_filename($page_object->data['name'],$page_object->data['name_space']);
	
	$check_result = $this->check_save($page_object);
	if($check_result == "ok"){
		if(is_file($target_filename) && unlink($target_filename)){return "ok";}
		else{return "error";}
	}
	else{
		return $check_result;
	}
	
}
//-----------------------------------------------------


/*----------------------------------------------------

  get_recent_change_list($number, $namespace)  ǶιꥹȤ
  
  $number ɬפʥꥹȤο
  $namespace : ̾
  return եΥǡΣ
  
  $data[n]['pagename']  = ڡ̾
  $data[n]['namespace'] = ڡ¸ߤ̾
  $data[n]['timestamp'] = UNIXॹ

------------------------------------------------------*/
function get_recent_change_list($number, $namespace=null)
{
	$recent_change_list_file = $this->recent_change_list_file;
	if(!is_null($namespace)){
		$namespace = trim($namespace, "/");
		if($namespace != ""){
			$recent_change_list_file .=
			  "." . $this->convert_filename_from_wikiname($namespace);
		}
		else{
			$recent_change_list_ns_file .=
			  "." . $this->convert_filename_from_wikiname("/");
		}
	}

	if(count($this->recent_change_list_cache[$namespace]) < $number){
		//å夬­ʤɤľ
		$this->recent_change_list_cache[$namespace] = array();
		if(file_exists($recent_change_list_file)){
			if($fh = fopen($recent_change_list_file,"r")){
				$count = 0;
				while($line = fgets($fh, 4096)){
					if($count >= $number){break;}
					$linedata = array();
					list($linedata['pagename'],$linedata['namespace'],$linedata['timestamp']) = split("\t",$line);
					$this->recent_change_list_cache[$namespace][] = $linedata;
					$count++;
				}
				fclose($fh);
			}
		}
	}
	return $this->recent_change_list_cache[$namespace];
}
//-----------------------------------------------------

/*----------------------------------------------------

  add_recent_change_list($pagename,$namespace,$timestamp=0)
     ǶιꥹȤɲä

  return  "ok" = 
            "error" = 

------------------------------------------------------*/
function add_recent_change_list($pagename,$namespace,$timestamp=0)
{
	if($timestamp == 0){$timestamp = time();}

	// ֤̾Ȥκǿ߱ե̾
	$recent_change_list_ns_file = "";
	$namespace = trim($namespace, "/");
	if($namespace != ""){
		$recent_change_list_ns_file =
		  $this->recent_change_list_file . "." .
		  $this->convert_filename_from_wikiname($namespace);
	}
	else{
		$recent_change_list_ns_file =
		  $this->recent_change_list_file . "." .
		  $this->convert_filename_from_wikiname("/");
	}
	
	// ǶΥꥹȥեι
	$result1 = $this->add_recent_change_list_file(
	             $this->recent_change_list_file,
	             $pagename, $namespace, $timestamp
	          );
	// ֤̾Ȥιե
	$result2 = $this->add_recent_change_list_file(
	             $recent_change_list_ns_file,
	             $pagename, $namespace, $timestamp
	           );
	if($result1 == "ok" && $result2 == "ok"){
		return "ok";
	}
	return "error";
}
//-----------------------------------------------------


function add_recent_change_list_file(
  $list_file, $pagename, $namespace, $timestamp
){
	$temp_file = $list_file . ".tmp";
	if($tfh = fopen($temp_file,"w")){
		if($lock_result = flock($tfh,2)){
			//ɵ
			$save_stream = $pagename  . "\t" .
			               $namespace . "\t" .
			               $timestamp . "\n";
			fwrite($tfh,$save_stream);
			
			if(!file_exists($list_file)){
				touch($list_file);
			}
			if(file_exists($list_file) && $fh = fopen($list_file,"r")){
				$skip_flag = 0;
				for($i=0;$i<100;$i++){
					if(feof($fh)){break;}
					$line_data = fgets($fh,4096);
					if(!$skip_flag){
						list($temp_pagename,$temp_namespace,$temp_timestamp) =  split("\t",$line_data);
						if($temp_pagename == $pagename && $temp_namespace == $namespace){
							// ڡƱڡϥåפ
							$skip_flag = 1;
							continue;
						}
					}
					fwrite($tfh,$line_data);
				}
			}
			if(fclose($tfh)){
				if(copy($temp_file,$list_file)){
					unlink($temp_file);
					return "ok";
				}
			}
		}
	}
}
//-----------------------------------------------------
	

/*----------------------------------------------------

  gettime_recent_change() ǤǶιUNIXॹפ

  return UNIXॹ

------------------------------------------------------*/
function gettime_recent_change()
{
	return filemtime($this->recent_change_list_file);
}
//-----------------------------------------------------

/*----------------------------------------------------

  get_page_list($namespace="",$search_type="search")
     о֤̾ΥڡꥹȤ

   $namespace  оݤˤʤ̾
   $search_type  õ⡼
       search = ֤̾ޤ
       target_level_only = о֤̾Τߥʥǥեȡ
       search_index = ǥåڡΤߡĲLV򥵡

   return $keysort줿PageData֥Ȥäϥå

------------------------------------------------------*/
function get_page_list($namespace="",$search_type="search")
{
	$target_dir = $this->convert_dir_from_namespace($namespace);
	if( $target_dir )
	{
		$target_dir = $this->db_dir ."/latest/$target_dir";
	}
	else
	{
		$target_dir = $this->db_dir ."/latest";
	}

	$file_list = array();
	if($search_type == "target_level_only")
	{
		$file_list = FileControlLib::search_dir($target_dir,0);
	}
	elseif($search_type == "search")
	{
		$file_list = FileControlLib::search_dir($target_dir,-1);
	}
	elseif($search_type == "search_index")
	{
		$file_list = FileControlLib::search_dir($target_dir,1);
	}
	
	$list_data = $this->get_page_list_data($file_list);
	return $list_data;
}
//-----------------------------------------------------

/*----------------------------------------------------

  get_namespace_list($namespace="",$search_type="search")
     оְ̾ʲѤ֥̾ꥹȤ

   $namespace  оݤˤʤ̾
   $search_type  õ⡼
       search = ֤̾ޤ
       target_level_only = о֤̾Τߥʥǥեȡ
       search_index = ǥåڡΤߡĲLV򥵡

   return sort줿֤̾ä

------------------------------------------------------*/
function get_namespace_list($namespace="",$search_type="search")
{
	$target_dir = $this->convert_dir_from_namespace($namespace);
	if( $target_dir )
	{
		$target_dir = $this->db_dir ."/latest/$target_dir";
	}
	else
	{
		$target_dir = $this->db_dir ."/latest";
	}
	$file_list = array();
	if($search_type == "target_level_only")
	{
		$file_list = FileControlLib::get_dir_list($target_dir,0);
	}
	elseif($search_type == "search")
	{
		$file_list = FileControlLib::get_dir_list($target_dir,-1);
	}
	elseif($search_type == "search_index")
	{
		$file_list = FileControlLib::get_dir_list($target_dir,1);
	}
	
	$file_list = $this->decode_namespace_list($file_list);
	return $file_list;
}
//-----------------------------------------------------


/*----------------------------------------------------

  get_page_list_data($target_file_list)
     ڡꥹȥǡ

------------------------------------------------------*/
function get_page_list_data($target_file_list)
{
	$data_list = array();
	
	for($i=0;$i<count($target_file_list);$i++){
		if( preg_match("/namespace_data$/",$target_file_list[$i]) )
		{
			continue;
		}
		
		$page_data = new PageData();
		if($this->load_header_use_filename($page_data,$target_file_list[$i])){
			if($page_data->data['name'] == ""){continue;}
			
			$key_name = "";
			if($page_data->data['index_name'] != ""){
				$key_name = $page_data->data['index_name'];
			}
			elseif($page_data->data['name'] == $this->index_name){
				if($page_data->data['name_space'] == ""){continue;}
				else{$key_name = $page_data->data['name_space'];}
			}
			else{
				$key_name = $page_data->data['name'] . $page_data->data['name_space'];
			}
			$key_name = ucfirst($key_name);
			$key_num = "";
			while(array_key_exists($key_name . $key_num , $data_list)){
				$key_num++;
			}
			$data_list[$key_name . $key_num] = $page_data;
		}
	}
	ksort($data_list);
	return $data_list;
}
//-----------------------------------------------------

function decode_namespace_list($target_list)
{
	$decoded_list = array();
	$prefix_count = strlen($this->db_dir. "/latest/");
	for( $i=0;$i<count($target_list);$i++ )
	{
		$plain_name = substr($target_list[$i],$prefix_count);
		$split_data = split("/",$plain_name);
		for( $x=0;$x<count($split_data);$x++ )
		{
			$split_data[$x] = $this->decode_filename_from_filename($split_data[$x]);
		}
		$decoded_list[] = join("/",$split_data);
	}
	sort($decoded_list);
	return $decoded_list;
}


/*----------------------------------------------------

  get_history_list($pagename,$namespace)
    оݥڡꥹȡtimeͤΥꥹȤ

  $wikiname   wikiname
  $namespace  ̾
  return      array timeͤΥꥹ

------------------------------------------------------*/
function get_history_list($pagename,$namespace)
{
	$name_dir  = $this->convert_dir_from_namespace($namespace);
	$file_list = FileControlLib::search_dir($this->db_dir . "/history/" . $name_dir ,0);
	$target_filename = $this->convert_real_filename($pagename,"");
	
	$history_time_list = array();
	$target_filename = preg_replace("/^\//","",$target_filename);
	
	for($i=0;$i<count($file_list);$i++){
		if(preg_match("/$target_filename\.([0-9]+)$/",$file_list[$i],$hitdata)){
			$history_time_list[] = $hitdata[1];
		}
	}
	sort($history_time_list);
	
	return $history_time_list;
}
//-----------------------------------------------------


/*----------------------------------------------------

  load_history_data(&$wikidata_object,$wikiname,$namespace,$mode)  оǡ
    
    $wikidata_object : ɤ߹PageData֥
    $wikiname   wikiname
    $namespace  ̾
    $target_time time
    
   return       true  : ɤ߹
                  false : ɤ߹߼

------------------------------------------------------*/
function load_history_data(&$wikidata_object,$pagename,$namespace,$timestamp)
{
	$target_filename = $this->db_dir . "/history/" . 
	                   $this->convert_real_filename($pagename,$namespace). "." . $timestamp ;
	
	return $this->load_use_filename($wikidata_object,$target_filename);
}
//-----------------------------------------------------

/*----------------------------------------------------

  grep($word,$namespace="",$search_type="search") оʸʸ

    $word        
    $namespace   ̾֡ʸоݤꤹ
    $search_type õ⡼
       search = ֤̾ޤ
       target_level_only = о֤̾Τߥʥǥեȡ

   return        array("pagename"=>ڡ̾,"namespace"=>̾,
                         "number"=>Կ,"text"=>ʸեƥȤΰ)
                   
                   Ȥ

------------------------------------------------------*/
function grep($word,$namespace="",$search_type="search")
{
	$target_dir = $this->convert_dir_from_namespace($namespace);
	if( $target_dir )
	{
		$target_dir = $this->db_dir ."/latest/$target_dir";
	}
	else
	{
		$target_dir = $this->db_dir ."/latest";
	}

	$file_list = array();
	if($search_type == "target_level_only")
	{
		$file_list = FileControlLib::search_dir($target_dir,0);
	}
	elseif($search_type == "search")
	{
		$file_list = FileControlLib::search_dir($target_dir,-1);
	}
		
	return $this->process_grep($word,$file_list);
}
//-----------------------------------------------------

/*----------------------------------------------------
  grep
------------------------------------------------------*/
function process_grep($word,$file_list)
{
	$grep_result = array();
	
	for( $i=0;$i<count($file_list);$i++ )
	{
		$tmp_page_data = new PageData();
		
		if( $this->load_use_filename($tmp_page_data,$file_list[$i]) )
		{
			for( $x=0;$x<count($tmp_page_data->data['body']);$x++ )
			{
				if( preg_match("/$word/i",$tmp_page_data->data['body'][$x]) )
				{
					$match_data = array();
					$match_data['pagename']  = $tmp_page_data->data['name'];
					$match_data['namespace'] = $tmp_page_data->data['name_space'];
					$match_data['number']    = $x+1;
					$match_data['text']      = $this->get_text($tmp_page_data->data['body'],$x);
					array_push($grep_result,$match_data);
				}
			}
		}
	}
	
	return $grep_result;
}
//-----------------------------------------------------

/*----------------------------------------------------
  եƥȼ
------------------------------------------------------*/
function get_text(&$body,$hit)
{
	$text = array();
	$hit_count = 0;
	if($hit >= 1)
	{
		if($body[$hit-1] != "")
		{
			array_push($text,$body[$hit-1]);
			$hit_count++;
		}
	}
	
	for( $i=$hit;$i<count($body);$i++)
	{
		if($body[$i] != "")
		{
			array_push($text,$body[$i]);
			$hit_count++;
			if($hit_count > 3){break;}
		}
	}
	
	return join("<br />",$text);
}
//-----------------------------------------------------


/*----------------------------------------------------
  ŤꥹȤ
------------------------------------------------------*/
function clear_old_history_log( $pagename,$namespace )
{
	$history_list = $this->get_history_list($pagename,$namespace);
	
	$now_count = count($history_list);
	for( $i=$this->history_flag;$i<$now_count;$i++ )
	{
		$target_timestamp = array_pop($history_list);
		$target_filename  = $this->db_dir . "/history/" . $this->convert_real_filename($pagename,$namespace). "." . $target_timestamp ;
		if( is_file( $target_filename ) )
		{
			unlink( $target_filename );
		}
	}
	return true;
}
//-----------------------------------------------------


/*----------------------------------------------------

  make_namespace(&$namespace_data_object) ֤̾

   $namespace_data_object NamespaceData饹֥
   
   return       true  : 
                  false : 

------------------------------------------------------*/
function make_namespace(&$namespace_data_object)
{
	$dir_split_array = split("/",$namespace_data_object->data['name']);
	
	$tmp_count     = 0;
	$tmp_namespace = "";
	while(1)
	{
		if( !$this->check_exist_namespace( $tmp_namespace ) == "hit" || $namespace_data_object->data['name'] == $tmp_namespace )
		{
			$target_dir = $this->get_dirname_from_namespace( $tmp_namespace );
			if( !$this->make_dir($target_dir) )
			{
				return false;
			}
			
			$tmp_namespace_data = new NamespaceData();
			$tmp_namespace_data = $namespace_data_object;
			$tmp_namespace_data->data['name'] = $tmp_namespace;
			
			$fh = fopen($target_dir."/namespace_data","w");

			if($fh)
			{
				$save_stream = $this->encode_filestream( $tmp_namespace_data->data );
				$write_result = fwrite($fh,$save_stream);
				$close_result = fclose($fh);
				if($write_result == -1 || $close_result == false)
				{
					return false;
				}
			}
			else
			{
				return false;
			}
		}
		
		$tmp_count++;
		if( $tmp_count > count($dir_split_array) ){ break; }
		$tmp_namespace = join( "/",array_slice($dir_split_array,0,$tmp_count) );
	}
	
	return true;
}
//-----------------------------------------------------

//////////////////////////////////////////
// ֥̾ǥ쥯ȥѴ
function get_dirname_from_namespace( $namespace )
{
	$target_dir = $this->convert_dir_from_namespace($namespace);
	if( $target_dir )
	{
		$target_dir = $this->db_dir ."/latest/$target_dir";
	}
	else
	{
		$target_dir = $this->db_dir ."/latest";
	}
	return $target_dir;
}



/*----------------------------------------------------

  delete_namespace($namespace) ֤̾

   $namespace о̾
   
   return       true  : 
                  false : 

------------------------------------------------------*/
function delete_namespace( $namespace )
{
	if( $namespace )
	{
		$target_dir = $this->get_dirname_from_namespace( $namespace );
		return FileControlLib::delete_dir($target_dir);
	}
	
	return false;
}
//-----------------------------------------------------

/*----------------------------------------------------

  load_namespace(&$namespace_data_object,$namespace)
    о֤̾ξNamespace饹֥Ȥɤ߹

    $namespace_data_object : ɤ߹Namespace֥
    $namespace  ̾

   return       true  : ɤ߹
                  false : ɤ߹߼

------------------------------------------------------*/
function load_namespace(&$namespace_data_object,$namespace)
{
	if( !$this->check_exist_namespace($namespace) )
	{
		return false;
	}
	
	$target_dir = $this->get_dirname_from_namespace( $namespace );
	$filename   = $target_dir . "/namespace_data";
	
	if( is_file($filename) )
	{
		$data_stream = "";
		if($fh = fopen($filename,"r"))
		{
			$data_stream = fread ($fh, filesize ($filename));
			fclose($fh);
			
			$namespace_data_object->clear();
			$namespace_data_object->data = $this->decode_filestream( $data_stream );
			return true;
		}

	}
	
	return false;
}
//-----------------------------------------------------

/*----------------------------------------------------

  check_exist_namespace($namespace)
       о֤̾¸ߤƤ뤫å
      
  return : "hit" = ¸ߤ
           "not_found" = ¸ߤʤ

------------------------------------------------------*/
function check_exist_namespace($namespace)
{
	$target_dir = $this->get_dirname_from_namespace($namespace);
	
	if( is_dir($target_dir) )
	{
		if( is_file($target_dir."/namespace_data") )
		{
			return "hit";
		}
		else
		{
			$fh = fopen($target_dir."/namespace_data","w");
			
			if($fh)
			{
				$namespace_data = new NamespaceData();
				$namespace_data->data['name'] = $namespace;

				$save_stream = $this->encode_filestream( $namespace_data->data );
				
				$write_result = fwrite($fh,$save_stream);
				$close_result = fclose($fh);
				if($write_result == -1 || $close_result == false)
				{
					return "error";
				}
				else
				{
					return "hit";
				}
			}
			
		}
	
	}
	return "not_found";
}
//-----------------------------------------------------



}
?>
