<?php
/*----------------------------------------------------

  FileManagerClass For ThreadWiki

  ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.

------------------------------------------------------*/

require_once( 'FLATz/FileControlLib.php' );
require_once( 'Wiki/BasicDefinition.php' );
require_once( 'Wiki/FileData.php' );

class FileManager
{

var $config;
var $wiki_db;
var $message_manager;
var $file_dir;


//////////////////////////////////////////
// 󥹥ȥ饯
function FileManager( &$config_obj,&$wiki_db,&$message_manager )
{
	$this->config          = &$config_obj;
	$this->wiki_db         = &$wiki_db;
	$this->message_manager = &$message_manager;
	$this->file_dir        = $this->config->get('file_upload_dir');
}


//////////////////////////////////////////
// ե
function process_file_manager( &$postdata )
{
	require_once( 'Wiki/SystemMenuRenderer.php' );
	$system_renderer = new SystemMenuRenderer( $this->config );
	
	$sub_mode  = $postdata['smd'];
	$namespace = $postdata['ns'];
	
	$html  = "";
	switch( $sub_mode )
	{
	
	default:
		$file_list      = $this->get_list($namespace);
		$namespace_list = $this->wiki_db->get_namespace_list();
		$html = $system_renderer->upload_form($namespace,$file_list,$namespace_list);
		break;
	}

	return $html;
}


//////////////////////////////////////////
// ե򥢥åץɥ
function save( $input_name,$namespace,&$filedata )
{
	$filedata->clear();
	$filedata->data['name']       = $_FILES[$input_name]['name'];
	$filedata->data['mime_type']  = $_FILES[$input_name]['type'];
	$filedata->data['file_size']  = $_FILES[$input_name]['size'];
	$filedata->data['name_space'] = $namespace;
	$filedata->data['file_name']  = $this->convert_real_filename($filedata->data['name'],$filedata->data['name_space']) .".dat";
	$filedata->data['last_modify'] = WikiCommonLib::get_microtime();
	$filedata->data['permit_group'] = $this->config->get('default_group_user_permission');
	$filedata->data['permit_other'] = $this->config->get('default_other_user_permission');
	$filedata->data['permit_guest'] = $this->config->get('guest_user_auth_for_user_page');


	$real_dir_name = $this->convert_real_filename( "",$filedata->data['name_space'] );
	if( !FileControlLib::make_dir($real_dir_name,0777) )
	{
		return false;
	}
	
	$target_filename = $filedata->data['file_name'] . ".header";
	$stream = WikiCommonLib::encode_filestream( $filedata->data );
	if( $fh = fopen($target_filename,"w") )
	{
		$write_result = fwrite($fh,$stream);
		$close_result = fclose($fh);	
		if($write_result == -1 || $close_result == false)
		{
			return false;
		}
	}
	else
	{
		return false;
	}
	
	if( move_uploaded_file($_FILES[$name]['tmp_name'],$filedata->data['file_name']) )
	{
		return chmod($filedata->data['file_name'],0644);
	}
	else
	{
		unlink($target_filename);
	}
	return false;
}

//////////////////////////////////////////
// ե¸ߥå
function check_exists( $name,$namespace )
{
	$target_file = $this->convert_real_filename($name,$namespace) .".header";
	return is_file( $target_file );
}


//////////////////////////////////////////
// եɤ߹
function load( $name,$namespace,&$filedata )
{
	$filedata->clear();
	$target_file = $this->convert_real_filename($name,$namespace) .".header";
	return $this->load_use_filename( $target_file,$filedata );
}

//////////////////////////////////////////
// ե̾եɤ߹
function load_use_filename( $target_file,&$filedata )
{
	if( is_file($target_file) )
	{
		$data_stream = "";
		if($fh = fopen($target_file,"r"))
		{
			$data_stream  = fread ($fh, filesize ($target_file));
			$close_result = fclose($fh);
			if( $close_result == false ){ return false; }
			$filedata->data = WikiCommonLib::decode_filestream( $data_stream );
			return true;
		}
	}
	
	return false;
}


//////////////////////////////////////////
// оݥե
function delete_file( $name,$namespace )
{
	$filedata = new FileData();
	if( $this->load( $name,$namespace,$filedata ) )
	{
		if( unlink($filedata->data['file_name']) )
		{
			if( unlink($this->convert_real_filename($name,$namespace) .".dat") )
			{
				return true;
			}
		}
	}
	return false;
}

//////////////////////////////////////////
// оݥեHTTP
function output( &$filedata )
{
	if( is_file($filedata->data['file_name']) )
	{
		header("Content-type: ".$filedata->data['mime_type']);
		if( readfile($filedata->data['file_name']) !== false )
		{
			return true;
		}
	}
	
	return false;
}


//////////////////////////////////////////
// ǥ쥯ȥѥ
function convert_dir_path( $namespace )
{
	return $this->file_dir ."/" . WikiCommonLib::convert_dir_from_namespace( $namespace );
}

//////////////////////////////////////////
// ºݤΥե̾Ѵ
function convert_real_filename( $name,$namespace )
{
	return $target_file = $this->file_dir ."/" .WikiCommonLib::convert_dir_from_namespace( WikiCommonLib::marge_namespace($namespace,$name) ) . ".dat";
}


//////////////////////////////////////////
// о֤̾ˤեꥹȤ
function get_list( $namespace )
{
	$target_dir = $this->convert_dir_path( $namespace );
	$file_list = FileControlLib::search_dir($target_dir);
	
	$target_list = array();
	
	for( $i=0;$i<count($file_list);$i++ )
	{
		if( preg_match( "/\.header$/",$file_list[$i] ) )
		{
			array_push($target_list,$file_list[$i]);
		}
	}
	return $target_list;
}





//////////////////////////////////////////
// ХեꥹȤ
function get_relative_file_list( $target_dir="" )
{
	$filelist = $this->get_file_list( $target_dir );
	
	$offset = strlen($this->file_dir)+1;
	$relative_list = array();
	for( $i=0;$i<count($filelist);$i++ )
	{
		array_push($relative_list,substr($filelist[$i],$offset));
	}
	
	return $relative_list;
}

//////////////////////////////////////////
// åץɥǥ쥯ȥ꤫лѴ
function get_dir_name( $relative_dir )
{
	if($relative_dir)
	{
		return $this->file_dir."/".$relative_dir;
	}
	else
	{
		return $this->file_dir;
	}
}

//////////////////////////////////////////
// ASCIIʸʳޤޤƤ͡
function get_valid_name( $name )
{
	$valid = ASCII_FILENAME_VALID_CODE;
	if( preg_match("/$valid/",$name) )
	{
		return $name;
	}
	else
	{
		$tmp_name = time();
		$ext  = "unknown";
		if( preg_match("/\.([A-Za-z0-9]+)$/",$name,$match_str) )
		{
			$ext = $match_str[1];
		}
		return "file".$tmp_name.".".$ext;
	}
}

}
?>
