# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

import sys
import os
import re
from xml.dom import minidom
from subprocess import Popen, PIPE
from socket import gethostname
from linkpair.device import Device
from linkpair.port import Port
from linkpair.linkpair import LinkPair
from linkpair.collect.utils import CollectUtils
from linkpair.collect.agent.commandrunner import CommandRunner
from linkpair.formatter.grapheasy import GraphEasyFormatter
from linkpair.utils.common import CommonUtils


class BaseAgent(object):

    '''
    Collector Agent base class
    '''

    PEER_FOUND = 1

    def __init__(self, runner, cu, remote_desc, cd, formatter=GraphEasyFormatter()):
        self._runner = runner
        self._cu = cu
        self._remote_desc = remote_desc
        self._os_info = cd.os_info
        self._linuxnet = cd.linuxnet
        self._linkpairs = cd.linkpairs
        self._port_to_br = cd.port_to_br
        self._iface_to_nss = cd.iface_to_nss
        self._veth_peers = cd.veth_peers
        self._formatter = formatter

        self._u = CommonUtils()

    def run(self):
        self.get_configuration()
