# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

import re
from xml.dom import minidom
import libvirt
from linkpair.device import Device
from linkpair.port import Port
from linkpair.collect.agent.base_agent import BaseAgent


class LibvirtAgent(BaseAgent):

    '''
    Libvirt Collector Agent
    '''

    def run(self):
        self.pick_libvirt_configuration()

    def pick_libvirt_configuration(self):
        virt_conn = self.get_libvirt_conn()
        for id in virt_conn.listDomainsID():
            vm = virt_conn.lookupByID(id)
            vmXMLDesc = minidom.parseString(vm.XMLDesc(0))
            for iface in vmXMLDesc.getElementsByTagName("interface"):
                [device, bridge] = self.pick_libvirt_iface_configuration(iface)
                mac = iface.getElementsByTagName(
                    "mac")[0].getAttribute("address")
                device = iface.getElementsByTagName(
                    "target")[0].getAttribute("dev")
                bridge = self._cu.regist_to_port2br(device, bridge)
                self._cu.add_linkpair(
                    Device(str(vm.name()), Device.VM_TYPE),
                    Device(bridge, Device.BR_TYPE),
                    Port(device),
                    Port(""))

    def pick_libvirt_iface_configuration(self, iface):
        ifaceType = iface.getAttribute("type")
        bridge = ""
        device = ""
        if ifaceType == "network":
            network = iface.getElementsByTagName(
                "source")[0].getAttribute("network")
            netXMLDesc = minidom.parseString(
                virt_conn.networkLookupByName(network).XMLDesc(0))
            bridge = netXMLDesc.getElementsByTagName(
                "bridge")[0].getAttribute("name")
        elif ifaceType == "bridge":
            bridge = iface.getElementsByTagName(
                "source")[0].getAttribute("bridge")
        return [device, bridge]

    def get_libvirt_conn(self):
        if self._remote_desc is not None:
            conn = libvirt.open("qemu+ssh://" + self._remote_desc + "/system")
        else:
            conn = libvirt.open("qemu:///system")
        return conn
