# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

import re
from linkpair.device import Device
from linkpair.port import Port
from linkpair.collect.agent.base_agent import BaseAgent


class LinuxAgent(BaseAgent):

    '''
    Linux OS Collector Agent
    '''

    def run(self):
        self.get_configuration()

    def get_configuration(self):
        result = self._runner.exec_cmd("hostname")
        hostname = result[0].rstrip()
        self._os_info[hostname] = hostname

        result = self._runner.exec_cmd("uname -s")
        kernel_name = result[0].rstrip()
        self._os_info[kernel_name] = kernel_name

        result = self._runner.exec_cmd("uname -m")
        kernel_arch = result[0].rstrip()
        self._os_info[kernel_arch] = kernel_arch

        result = self._runner.exec_cmd("uname -r")
        kernel_version = result[0].rstrip()
        self._os_info[kernel_version] = kernel_version
