# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

import re
from linkpair.device import Device
from linkpair.port import Port
from linkpair.collect.agent.base_agent import BaseAgent


class LinuxBridgeAgent(BaseAgent):

    '''
    Linux bridge Collector Agent
    '''

    def run(self):
        self.pick_bridge_configuration()

    def pick_bridge_configuration(self):
        br_src = ""
        veth_peers = {}
        result = self._runner.exec_cmd("brctl show")
        for br_line in result:
            br_line = br_line.rstrip()

            # bridge definition line
            # [bridge name] [bridge id] [STP enabled] [interfaces]
            if self._u.d_push(re.match(r'^(\S+)\s+(\S+)\s+(\S+)\s+(\S+)$', br_line)) is not None:
                match = self._u.d_pop()
                br_src = match.group(1)
                port_name = match.group(4)
                if self._cu.exist_port(port_name):
                    port_meta = self._cu.get_port(port_name).metadata
                else:
                    port_meta = self._cu.METADATA_NOT_FOUND

                if port_name not in self._port_to_br and br_src != "":
                    self._port_to_br[port_name] = br_src

                    # veth port
                    if self._cu.get_port_veth_peer(port_name) != self._cu.PORT_PEER_UNSPECIFIED:
                        peer_src = port_name
                        peer_dst = self._cu.get_port_veth_peer(port_name)
                        veth_peers[peer_src + ":" + peer_dst] = self.PEER_FOUND

                        if peer_dst + ":" + peer_src in veth_peers:
                            continue

                        br_dst = self._port_to_br[peer_dst]
#                        if self._cu.exist_linkpair(br_src, br_dst, peer_src, peer_dst):
#                            continue

                        if peer_dst in self._port_to_br:
                            self._cu.add_linkpair(
                                Device(br_src, Device.BR_TYPE),
                                Device(br_dst, Device.BR_TYPE),
                                Port(peer_src),
                                Port(peer_dst),
                                self._formatter.VETH_FORMAT)

                    # none veth port
                    else:
                        # physical interface
                        if self._u.d_push(re.match(r'^eth\d+$', port_name)) \
                            or self._u.d_push(re.match(r'^em\d+$', port_name)) \
                                or self._u.d_push(re.match(r'^igb\d+$', port_name)) \
                                or self._u.d_push(re.match(r'^bond\d+$', port_name)):
                            self._port_to_br[port_name] = br_src
                            self._cu.add_linkpair(
                                Device(br_src, Device.BR_TYPE),
                                Device("Physical NW", Device.PHYNET_TYPE),
                                Port(port_name, Port.DEFAULT_TYPE, port_meta),
                                Port(""))

                        # tunnel port
                        elif self._u.d_push(re.match(r'(vxlan\d+)', port_name)) \
                            or self._cu.get_port_type(port_meta) == "gre" \
                                or self._cu.get_port_type(port_meta) == "stt":
                            self._port_to_br[port_name] = br_src
                            self._cu.add_linkpair(
                                Device(br_src, Device.BR_TYPE),
                                Device("OS Routing", Device.OS_ROUTE_TYPE),
                                Port(port_name, Port.DEFAULT_TYPE, port_meta),
                                Port(""),
                                self._formatter.OS_ROUTING_FORMAT)

                        # Other bridge port
                        else:
                            # VLAN interface
                            if self._cu.get_port_vlan_master_if(port_name) != self._cu.PORT_VLAN_UNSPECIFIED:
                                master_if = self._cu.get_port_vlan_master_if(
                                    port_name)
                                if master_if in self._port_to_br:
                                    print port_name + " " + master_if
                                    self._port_to_br[port_name] = br_src
                                    port_src = port_name
                                    port_dst = master_if
                                    port_dst_obj = self._cu.get_port(master_if)
                                    br_dst = self._port_to_br[master_if]
                                    br_dst_obj = self._cu.get_device(br_dst)
                                    self._cu.add_linkpair(
                                        Device(br_src, Device.BR_TYPE),
                                        br_dst_obj,
                                        Port(port_src),
                                        port_dst_obj,
                                        self._formatter.VLAN_DIST_FORMAT)

                                elif self._u.d_push(re.match(r'^eth\d+$', master_if)) \
                                    or self._u.d_push(re.match(r'^em\d+$', master_if)) \
                                        or self._u.d_push(re.match(r'^igb\d+$', master_if)) \
                                        or self._u.d_push(re.match(r'^bond\d+$', master_if)):
                                    self._cu.add_linkpair(
                                        Device(br_src, Device.BR_TYPE),
                                        Device(
                                            "Physical NW", Device.PHYNET_TYPE),
                                        Port(port_name, Port.DEFAULT_TYPE),
                                        Port(""))

                            else:
                                continue
#                                self._cu.add_linkpair(
#                                    Device(br_src),
#                                    Device("INTERNAL", Device.OS_ROUTE_TYPE),
#                                    Port(port_name),
#                                    Port(""))
                                # if (phys if):

            # bridge interface line
            #                            [interfaces]
            elif self._u.d_push(re.match(r'^\s+(\S+)$', br_line)) is not None:
                port_name = self._u.d_pop().group(1)
                if self._cu.exist_port(port_name):
                    port_meta = self._cu.get_port(port_name).metadata
                else:
                    port_meta = self._cu.METADATA_NOT_FOUND

                if port_name not in self._port_to_br and br_src != "":
                    self._port_to_br[port_name] = br_src

                    # veth port
                    if self._cu.get_port_veth_peer(port_name) != self._cu.PORT_PEER_UNSPECIFIED:
                        peer_src = port_name
                        peer_dst = self._cu.get_port_veth_peer(port_name)
                        veth_peers[peer_src + ":" + peer_dst] = self.PEER_FOUND

                        if peer_dst + ":" + peer_src in veth_peers:
                            continue

                        br_dst = self._port_to_br[peer_dst]
                        # if self._cu.exist_linkpair(br_src, br_dst, peer_src, peer_dst):
                        #    continue

                        if peer_dst in self._port_to_br:
                            self._cu.add_linkpair(
                                Device(br_src, Device.BR_TYPE),
                                Device(br_dst, Device.BR_TYPE),
                                Port(peer_src),
                                Port(peer_dst),
                                self._formatter.VETH_FORMAT)

                    # none veth port
                    else:
                        # physical interface
                        if self._u.d_push(re.match(r'^eth\d+$', port_name)) \
                            or self._u.d_push(re.match(r'^em\d+$', port_name)) \
                                or self._u.d_push(re.match(r'^igb\d+$', port_name)) \
                                or self._u.d_push(re.match(r'^bond\d+$', port_name)):
                            self._cu.add_linkpair(
                                Device(br_src, Device.BR_TYPE),
                                Device("Physical NW", Device.PHYNET_TYPE),
                                Port(port_name, Port.DEFAULT_TYPE, port_meta),
                                Port(""))

                        # tunnel port
                        elif self._u.d_push(re.match(r'(vxlan\d+)', port_name)) \
                            or self._cu.get_port_type(port_meta) == "gre" \
                                or self._cu.get_port_type(port_meta) == "stt":
                            self._cu.add_linkpair(
                                Device(br_src, Device.BR_TYPE),
                                Device("OS Routing", Device.OS_ROUTE_TYPE),
                                Port(port_name, Port.DEFAULT_TYPE, port_meta),
                                Port(""),
                                self._formatter.OS_ROUTING_FORMAT)

                        # Other bridge port
                        else:

                            # VLAN interface
                            if self._cu.get_port_vlan_master_if(port_name) != self._cu.PORT_VLAN_UNSPECIFIED:
                                master_if = self._cu.get_port_vlan_master_if(
                                    port_name)
                                if master_if in self._port_to_br:
                                    port_src = port_name
                                    port_dst = master_if
                                    port_dst_obj = self._cu.get_port(master_if)
                                    br_dst = self._port_to_br[master_if]
                                    br_dst_obj = self._cu.get_device(br_dst)
                                    self._cu.add_linkpair(
                                        Device(br_src, Device.BR_TYPE),
                                        br_dst_obj,
                                        Port(port_src),
                                        port_dst_obj,
                                        self._formatter.VLAN_DIST_FORMAT)

                            else:
                                continue
#                                self._cu.add_linkpair(
#                                    Device(br_src),
#                                    Device("INTERNAL", Device.OS_ROUTE_TYPE),
#                                    Port(port_name),
#                                    Port(""))
                                # if (phys if):

#                 if port_name not in self._port_to_br and br_name != "":
#                     self._port_to_br[port_name] = br_name
#
# for OpenStack quntum...
#                     if self._u.d_push(re.match(r'^qvb(.+)', port_name)):
#                         quantum_idprefix = self._u.d_pop().group(1)
#                         if "qvo" + quantum_idprefix in self._port_to_br:
#                             self._cu.add_linkpair(
#                                 Device(br_name, Device.BR_TYPE),
#                                 Device(self._port_to_br[
#                                        "qvo" + quantum_idprefix], Device.BR_TYPE),
#                                 Port(port_name),
#                                 Port("qvo" + quantum_idprefix),
#                                 self._formatter.VETH_FORMAT)
#                     else:
#                         if self._u.d_push(re.match(r'^qvo(.+)', port_name)):
#                             continue
#                         self._cu.add_linkpair(
#                             Device(br_name),
#                             Device("INTERNAL", Device.OS_ROUTE_TYPE),
#                             Port(port_name),
#                             Port(""))
# print "int: " + br_name + ": " + port_name
