# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

import re
from linkpair.device import Device
from linkpair.port import Port
from linkpair.collect.agent.base_agent import BaseAgent


class LinuxNetAgent(BaseAgent):

    '''
    Linux Network Collector Agent
    '''

    def run(self):
        self.get_configuration()

    def get_configuration(self):
        interfaces = []
        port_name = ""
        port_meta = {}
        found_if = False
        res_ipaddr = self._runner.exec_cmd("ip addr show")
        for i in range(0, len(res_ipaddr)):
            port_start = res_ipaddr[i].strip()
            if self._u.d_push(
                re.search(r'(\d+): (\S+): <(\S+)> mtu (\d+) (.*)',
                          port_start)) is not None:
                match = self._u.d_pop()
                port_meta["if_index"] = match.group(1).strip()
                port_name = match.group(2).strip()
                port_meta["if_state"] = match.group(3).strip()
                port_meta["mtu"] = match.group(4).strip()
                port_meta["if_other_state"] = match.group(5).strip()
                interfaces.append(port_name)
                if found_if:
                    self._cu.add_port(
                        Port(port_name, Port.DEFAULT_TYPE, port_meta))
                    port_name = ""
                    port_meta = {}
                else:
                    found_if = True
            elif self._u.d_push(
                re.search(r'link/ether (\S+) brd (\S+)',
                          port_start)) is not None:
                match = self._u.d_pop()
                port_meta["mac_addr"] = match.group(1).strip()
                port_meta["mac_bcast_addr"] = match.group(2).strip()
            elif self._u.d_push(
                re.search(r'inet (\S+) brd (\S+) scope (\S+)',
                          port_start)) is not None:
                match = self._u.d_pop()
                port_meta["inet_addr"] = match.group(1).strip()
                port_meta["inet_bcast_addr"] = match.group(2).strip()
                port_meta["if_scope"] = match.group(3).strip()

        for interface in interfaces:
            # interface informations
            res_ethtool = self._runner.exec_cmd("ethtool " + interface)
            self._parse_ethtool_output(res_ethtool, port_meta)

            # interface driver informations
            res_ethtool = self._runner.exec_cmd("ethtool -i " + interface)
            self._parse_ethtool_output(res_ethtool, port_meta)

            # interface statistics
            res_ethtool = self._runner.exec_cmd("ethtool -S " + interface)
            self._parse_ethtool_output(res_ethtool, port_meta)

            # interface offload settings
            res_ethtool = self._runner.exec_cmd("ethtool -k " + interface)
            self._parse_ethtool_output(res_ethtool, port_meta)

            self._cu.add_port(Port(interface, Port.DEFAULT_TYPE, port_meta))
            interface = ""
            port_meta = {}

    def _parse_ethtool_output(self, res_ethtool, port_meta):
        if_property = ""
        multi_line = False
        multi_line_property = ""
        multi_line_value = ""

        for i in range(0, len(res_ethtool)):
            ethtool_line = res_ethtool[i].rstrip()
            if self._u.d_push(
                    re.search(r'(\S.*):\s+(\S.*)', ethtool_line)) is not None:
                match = self._u.d_pop()
                if_property = match.group(1).strip()
                if re.search(r' link modes', if_property):
                    multi_line = True
                    multi_line_property = if_property
                    multi_line_value = match.group(2).strip()
                else:
                    if multi_line:
                        port_meta[multi_line_property] = multi_line_value
                        multi_line = False
                        multi_line_property = ""
                        multi_line_value = ""
                    port_meta[if_property] = match.group(2).strip()

            elif multi_line and self._u.d_push(
                    re.search(r'\s+(\S.*)', ethtool_line)) is not None:
                match = self._u.d_pop()
                multi_line_value += " " + match.group(1).strip()
