# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

import re
import os
from linkpair.device import Device
from linkpair.port import Port
from linkpair.collect.agent.base_agent import BaseAgent


class SSPVxlanAgent(BaseAgent):

    '''
    SSP VXLAN Collector Agent
    '''

    def run(self):
        self.pick_vxlan_configuration()

    def pick_vxlan_configuration(self):
        vxlan_base_dir = "/proc/net/vxlan/"
        vxlan_if_dirs = self._runner.exec_cmd("ls " + vxlan_base_dir)
        for vxlan_if_dir in vxlan_if_dirs:
            vxlan_if_dir = vxlan_if_dir.strip()
            if self._u.d_push(re.match(r'^(vxlan\d+)', vxlan_if_dir)) is not None:
                match = self._u.d_pop()
                vxlan_if_name = match.group(1)
                vxlan_remote = self._runner.exec_cmd(
                    "cat " + vxlan_base_dir + vxlan_if_name + "/" + "remote")
                vxlan_ifconfigs = self._runner.exec_cmd(
                    "ifconfig " + vxlan_if_name)
                for vxlan_ifconfig in vxlan_ifconfigs:
                    vxlan_ifconfig = vxlan_ifconfig.strip()
                    if self._u.d_push(re.match(r'VXLAN VNI\s+:\s+(\d+)', vxlan_ifconfig)) is not None:
                        vxlan_vnid = self._u.d_pop().group(1)
                        port_meta = {
                            "vxlan_vnid": vxlan_vnid, "remote_ip": vxlan_remote[0]}
                            #"vxlan_vnid": vxlan_vnid, "remote_ip": "\\\"" + vxlan_remote[0] + "\\\""}
                        self._cu.add_port(Port(
                            vxlan_if_name, Port.DEFAULT_TYPE, port_meta))
                        break
