# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

import re
from linkpair.device import Device
from linkpair.port import Port
from linkpair.collect.agent.base_agent import BaseAgent


class VethAgent(BaseAgent):

    '''
    VETH Collector Agent
    '''

    def run(self):
        self.pick_veth_configuration()

    def pick_veth_configuration(self):
        if_name = ""
        result = self._runner.exec_cmd("ip link show")
        for if_line in result:
            if_line = if_line.rstrip()
            if self._u.d_push(re.match(r'^\d+:\s(\S+):', if_line)) is not None:
                match = self._u.d_pop()
                if_name = match.group(1)
                result2 = self._runner.exec_cmd("ethtool -S " + if_name)
                for eth_line in result2:
                    if self._u.d_push(re.match(r'\s+peer_ifindex:\s(\d+)', eth_line)) is not None:
                        match = self._u.d_pop()
                        peer_if_no = match.group(1)
                        result3 = self._runner.exec_cmd("ip link show")
                        for ip_link_line in result3:
                            if self._u.d_push(re.match(r'^%s:\s(\S+):' % peer_if_no, ip_link_line)) is not None:
                                match = self._u.d_pop()
                                peer_if = match.group(1)
                                self._veth_peers[if_name] = peer_if
                                port_meta = {"veth_peer": peer_if}
                                self._cu.add_port(Port(
                                    if_name, Port.DEFAULT_TYPE, port_meta))
                                port_meta2 = {"veth_peer": if_name}
                                self._cu.add_port(Port(
                                    peer_if, Port.DEFAULT_TYPE, port_meta2))
