# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

__version__ = '1.1'

import sys


class DBUtils(object):

    def __init__(self):
        self._db_enable = False
        self._sql_conn = None

    def create_tables(self):
        if self._db_enable:
            sql = "create table linkpair_table" + \
                "(fmt text, src text, src_style text, label text, dst text, dst_style text)"
            sql_conn.execute(sql)
            sql_conn.commit()

    def insert_record(self, fmt, src, src_style, label, dst, dst_style):
        sql_q1 = '\''
        sql_q2 = '\','
        sql = 'insert into linkpair_table values(' \
            + sql_q1 + fmt + sql_q2 \
            + sql_q1 + src + sql_q2 \
            + sql_q1 + src_style + sql_q2 \
            + sql_q1 + label + sql_q2 \
            + sql_q1 + dst + sql_q2 \
            + sql_q1 + dst_style + '\')'
        sql_conn.execute(sql)

    def store_to_db(self, db_name, linkpairs):
        json_strings = ""
        for linkpair in linkpairs:
            json_strings = json_strings + linkpair.to_json() + ","
        json_strings = json_strings.rstrip(",")

        try:
            json_file = open(db_name, 'w')
            json_file.write("{\"linkpairs\": [")
            json_file.write(json_strings)
            json_file.write("]\n}")
            json_file.close()
        except:
            print "error:", sys.exc_info()[0]
            raise

    def open_db(self, db_name):
        import sqlite3
        self._sqlconn = sqlite3.connect(db_name)
        return self._sql_conn

    def close_db(self):
        if self._db_enable:
            self._sql_conn.commit()
            self._sql_conn.close()

    def get_db_enable(self):
        return self._db_enable

    def set_db_enable(self, enable):
        self._db_enable = enable

    def del_db_enable(self):
        del self._db_enable
    db_enable = property(get_db_enable, set_db_enable, del_db_enable)
