# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

import datetime
import hashlib


class JsonExporter(object):

    def __init__(self, util, linkpairs, current_snapid=0):
        self._u = util
        self._linkpairs = linkpairs
        self.current_snapid = current_snapid

    def run(self):
        json_strings = ["{\n"]
        linkpair_index = 0
        json_strings.append("\"linkpairs\": [\n")
        for linkpair in self._linkpairs:
            linkpair_json = "{\"linkid\":\"lp_" + \
                linkpair.get_linkpair_linkid() + "\",\"linkpair\":"
            json_strings.append(linkpair_json + linkpair.to_json() + "},\n")
            linkpair_index += 1
        json_strings[len(json_strings) - 1] = json_strings[
            len(json_strings) - 1].rstrip(",\n")
        json_strings.append("],\n")
        linkpairs_hash = hashlib.sha256("".join(json_strings)).hexdigest()
        json_strings.append("\"linkpairs_hash\":\"" + linkpairs_hash + "\",\n")
        json_strings.append(
            "\"exported_time\":\"" + self.get_exported_time() + "\",\n")
        json_strings.append(
            "\"snapid\":\"" + self.get_current_snapid() + "\"\n")
        json_strings.append("}")
        return "".join(json_strings)

    def set_linkpairs(self, linkpairs):
        self._linkpairs = linkpairs

    def get_exported_time(self):
        d = datetime.datetime.today()
        return d.strftime("%Y-%m-%d %H:%M:%S")

    def get_current_snapid(self):
        snapid = str(self.current_snapid)
        self.current_snapid += self.current_snapid
        return snapid
