# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

from linkpair.linkpair import LinkPair
from linkpair.device import Device
from linkpair.port import Port
from linkpair.utils.common import CommonUtils


class BaseFormatter(object):
    DEFAULT_STYLE = ''
    VM_STYLE = ''
    BR_STYLE = ''
    OS_ROUTE_STYLE = ''
    PHYNET_STYLE = ''
    NAMESPACE_STYLE = ''
    PATCH_STYLE = ''
    NOT_CONNECTED_STYLE = ''

    DEFAULT_FORMAT = 0
    OS_ROUTING_FORMAT = 1
    NAMESPACE_FORMAT = 2
    PATCH_FORMAT = 3
    VETH_FORMAT = 4
    VLAN_DIST_FORMAT = 5

    DEFAULT_FORMAT_DESC = '[ %s ] %s -- { label: "%s   %s"; } [ %s ] %s'
    OS_ROUTING_FORMAT_DESC = '[ %s ] %s -- { label: "%s %s"; } [ %s ] %s'
    NAMESPACE_FORMAT_DESC = '[ %s ] %s --> { label: %s   %s; } [ %s ] %'
    PATCH_FORMAT_DESC = '[ %s ] %s <==> { label: %s  :  %s; } [ %s ] %s'
    VETH_FORMAT_DESC = '[ %s ] %s <--> { label: %s  \|  %s; } [ %s ] %s'
    VLAN_DIST_FORMAT_DESC = '[ %s ] %s <--> { label: %s\(%s\); } [ %s ] %s'

    HEADER_FORMAT = ""
    FOOTER_FORMAT = ""
    formatter_name = "base"

    def __init__(self, util=CommonUtils(), title=""):
        self._linkpairs = []
        self._u = util
        self._title = title
        self._groupid = 1
        self._u.debug_out(self.formatter_name + " formatter initialized")

    @classmethod
    def format_linkpair(cls, linkpair):
        formatted_lp = ""

        device1_label = linkpair.device1
        device2_label = linkpair.device2
        port1_label = linkpair.port1
        port2_label = linkpair.port2

        if "remote_ip" in linkpair.port1.metadata:
            port1_label = port1_label + " remote=\\\"" + \
                linkpair.port1.metadata["remote_ip"] + "\\\""
        if "tag" in linkpair.port1.metadata:
            port1_label = port1_label + " vlan=" + \
                linkpair.port1.metadata["tag"]
        if "vlan_vid" in linkpair.port1.metadata:
            port1_label = port1_label + " vid=" + \
                linkpair.port1.metadata["vlan_vid"]
        if "vxlan_vnid" in linkpair.port1.metadata:
            port1_label = port1_label + " vnid=" + \
                linkpair.port1.metadata["vxlan_vnid"]
        if "remote_ip" in linkpair.port2.metadata:
            port2_label = port2_label + " remote=\\\"" + \
                linkpair.port2.metadata["remote_ip"] + "\\\""
        if "tag" in linkpair.port2.metadata:
            port2_label = port2_label + " vlan=" + \
                linkpair.port2.metadata["tag"]
        if "vlan_vid" in linkpair.port2.metadata:
            port2_label = port2_label + " vid=" + \
                linkpair.port2.metadata["vlan_vid"]
        if "vxlan_vnid" in linkpair.port2.metadata:
            port2_label = port2_label + " vnid=" + \
                linkpair.port2.metadata["vxlan_vnid"]

        formatted_lp = cls.get_format_desc(linkpair.format) % (
            device1_label,
            cls.get_device_style(linkpair.device1.device_type),
            port1_label,
            port2_label,
            device2_label,
            cls.get_device_style(linkpair.device2.device_type))
        return formatted_lp

    def format_linkpairs(self):
        formatted_lps = []
        formatted_lps.append(self.get_header())
        print self.get_header()
        for lp in self._linkpairs:
            formatted_lps.append(self.format_linkpair(lp))
        formatted_lps.append(self.get_footer())
        return formatted_lps

    def get_header(self):
        header = self.HEADER_FORMAT
        return header

    def get_footer(self):
        footer = self.FOOTER_FORMAT
        return footer

    @classmethod
    def get_device_style(cls, device_type=Device.DEFAULT_TYPE):
        if device_type == Device.DEFAULT_TYPE:
            return cls.DEFAULT_STYLE
        elif device_type == Device.VM_TYPE:
            return cls.VM_STYLE
        elif device_type == Device.BR_TYPE:
            return cls.BR_STYLE
        elif device_type == Device.OS_ROUTE_TYPE:
            return cls.OS_ROUTE_STYLE
        elif device_type == Device.PHYNET_TYPE:
            return cls.PHYNET_STYLE
        elif device_type == Device.NAMESPACE_TYPE:
            return cls.NAMESPACE_STYLE
        elif device_type == Device.NOT_CONNECTED_TYPE:
            return cls.NOT_CONNECTED_STYLE
        else:
            return cls.DEFAULT_STYLE

    @classmethod
    def get_port_style(cls, type=Port.DEFAULT_TYPE):
        return cls.DEFAULT_STYLE

    @classmethod
    def get_all_devices(cls, lps):
        devices = []
        devices_str = []
        for lp in lps:
            if str(lp.device1) not in devices_str and str(lp.device1) != "":
                devices_str.append(str(lp.device1))
                devices.append(lp.device1)
            if str(lp.device2) not in devices_str and str(lp.device2) != "":
                devices_str.append(str(lp.device2))
                devices.append(lp.device2)
        devices = sorted(set(devices), key=devices.index)
        return devices

    @classmethod
    def get_format_desc(cls, format=Device.DEFAULT_TYPE):
        if format == cls.DEFAULT_FORMAT:
            return cls.DEFAULT_FORMAT_DESC
        elif format == cls.OS_ROUTING_FORMAT:
            return cls.OS_ROUTING_FORMAT_DESC
        elif format == cls.NAMESPACE_FORMAT:
            return cls.NAMESPACE_FORMAT_DESC
        elif format == cls.PATCH_FORMAT:
            return cls.PATCH_FORMAT_DESC
        elif format == cls.VETH_FORMAT:
            return cls.VETH_FORMAT_DESC
        elif format == cls.VLAN_DIST_FORMAT:
            return cls.VLAN_DIST_FORMAT_DESC
        else:
            return cls.DEFAULT_FORMAT_DESC

    @apply
    def linkpairs():
        def get(self):
            return self._linkpairs

        def set(self, linkpairs):
            self._linkpairs = linkpairs

    def set_linkpairs(self, linkpairs):
        self._linkpairs = linkpairs

    @apply
    def format():
        def get(self):
            return self._format

        def set(self, format):
            self._format = format

    @apply
    def title():
        def get(self):
            return self._title

        def set(self, title):
            self._title = title

    def to_json(self):
        return "[ formatter_name: " + self.formatter_name + ", " + "title: " + self._title + " ]"
