# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

from linkpair.linkpair import LinkPair
from linkpair.device import Device
from linkpair.port import Port
from baseformatter import BaseFormatter


class GraphEasyFormatter(BaseFormatter):
    DEFAULT_STYLE = '{ fill: #dddddd; bordercolor: black; }'
    VM_STYLE = '{ fill: #dddddd; bordercolor: black; }'
    BR_STYLE = '{ fill: #ddddff; border: double; bordercolor: blue; }'
    OS_ROUTE_STYLE = '{ fill: white; border: dotted; bordercolor: black; }'
    PHYNET_STYLE = '{ fill: white; border: dotted; bordercolor: green; }'
    NAMESPACE_STYLE = '{ fill: green; border: none; }'
    PATCH_STYLE = '{ fill: #ddddff; border: dotted; bordercolor: black; }'
    NOT_CONNECTED_STYLE = '{ fill: #ffdddd; border: dotted; bordercolor: black; }'

    DEFAULT_FORMAT_DESC = '[ %s ] %s -- { label: "%s   %s"; labelcolor: #663333; } [ %s ] %s'
    OS_ROUTING_FORMAT_DESC = '[ %s ] %s -- { label: "%s   %s"; labelcolor: #663333; } [ %s ] %s'
    NAMESPACE_FORMAT_DESC = '[ %s ] %s --> { label: "%s   %s"; labelcolor: #663333; } [ %s ] %s'
    PATCH_FORMAT_DESC = '[ %s ] %s <==> { label: "%s : %s"; labelcolor: #333366; } [ %s ] %s'
    VETH_FORMAT_DESC = '[ %s ] %s <--> { label: "%s \| %s"; labelcolor: #336633; } [ %s ] %s'
    VLAN_DIST_FORMAT_DESC = '[ %s ] %s --> { label: "%s\(%s\)"; labelcolor: #336633; } [ %s ] %s'

    HEADER = ""
    FOOTER = ""
    formatter_name = "graph-easy"
