# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

from linkpair.linkpair import LinkPair
from linkpair.device import Device
from linkpair.port import Port
from baseformatter import BaseFormatter


class SpringyFormatter(BaseFormatter):
    DEFAULT_STYLE = "color: '#00A0B0', directional: false"
    VM_STYLE = "color: '#00A0B0', directional: false"
    BR_STYLE = "color: '#00A0B0', directional: false"
    OS_ROUTE_STYLE = "color: '#00A0B0', directional: false"
    PHYNET_STYLE = "color: '#00A0B0', directional: false"
    NAMESPACE_STYLE = "color: '#00A0B0', directional: true"
    PATCH_STYLE = "color: '#DDDDFF', directional: true"
    NOT_CONNECTED_STYLE = "color: '#FFDDDD', directional: true"

    DEFAULT_FORMAT_DESC = "['%s', '%s', {%s, label: '%s %s'}]"
    OS_ROUTING_FORMAT_DESC = "['%s', '%s', {%s, label: '%s %s'}]"
    NAMESPACE_FORMAT_DESC = "['%s', '%s', {%s, label: '%s %s'}]"
    PATCH_FORMAT_DESC = "['%s', '%s', {%s, label: '%s : %s'}]"
    VETH_FORMAT_DESC = "['%s', '%s', {%s, label: '%s \| %s'}]"
    VLAN_DIST_FORMAT_DESC = "['%s', '%s', {%s, label: '%s\(%s\)'}]"

    ADDNODE_STYLE = "graph.addNodes('%s');"
    ADDEDGE_START = "graph.addEdges("
    ADDEDGE_END = ");"

    formatter_name = "springy"

# ['br0', 'br1', {color: '#00A0B0', directional: false, label: 'port1 port2'}],

    HEADER_FORMAT = '''
<html>
<body>
<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.3.2/jquery.min.js"></script>
<script src="springy.js"></script>
<script src="springyui.js"></script>
<script>
var graph = new Springy.Graph();
    '''

    FOOTER_FORMAT = '''
jQuery(function(){
    var springy = jQuery('#springyformat').springy({
        graph: graph
    });
});
</script>
<canvas id="springyformat" width="1024" height="768" />
</body>
</html>
    '''

    def format_linkpairs(self):
        formatted_lps = []
        formatted_lps.append(self.get_header())
        for device in self.get_all_devices(self._linkpairs):
            node = self.ADDNODE_STYLE % (device)
            formatted_lps.append(node)

        formatted_lps.append(self.ADDEDGE_START)
        for lp in self._linkpairs:
            formatted_lps.append(self.format_linkpair(lp) + ",")

        formatted_lps[len(formatted_lps) - 1] = formatted_lps[len(
            formatted_lps) - 1].rstrip(",")
        formatted_lps.append(self.ADDEDGE_END)
        formatted_lps.append(self.get_footer())
        return formatted_lps

    @classmethod
    def format_linkpair(cls, linkpair):
        formatted_lp = ""
        device1_label = linkpair.device1
        device2_label = linkpair.device2
        port1_label = linkpair.port1
        port2_label = linkpair.port2

        if "remote_ip" in linkpair.port1.metadata:
            port1_label = port1_label + " remote=" + \
                linkpair.port1.metadata["remote_ip"].replace("\"", "\\\"")
        if "tag" in linkpair.port1.metadata:
            port1_label = port1_label + " vlan=" + \
                linkpair.port1.metadata["tag"]
        if "vlan_vid" in linkpair.port1.metadata:
            port1_label = port1_label + " vid=" + \
                linkpair.port1.metadata["vlan_vid"]
        if "vxlan_vnid" in linkpair.port1.metadata:
            port1_label = port1_label + " vnid=" + \
                linkpair.port1.metadata["vxlan_vnid"]
        if "remote_ip" in linkpair.port2.metadata:
            port2_label = port2_label + " remote=" + \
                linkpair.port2.metadata["remote_ip"]
        if "tag" in linkpair.port2.metadata:
            port2_label = port2_label + " vlan=" + \
                linkpair.port2.metadata["tag"]
        if "vlan_vid" in linkpair.port2.metadata:
            port2_label = port2_label + " vid=" + \
                linkpair.port2.metadata["vlan_vid"]
        if "vxlan_vnid" in linkpair.port2.metadata:
            port2_label = port2_label + " vnid=" + \
                linkpair.port2.metadata["vxlan_vnid"]

        formatted_lp = cls.get_format_desc(linkpair.format) % (
            device1_label,
            device2_label,
            cls.get_device_style(linkpair.device1.device_type),
            port1_label,
            port2_label)
        return formatted_lp
