# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

import json
from linkpair.device import Device
from linkpair.port import Port
from linkpair.collect.utils import CollectUtils
from linkpair.collect.collector_dataset import CollectorDataset
from linkpair.formatter.graphviz_tb import GraphvizTBFormatter


class JsonImporter(object):

    def __init__(self, util, import_file, formatter=GraphvizTBFormatter()):
        self._import_file = import_file
        self._devices = {}
        self._ports = {}
        self._os_info = {}
        self._linuxnet = {}
        self._linkpairs = []
        self._port_to_br = {}
        self._iface_to_nss = {}
        self._veth_peer = {}
#        self._opts = opts
        self._u = util
        self._remote_desc = ""
        self._ssh_username = ""
        self._ssh_hostname = ""
        self._ssh_hostport = 22
        self._remote_password = ""
        self._remote_sshkey = ""
        self._ssh_keyauth = False
        self._ssh_passauth = False
        self._formatter = formatter
        self._linkpairs_hash = ""
        self._exported_time = ""
        self._snapid = ""
        self._u.debug_out("JsonImporter initialized: " + self._import_file)

    def run(self):
        cd = CollectorDataset(
            self._devices, self._ports, self._os_info, self._linuxnet, self._linkpairs,
            self._port_to_br, self._iface_to_nss, self._veth_peer)
        cu = CollectUtils(
            cd, self._u, self._formatter)

        f_import = open(self._import_file)
        json_data = json.load(f_import)
        f_import.close()

        self._linkpairs_hash = json_data["linkpairs_hash"]
        self._exported_time = json_data["exported_time"]
        self._snapid = json_data["snapid"]
        self._u.debug_out("importing...\n  linkpairs_hash: " + self._linkpairs_hash +
                          "\n  exported_time: " + self._exported_time + "\n  snapid: " + self._snapid)
        for linkpair in json_data["linkpairs"]:
            self._u.debug_out("  " + linkpair["linkid"])
            device1 = Device(linkpair["linkpair"]["device1"]["label"],
                             int(linkpair["linkpair"][
                                 "device1"]["device_type"]),
                             linkpair["linkpair"]["device1"]["meta"])
            device2 = Device(linkpair["linkpair"]["device2"]["label"],
                             int(linkpair["linkpair"][
                                 "device2"]["device_type"]),
                             linkpair["linkpair"]["device2"]["meta"])
            port1 = Port(linkpair["linkpair"]["port1"]["label"],
                         int(linkpair["linkpair"]["port1"]["port_type"]),
                         linkpair["linkpair"]["port1"]["meta"])
            port2 = Port(linkpair["linkpair"]["port2"]["label"],
                         int(linkpair["linkpair"]["port2"]["port_type"]),
                         linkpair["linkpair"]["port2"]["meta"])
            format = int(linkpair["linkpair"]["format"])

            cu.add_linkpair(
                device1,
                device2,
                port1,
                port2,
                format)

    def get_linkpairs(self):
        return self._linkpairs

    def get_linkpairs_hash(self):
        return self._linkpairs_hash

    def get_exported_time(self):
        return self._exported_time

    def get_snapid(self):
        return self._snapid
