# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

import base64
from device import Device
from port import Port


class LinkPair(object):

    def __init__(self, device1, device2, port1, port2, format, format_name=""):
        self.device1 = device1
        self.device2 = device2
        self.port1 = port1
        self.port2 = port2
        self.format = format
        self.format_name = format_name

    @apply
    def device1():
        def get(self):
            return self.device1

        def set(self, device):
            self.device1 = device

    @apply
    def device2():
        def get(self):
            return self.device2

        def set(self, device):
            self.device2 = device

    @apply
    def port1():
        def get(self):
            return self.port1

        def set(self, port):
            self.port1 = port

    @apply
    def port2():
        def get(self):
            return self.port2

        def set(self, port):
            self.port2 = port

    @apply
    def format():
        def get(self):
            return self.__format

        def set(self, format):
            self.__format = format

    def __str__(self):
        return "[" + str(self.device1) + "]:" + str(self.port1) + \
               " -- " + str(self.port2) + ":[" + str(self.device2) + "]"

    def _get_format_as_string(self, format):
        return "\"" + str(self.format) + "\""

    def get_linkpair_linkid(self):
        return str(self.device1).replace(" ", "_") + "__" + \
            str(self.device2).replace(" ", "_") + "__" + \
            str(self.port1).replace(" ", "_") + "__" + \
            str(self.port2).replace(" ", "_")

    def to_json(self):
        return "{\"device1\":" + repr(self.device1) + "," + \
               "\"device2\":" + repr(self.device2) + "," + \
               "\"port1\":" + repr(self.port1) + "," + \
               "\"port2\":" + repr(self.port2) + "," + \
               "\"format\":" + self._get_format_as_string(self.format) + "}"
