<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Defines all the backup steps that will be used by {@link backup_mplayer_activity_task}
 *
 * @package     mod_mplayer
 * @category    backup
 * @copyright   2010 David Mudrak <david.mudrak@gmail.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

/**
 * Defines the complete mplayer structure for backup, with file and id annotations
 *
 * @link http://docs.moodle.org/dev/Workshop for XML structure diagram
 */
class backup_mplayer_activity_structure_step extends backup_activity_structure_step {

    /**
     * Defines the structure of the 'mplayer' element inside the mplayer.xml file
     *
     * @return backup_nested_element
     */
    protected function define_structure() {

        // root element describing mplayer instance
        $mplayer = new backup_nested_element('mplayer', array('id'), array(
            //'name', 'intro', 'introformat',
            //'mplayerfile', 'type', 'streamer',
            //'id',
            'course',
            'name',
            'intro',
            'introformat',
            'timecreated',
            'timemodified',
            'configxml',
            'author',
            'mplayerdate',
            'description',
            'infoboxcolor',
            'infoboxposition',
            'infoboxsize',
            'duration',
            'mplayerfile',
            'hdbitrate',
            'hdfile',
            'hdfullscreen',
            'hdstate',
            'livestreamfile',
            'livestreamimage',
            'livestreaminterval',
            'livestreammessage',
            'livestreamstreamer',
            'livestreamtags',
            'image',
            'audiodescriptionfile',
            'audiodescriptionstate',
            'audiodescriptionvolume',
            'mplayerstart',
            'tags',
            'title',
            'type',
            'backcolor',
            'frontcolor',
            'lightcolor',
            'screencolor',
            'controlbar',
            'smoothing',
            'height',
            'playlist',
            'playlistsize',
            'skin',
            'width',
            'autostart',
            'bufferlength',
            'fullscreen',
            'icons',
            'item',
            'logoboxalign',
            'logoboxfile',
            'logoboxlink',
            'logoboxmargin',
            'logoboxposition',
            'logofile',
            'logolink',
            'logohide',
            'logoposition',
            'mute',
            'quality',
            'mplayerrepeat',
            'resizing',
            'shuffle',
            'state',
            'stretching',
            'volume',
            'plugins',
            'streamer',
            'tracecall',
            'captionsback',
            'captionsfile',
            'captionsfontsize',
            'captionsstate',
            'fpversion',
            'notes',
            'metaviewerposition',
            'metaviewersize',
            'searchbarcolor',
            'searchbarlabel',
            'searchbarposition',
            'searchbarscript',
            'snapshotbitmap',
            'snapshotscript',
            ));

        $mplayer->set_source_table('mplayer', array('id' => backup::VAR_ACTIVITYID));

        $mplayer->annotate_files('mod_mplayer', 'intro', null); // no itemid used
        $mplayer->annotate_files('mod_mplayer', 'mplayerfile', null); // no itemid used

        // return the root element (mplayer), wrapped into standard activity structure
        return $this->prepare_activity_structure($mplayer);
    }
}
