<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  2013 NPO CCC-TIES <info@cccties.org>
 * @author Codia <system.info@codia.co.jp>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
**/

// Check that config.php exists, if not then call the install script
if (!file_exists('../../../config.php')) {
    header('Location: ../install.php');
    die();
}
// ライブラリなどの読み込み
require_once("../../../config.php");
require_once($CFG->dirroot."/course/lib.php");
require_once($CFG->dirroot.'/local/ties/lib.php');
require_once($CFG->libdir . '/adminlib.php');

admin_externalpage_setup('ties_settings');

// ログインチェック
require_login(0, false);

// 権限チェック（管理者のみ）
$context = get_context_instance(CONTEXT_SYSTEM);
require_capability('moodle/site:config', $context);

$site = get_site();

$systemcontext = get_context_instance(CONTEXT_SYSTEM);

// 初期設定
$PAGE->set_url('/local/ties/admin/error.php');
$PAGE->set_context($systemcontext);
$PAGE->set_pagelayout('admin');

// レイアウト設定
$PAGE->set_title("$site->shortname: " .get_string('error_title', 'local_ties') );
$PAGE->set_heading($COURSE->fullname);
echo $OUTPUT->header();
echo $OUTPUT->heading(get_string('error_pagetitle', 'local_ties'));

echo html_writer::tag('h3', get_string('error_headline', 'local_ties'));
echo html_writer::tag('p', get_string('error_detail', 'local_ties'));


echo $OUTPUT->footer();

