<?php
/**
 * Authentication Plugin: Forum Ties Authentication
 *
 * 2013-05 File created.
 */

define('TIES_FORUM_URL'					, 'http://tiestest.codia/');

define('TIES_FORUM_MODULE_JUMP'			, '/auth/forumties/jump.php');
define('TIES_FORUM_MODULE_LAND'			, '/auth/forumties/land.php');

define('ERR_NO_TIES_PACKAGE'			, 'TIESパッケージプログラムエラー');
define('ERR_TIES_FORUM_CONNECT_FAILURE'	, 'TIES Forumへ接続ができませんでした（%s）');
define('ERR_TIES_FORUM_UNEXPECTED'		, 'TIES Forumとの通信に失敗しました');

require_once 'config.php';
require_once 'lib/filelib.php';

if (!isloggedin() or isguestuser()) redirect(get_login_url());

if ( !strlen(trim($CFG->downloadurl)) ) {
	if (!file_exists($CFG->dirroot.'/local/ties/version.php')) {
		throw new forum_ties_exception(ERR_NO_TIES_PACKAGE);
	}
}

// moodleにとってcurlは必須（エラー言語ファイルはmentのを利用）
if (!extension_loaded('curl')) print_error('nocurl', 'mnet');

$params = array();
$params['wr'] = rtrim($CFG->wwwroot, '/');
$params['sf'] = $SITE->fullname;
$params['si'] = $CFG->siteidentifier;
$params['un'] = $USER->username;
$params['fn'] = $USER->firstname;
$params['ln'] = $USER->lastname;
$params['em'] = $USER->email;
$params['in'] = $USER->institution;

$postdata = format_postdata_for_curlcall($params);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL			, TIES_FORUM_URL.TIES_FORUM_MODULE_JUMP);
curl_setopt($ch, CURLOPT_POST			, true);
curl_setopt($ch, CURLOPT_POSTFIELDS		, $postdata);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER	, false);
curl_setopt($ch, CURLOPT_RETURNTRANSFER	, true);
curl_setopt($ch, CURLOPT_USERAGENT		, $_SERVER['HTTP_USER_AGENT']);

$response = curl_exec($ch);

if (curl_errno($ch))
{
	throw new forum_ties_exception(sprintf(ERR_TIES_FORUM_CONNECT_FAILURE, curl_error($ch)));
}

curl_close($ch);

$json = json_decode($response);

if ( $json===null )
{
	// 異常
	throw new forum_ties_exception(ERR_TIES_FORUM_UNEXPECTED);
}
elseif ( $json->token )
{
	redirect(TIES_FORUM_URL.TIES_FORUM_MODULE_LAND."?token=".$json->token);
}
else
{
	throw new forum_ties_exception($json->exception->errmsg);
}

exit;

/**
 * forum_ties用例外処理
 */
class forum_ties_exception extends Exception
{
    public function __construct($message) { parent::__construct($message, 0); }
}
