<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'ja', branch 'MOODLE_20_STABLE'
 *
 * @package   question
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adminreport'] = 'あなたの問題データベースで可能性のある不具合をレポートします。';
$string['availableq'] = '利用可能?';
$string['badbase'] = '**: {$a}** の前のbaseが正しくありません。';
$string['broken'] = 'これは存在しないファイルをポイントする「壊れたリンク」です。';
$string['byandon'] = '<em>{$a->time}</em> (ユーザ: <em>{$a->user}</em>)';
$string['cannotcopybackup'] = 'バックアップファイルをコピーできませんでした。';
$string['cannotcreate'] = 'question_attemptsテーブルに新しいエントリを作成できませんでした。';
$string['cannotcreatepath'] = 'パスを作成できません: {$a}';
$string['cannotdeletecate'] = 'このコンテクストのデフォルトカテゴリのため、あなたはカテゴリを削除できません。';
$string['cannotenable'] = '問題タイプ {$a} は直接作成できません。';
$string['cannotfindcate'] = 'カテゴリレコードが見つかりませんでした。';
$string['cannotfindquestionfile'] = 'ZIPファイル内に問題データファイルが見つかりませんでした。';
$string['cannotgetdsfordependent'] = 'データセットに依存した問題のデータセットを取得できませんでした! (問題: {$a->id}, データセットアイテム: {$a->item})';
$string['cannotgetdsforquestion'] = '計算問題のデータセットを取得できませんでした! (問題: {$a})';
$string['cannothidequestion'] = '問題を非表示にできませんでした。';
$string['cannotimportformat'] = '申し訳ございません、このフォーマットでのインポートは、まだ実装されていません!';
$string['cannotinsertquestion'] = '新しい問題を追加できませんでした!';
$string['cannotinsertquestioncatecontext'] = 'コンテクストID {$a->ctx} が無効のため、新しい問題カテゴリ {$a->cat} を追加できませんでした。';
$string['cannotloadquestion'] = '問題を読み込めませんでした。';
$string['cannotmovequestion'] = 'あなたは異なる場所のファイルと関連付けてある問題を移動するため、このスクリプトを使用できません。';
$string['cannotopenforwriting'] = '書き込みオープンできません: {$a}';
$string['cannotpreview'] = 'あなたは、これらの問題をプレビューできません。';
$string['cannotretrieveqcat'] = '問題カテゴリを検索できませんでした。';
$string['cannotunhidequestion'] = '問題の非表示解除に失敗しました。';
$string['cannotunzip'] = 'ZIPファイルを解凍できません。';
$string['cannotwriteto'] = '{$a} にエクスポート問題を書き込めません。';
$string['categorycurrent'] = '現在のカテゴリ';
$string['categorycurrentuse'] = 'このカテゴリを使用する';
$string['categorydoesnotexist'] = 'このカテゴリは存在しません。';
$string['categorymoveto'] = 'カテゴリに保存する';
$string['changepublishstatuscat'] = 'コース内の <a href="{$a->caturl}">カテゴリ「 {$a->name} 」</a> の共有ステータスが <strong>{$a->changefrom} から {$a->changeto}</strong> に変更されます。';
$string['chooseqtypetoadd'] = '追加する問題タイプを選択する';
$string['clicktoflag'] = 'この問題にフラグ付けするには、ここをクリックしてください。';
$string['clicktounflag'] = 'この問題のフラグを解除するには、ここをクリックしてください。';
$string['contexterror'] = 'あなたがカテゴリを他のコンテクストに移動する場合、ここには移動できません。';
$string['copy'] = '{$a} からコピーおよびリンクを変更する。';
$string['created'] = '作成日時';
$string['createdby'] = '作成者';
$string['createdmodifiedheader'] = '作成日時/最終更新日時';
$string['createnewquestion'] = '新しい問題を作成する ...';
$string['cwrqpfs'] = 'ランダム問題がサブカテゴリより問題を選択しています。';
$string['cwrqpfsinfo'] = '<p>Moodle 1.9へのアップグレード中、問題カテゴリは異なるコンテクストに移動されます。あなたのサイトのいくつかの問題カテゴリおよび問題では、共有ステータスを変更する必要があります。これは、(このサイトに関して) 小テストの1つまたはそれ以上の「ランダム」問題が共有および未共有のカテゴリ内から混在して問題を選択するよう設定されている場合に生じる、まれなケースに対処するため必要です。「ランダム」問題がサブカテゴリ群より問題を選択し、ランダム問題が作成される1またはそれ以上のサブカテゴリが親カテゴリに対して異なる共有ステータスを持っている場合、この問題が生じます。</P>
<p>Moodle 1.9へのアップグレード中、「ランダム」問題が選択されている次のカテゴリの親カテゴリは「ランダム」問題が作成されているカテゴリと同じ共有ステータスに変更されます。次のカテゴリでは共有ステータスが変更されます。あなたが小テストより削除するまで、影響を受ける問題はすべての小テスト内で継続して動作します。</p>';
$string['cwrqpfsnoprob'] = 'あなたのサイト内で「サブカテゴリから問題を選択しているランダム問題」に関する問題に影響している問題カテゴリはありません。';
$string['defaultfor'] = '{$a} のデフォルト';
$string['defaultinfofor'] = 'コンテクスト「 {$a} 」で共有される問題のデフォルトカテゴリ';
$string['deletecoursecategorywithquestions'] = 'このコースカテゴリに関連する問題バンクに問題が登録されています。あなたが続けた場合、問題が削除されます。問題バンクのインターフェースを使用して、最初に問題を移動してください。';
$string['disabled'] = '利用不可';
$string['disterror'] = 'ディストリビューション {$a} が問題の原因となっています。';
$string['donothing'] = 'ファイルをコピーまたは移動またはリンクを変更しない。';
$string['editcategories'] = 'カテゴリを編集する';
$string['editcategories_help'] = 'あなたのすべての問題を1つの大きなリストに保持するより、カテゴリおよびサブカテゴリ内に問題を入れることができます。

それぞれのカテゴリには、どこでカテゴリ内の問題が使用されるか決定するコンテクストが割り当てられます:

* 活動コンテクスト - 活動モジュールのみで使用できる問題
* コースコンテクスト - コース内の活動モジュールすべてで使用できる問題
* コースカテゴリコンテクスト - コースカテゴリ内すべての活動モジュールおよびコースで使用できる問題
* システムコンテクスト - サイト内すべてのコースおよび活動で使用できる問題

ランダム問題が特定カテゴリから問題を選択するために、カテゴリを使用することもできます。';
$string['editingcategory'] = 'カテゴリの編集';
$string['editingquestion'] = '問題の編集';
$string['editthiscategory'] = 'このカテゴリを編集する';
$string['emptyxml'] = '不明なエラー: imsmanifest.xmlが空です。';
$string['enabled'] = '利用可能';
$string['erroraccessingcontext'] = 'コンテクストにアクセスできません。';
$string['errordeletingquestionsfromcategory'] = 'カテゴリ {$a} から問題を削除中にエラーが発生しました。';
$string['errorduringpost'] = '処理後にエラーが発生しました!';
$string['errorduringpre'] = '処理前にエラーが発生しました!';
$string['errorduringproc'] = '処理中にエラーが発生しました!';
$string['errorduringregrade'] = '問題 {$a->qid} を再評定できませんでした。状態 {$a->stateid} へ移動します。';
$string['errorfilecannotbecopied'] = 'エラー: ファイル {$a} をコピーできません。';
$string['errorfilecannotbemoved'] = 'エラー: ファイル {$a} を移動できません。';
$string['errorfileschanged'] = 'エラー: 問題からリンクされているファイルがフォーム表示後に変更されました。';
$string['errormanualgradeoutofrange'] = '問題 {$a->name} の評点 {$a->grade} が、ゼロおよび {$a->maxgrade} の範囲にありません。評点およびコメントは、保存されませんでした。';
$string['errormovingquestions'] = 'ID {$a} の問題の移動中にエラーが発生しました。';
$string['errorpostprocess'] = '後処理中にエラーが発生しました!';
$string['errorpreprocess'] = '前処理中にエラーが発生しました!';
$string['errorprocess'] = '処理中にエラーが発生しました!';
$string['errorprocessingresponses'] = 'あなたの解答の処理中にエラーが発生しました。';
$string['errorsavingcomment'] = '問題 {$a->name} のコメントをデータベースに保存中にエラーが発生しました。';
$string['errorupdatingattempt'] = 'データベース内の受験結果 {$a->id} を更新中にエラーが発生しました。';
$string['exportcategory'] = 'エクスポートカテゴリ';
$string['exportcategory_help'] = 'この設定では問題のエクスポート元カテゴリを決定します。

GIFTおよびMoodle XMLのような特定のインポートフォーマットでは、エクスポートファイルにカテゴリおよびコンテクストデータを含むこと、インポート時に (任意で) 再作成することができます。必要な場合、適切なチェックボックスをチェックしてください。';
$string['exporterror'] = 'エクスポート中にエラーが発生しました!';
$string['exportfilename'] = 'quiz';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportquestions'] = '問題をファイルにエクスポートする';
$string['exportquestions_help'] = '<p>この機能では1つのカテゴリ (およびすべてのサブカテゴリ) の問題すべてをテキストファイルにエクスポートすることができます。</p>

<p>多くのファイルフォーマットで、問題がエクスポートされるときに、情報が失われる可能性があることに注意してください。これは多くのフォーマットが、Moodleの小テスト問題の機能すべてを処理できるわけではないためです。問題がエクスポートできることや、インポートできること、エクスポートしてインポートした問題が同一であることを期待しないでください。また、ある問題タイプは全くエクスポートされない場合もあります。実稼動環境で使用する前に、エクスポートデータをチェックすることをお勧めします。</p>

<p>現在サポートされているフォーマットは下記のとおりです:</p>

<h2>GIFTフォーマット</h2>

<p>GIFTはMoodleの小テストをテキストファイルにエクスポートするための、最も包括的なインポート・エクスポートフォーマットです。GIFTは教師が問題をテキストファイルで簡単に書くことができるように設計されています。多肢選択問題、○/×問題、記述問題、組み合わせ問題、数値問題、_____を挿入することで「穴埋め問題」をサポートします。Cloze問題は現在はサポートされていないことに注意してください。
様々なタイプの問題およびコメント、問題名、フィードバック、評点の加重割合を1つのテキストファイルに記述することができます。次に例をあげます:</p>

<pre>
グラントの墓には誰が埋められていますか?{~グラント ~ジェファーソン =誰も埋められていない}

グラントはグラントの墓に {~埋められている =埋葬されている ~生きている} 。

グラントはグラントの墓に埋められている。{FALSE}

グラントの墓には誰が埋められていますか?{=誰も埋められていない =1人も埋められていない}

ユリシーズ S. グラントはいつ生まれましたか?{#1822}
</pre>

<p class="moreinfo"><a href="help.php?file=formatgift.html&module=quiz">「GIFT」フォーマットの詳細情報</a></p>

<h2>Moodle XMLフォーマット</h2>

<p>このMoodle特有のフォーマットは小テスト問題をシンプルなXMLフォーマットにエクスポートします。エクスポートしたファイルを他の小テストカテゴリにインポートしたり、XSLTのような他の処理に使用することができます。XMLフォーマットでは問題に添付されているイメージを (base64エンコードで) エクスポートします。</p>

<h2>IMS QTI 2.0</h2>

<p>標準的なIMS QTI (version 2.0) フォーマットでエクスポートします。この機能ではファイル群を単一のZipファイルに圧縮します。</p>
<p class="moreinfo"><a href="http://www.imsglobal.org/question/" target="_qti">IMS QTIフォーマットの詳細情報</a> (外部サイトを別のウィンドウに開きます)</p>

<h2>XHTML</h2>

<p>カテゴリを1ページの厳密なXHTMLにエクスポートします。それぞれの問題は明確に&lt;div&gt;タグの中に入れられます。このファイルをそのまま使いたい場合は少なくとも&lt;body&gt;タグの最初にある&lt;form&gt;タグを編集して適切な処理を入れてください。(例 \'mailto\')</p>

<p>インポートおよびエクスポートフォーマットは脱着可能なリソースです。他のオプションフォーマットはモジュールおよびプラグインデータベースで利用することができます。</p>';
$string['filecantmovefrom'] = 'あなたには問題の移動を試みている移動元からファイルを削除するパーミッションがないため、問題ファイルを移動することができません。';
$string['filecantmoveto'] = 'あなたには問題のコピーを試みている移動先にファイルを追加するパーミッションがないため、問題ファイルを移動またはコピーすることができません。';
$string['filesareacourse'] = 'コースファイルエリア';
$string['filesareasite'] = 'サイトファイルエリア';
$string['filestomove'] = '{$a} にファイルを移動/コピーしますか?';
$string['flagged'] = 'フラグ済み';
$string['flagthisquestion'] = 'この問題にフラグ付けする';
$string['formquestionnotinids'] = '問題IDがない問題がフォームに含まれています。';
$string['fractionsnomax'] = 'この問題で満点を取ることができるよう、答えの1つに評点100%を指定してください。';
$string['getcategoryfromfile'] = 'ファイルからカテゴリを取得する';
$string['getcontextfromfile'] = 'ファイルからコンテクストを取得する';
$string['ignorebroken'] = 'リンク切れを無視する';
$string['importcategory'] = 'インポートカテゴリ';
$string['importcategory_help'] = 'この設定では問題のインポート先カテゴリを決定します。

GIFTおよびMoodle XMLのような特定のインポートフォーマットでは、インポートファイルにカテゴリおよびコンテクストデータを含むことができます。選択されたカテゴリではなく、このデータを使用するには、適切なチェックボックスをチェックしてください。インポートファイル内で指定されたカテゴリが存在しない場合、作成されます。';
$string['importquestions'] = 'ファイルから問題をインポートする';
$string['importquestions_help'] = 'この機能ではテキストファイルを使用して様々なフォーマットで問題をインポートすることができます。ファイルにはUTF-8文字コードを使用する必要があることに留意してください。';
$string['impossiblechar'] = '丸括弧として使用できない文字 {$a} が見つかりました。';
$string['invalidarg'] = '有効ではない引数が提供されたか、サーバ設定が正しくありません。';
$string['invalidcategoryidforparent'] = '親カテゴリに対するカテゴリIDが無効です!';
$string['invalidcategoryidtomove'] = '移動するカテゴリIDが無効です!';
$string['invalidconfirm'] = '確認ストリングが正しくありません。';
$string['invalidcontextinhasanyquestions'] = '無効なコンテクストが「question_context_has_any_questions」に移動しました。';
$string['invalidwizardpage'] = 'ウィザードページが正しくないか、指定されていません!';
$string['lastmodifiedby'] = '最終更新日時';
$string['linkedfiledoesntexist'] = 'リンクファイル {$a} がありません。';
$string['makechildof'] = '「 {$a} 」の子にする';
$string['maketoplevelitem'] = 'トップレベルに移動する';
$string['matchgrades'] = '評点の合致';
$string['matchgrades_help'] = '<p>インポートされた評点は下記の有効な評点一覧に合致する<b>必要があります</b>。</p>

<ul>
<li>100%</li>
<li>90%</li>
<li>80%</li>
<li>75%</li>
<li>70%</li>
<li>66.666%</li>
<li>60%</li>
<li>50%</li>
<li>40%</li>
<li>33.333</li>
<li>30%</li>
<li>25%</li>
<li>20%</li>
<li>16.666%</li>
<li>14.2857</li>
<li>12.5%</li>
<li>11.111%</li>
<li>10%</li>
<li>5%</li>
<li>0%</li>
</ul>

<p>上記一覧のマイナス値も使用することができます。</p>

<p>このオプションには2種類の設定があります。これらの設定は上記一覧に<strong>正確に</strong>合致しない値を、インポートルーチンがどのように処理するかに影響します。</p>

<ul>
<li><strong>評点が一覧にない場合、エラーにする</strong><br />
一覧にない評点が問題に含まれている場合、エラーが表示され、その問題はインポートされません。</li>
<li><strong>評点が一覧にない場合、最も近い評点を使用する</strong><br />
一覧にない評点が問題に含まれている場合、評点は一覧の中で一番近い値に変更されます。</li>
</ul>

<p><i>注意: いくつかのカスタムインポートフォーマットではデータベースにデータを直接書き込み、このチェックをバイパスします。</i></p>';
$string['missingcourseorcmid'] = 'print_questionに対して、コースIDまたはコースモジュールIDを提供する必要があります。';
$string['missingcourseorcmidtolink'] = 'get_question_edit_linkに対して、コースIDまたはコースモジュールIDを提供する必要があります。';
$string['missingimportantcode'] = 'この問題タイプには、重要なコードがありません: {$a}';
$string['missingoption'] = '穴埋め問題 (Cloze) {$a} のオプションがありません。';
$string['modified'] = '最終更新日時';
$string['move'] = '{$a} から移動およびリンクを変更する。';
$string['movecategory'] = 'カテゴリを移動する';
$string['movedquestionsandcategories'] = '問題および問題カテゴリを {$a->oldplace} から {$a->newplace} に移動しました。';
$string['movelinksonly'] = 'リンクが指している場所のみ変更して、ファイルを移動およびコピーしない。';
$string['moveq'] = '問題を移動する';
$string['moveqtoanothercontext'] = '問題を他のコンテクストに移動する';
$string['movingcategory'] = 'カテゴリの移動';
$string['movingcategoryandfiles'] = '本当にカテゴリ「 {$a->name} 」およびすべての子カテゴリを「 {$a->contextto} 」のコンテクストに移動してもよろしいですか?<br /> {$a->urlcount} のファイルが {$a->fromareaname} の問題よりリンクされているようです。これらのファイルを {$a->toareaname} にコピーまたは移動してもよろしいですか?';
$string['movingcategorynofiles'] = '本当にカテゴリ「 {$a->name} 」およびすべての子カテゴリを「 {$a->contextto} 」のコンテクストに移動してもよろしいですか?';
$string['movingquestions'] = '問題およびすべてのファイルの移動';
$string['movingquestionsandfiles'] = '本当に問題 {$a->questions} を<strong>「 {$a->tocontext} 」</strong>のコンテクストに移動してもよろしいですか?<br /> {$a->urlcount} のファイルが {$a->fromareaname} の問題よりリンクされているようです。これらのファイルを {$a->toareaname} にコピーまたは移動してもよろしいですか?';
$string['movingquestionsnofiles'] = '本当に問題 {$a->questions} を<strong>「 {$a->tocontext} 」</strong>のコンテクストに移動してもよろしいですか?<br />{$a->fromareaname} の問題からリンクされているファイルは<strong>ありません</strong>。';
$string['needtochoosecat'] = 'このカテゴリを移動するにはカテゴリを選択してください。または「キャンセル」をクリックしてください。';
$string['nocate'] = 'カテゴリがありません  {$a} !';
$string['nopermissionadd'] = 'あなたには、ここに問題を追加するパーミッションがありません。';
$string['nopermissionmove'] = 'あなたには、ここから問題を移動するパーミッションがありません。あなたは、このカテゴリに問題を保存するか、新しい問題として保存する必要があります。';
$string['noprobs'] = 'あなたの問題データベースに問題は見つかりませんでした。';
$string['notenoughdatatoeditaquestion'] = '問題ID、カテゴリIDおよび問題タイプが指定されていません。';
$string['notenoughdatatomovequestions'] = 'あなたが移動したい問題の問題IDを提供してください。';
$string['notflagged'] = 'フラグなし';
$string['novirtualquestiontype'] = '問題タイプ {$a} には、バーチャル問題タイプがありません。';
$string['parentcategory'] = '親カテゴリ';
$string['parentcategory_help'] = '<h2>親</h2>

<p>このカテゴリが配置されているカテゴリです。「トップ」はこのカテゴリが他のカテゴリに含まれていないことを意味します。</p>

<p>通常、いくつかの太字のカテゴリ「コンテクスト」が表示され、それぞれのコンテクストには独自のカテゴリ階層が含まれます。コンテクストに関して、下記関連情報をご覧ください。いくつかのコンテクストが表示されない場合、あなたには他のコンテクストにアクセスするパーミッションがないことが考えられます。</p>

<p>コンテクスト内に少なくとも1つのカテゴリを登録する必要があるため、コンテクスト内に1つのカテゴリのみある場合、あなたはカテゴリを他へ移動することができません。</p>

<p>関連情報 :</p>
<ul>
  <li><a href="help.php?module=question&amp;file=categories.html">問題カテゴリ</a></li>
  <li><a href="help.php?module=question&amp;file=categorycontexts.html">カテゴリコンテクスト</a></li>
  <li><a href="help.php?module=question&amp;file=permissions.html">問題パーミッション</a></li>
</ul>';
$string['parenthesisinproperclose'] = '{$a}** 内の ** の前で丸括弧が適切に閉じていません。';
$string['parenthesisinproperstart'] = '{$a}** 内の ** の前で丸括弧が適切に始まっていません。';
$string['penaltyfactor'] = 'ペナルティ要素';
$string['penaltyfactor_help'] = '<p>ここではそれぞれの間違った解答に対して、差し引く評点の割合を指定することができます。これは問題に繰り返し答えることのできる、アダプティブモードで小テストが動作している場合のみ関係があります。ペナルティ要素は0から1の間に設定してください。ペナルティ要素が１の場合、学生は単位を得るため、最初の解答で正解する必要があります。ペナルティ要素が0の場合、学生は満点になるまで何度でも好きなだけ受験することができます。</p>';
$string['permissionedit'] = 'この問題を編集する';
$string['permissionmove'] = 'この問題を移動する';
$string['permissionsaveasnew'] = 'この問題を新しい問題として保存する';
$string['permissionto'] = 'あなたのパーミッションは下記のとおりです:';
$string['published'] = '共有';
$string['qtypeveryshort'] = 'T';
$string['questionaffected'] = '<a href="{$a->qurl}">問題「 {$a->name}」({$a->qtype})</a> は、この問題カテゴリ内にありますが、別のコース「 {$a->coursename} 」の <a href="{$a->qurl}">小テスト「 {$a->quizname} 」</a> でも使用されています。';
$string['questionbank'] = '問題バンク';
$string['questioncategory'] = '問題カテゴリ';
$string['questioncatsfor'] = '「 {$a} 」の問題カテゴリ';
$string['questiondoesnotexist'] = 'この問題は存在しません。';
$string['questionname'] = '問題名';
$string['questionsaveerror'] = '問題の保存中にエラーが発生しました - ({$a})';
$string['questionsmovedto'] = '使用中の問題が、親コースカテゴリの「 {$a} 」に移動されました。';
$string['questionsrescuedfrom'] = '問題がコンテクスト {$a} より保存されました。';
$string['questionsrescuedfrominfo'] = 'いくつかの小テストまたは他の活動で使用されているため、これらの問題 (いくつかは非表示) はコンテクスト {$a} 削除時に保存されました。';
$string['questiontype'] = '問題タイプ';
$string['questionuse'] = 'この活動で問題を使用する';
$string['saveflags'] = 'フラグの状態を保存する';
$string['selectacategory'] = 'カテゴリを選択してください:';
$string['selectaqtypefordescription'] = '説明を表示するには、問題タイプを選択してください。';
$string['selectquestionsforbulk'] = 'バルク処理の問題を選択する';
$string['shareincontext'] = '{$a} でコンテクストを共有する';
$string['stoponerror'] = 'エラーで中止する';
$string['stoponerror_help'] = 'この設定ではエラー検出時にインポート処理を停止するかどうか決定します。結果として問題が全くインポートされない、またはエラーを含んだ問題を無視して有効な問題のみインポートされます。';
$string['tofilecategory'] = 'ファイルにカテゴリを書き出す';
$string['tofilecontext'] = 'ファイルにコンテクストを書き出す';
$string['unknown'] = '不明';
$string['unknownquestiontype'] = '不明な問題タイプ「 {$a} 」です。';
$string['unknowntolerance'] = '不明な許容誤差タイプ「 {$a} 」です。';
$string['unpublished'] = '非共有';
$string['upgradeproblemcategoryloop'] = '問題カテゴリのアップグレード中に問題が発生しました。カテゴリツリーにループがあります。影響のあるカテゴリIDは、{$a} です。';
$string['upgradeproblemcouldnotupdatecategory'] = '問題カテゴリ「 {$a->name} ({$a->id}) 」をアップグレードできませんでした。';
$string['upgradeproblemunknowncategory'] = '問題カテゴリのアップグレード中に問題が発生しました。カテゴリ「 {$a->id} 」が存在しない親カテゴリ「 {$a->parent} 」を参照しています。問題を修正するため、親カテゴリを変更しました。';
$string['wrongprefix'] = '問題名接頭辞のフォーマット「 {$a} 」が正しくありません。';
$string['youmustselectaqtype'] = 'あなたは問題タイプを選択する必要があります。';
$string['yourfileshoulddownload'] = 'あなたのエクスポートファイルのダウンロードは、まもなく始まります。ダウンロードされない場合、<a href="{$a}">ここをクリックしてください</a>。';
