<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'scorm', language 'ja', branch 'MOODLE_20_STABLE'
 *
 * @package   scorm
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activation'] = 'アクティベーション';
$string['activityloading'] = 'あなたは次の時間経過後、自動的にリダイレクトされます:';
$string['activitypleasewait'] = '活動読み込み中、お待ちください ...';
$string['advanced'] = 'パラメータ';
$string['allowapidebug'] = 'アクティブAPIデバッグおよびトレース (apidebugmaskでキャプチャマスクを設定します)';
$string['allowtypeexternal'] = '外部パッケージタイプを有効にする';
$string['allowtypeimsrepository'] = 'IMSパッケージタイプを有効にする';
$string['allowtypelocalsync'] = 'ダウンロード済みパッケージタイプを有効にする';
$string['apidebugmask'] = 'APIデバッグキャプチャマスク - <username>:<activityname> でシンプルなregexを使用します。例) admin:.* は管理ユーザ (admin) のみのデバッグとなります。';
$string['areacontent'] = 'コンテンツファイル';
$string['areapackage'] = 'パッケージファイル';
$string['asset'] = 'アセット';
$string['assetlaunched'] = 'アセット - 閲覧済み';
$string['attempt'] = '受験';
$string['attempt1'] = '受験 1';
$string['attempts'] = '受験';
$string['attemptsx'] = '受験 {$a}';
$string['attr_error'] = 'タグ {$a->tag} のアトリビュート ({$a->attr}) に不適切な値が設定されています。';
$string['autocontinue'] = '自動継続';
$string['autocontinuedesc'] = 'ここでは活動のデフォルト自動継続を設定します。';
$string['autocontinue_help'] = '<p>自動継続を「Yes」にした場合、学習オブジェクトが「close communication」メソッドをコールすることで、自動的に次の利用可能な学習オブジェクトが起動されます。</p>

<p>「No」にした場合、ユーザは次に進むため「続ける」ボタンをクリックする必要があります。</p>';
$string['averageattempt'] = '平均評点';
$string['badmanifest'] = 'マニフェストエラー: エラーログをご覧ください。';
$string['badpackage'] = '指定されたパッケージ/マニフェストは有効ではありません。確認した後、もう一度お試しください。';
$string['browse'] = 'プレビュー';
$string['browsed'] = '閲覧済み';
$string['browsemode'] = 'プレビューモード';
$string['browserepository'] = 'リポジトリの閲覧';
$string['cannotfindsco'] = 'SCOを見つけることができませんでした。';
$string['chooseapacket'] = 'パッケージの選択または更新';
$string['completed'] = '完了';
$string['confirmloosetracks'] = '警告: パッケージが変更/修正されたようです。パッケージ構造が変更された場合、更新処理中にユーザのトラックが失われる可能性があります。';
$string['contents'] = 'コンテンツ';
$string['coursepacket'] = 'コースパッケージ';
$string['coursestruct'] = 'コース構造';
$string['currentwindow'] = '現在のウィンドウ';
$string['datadir'] = 'ファイルシステムエラー: コースデータディレクトリを作成できません。';
$string['deleteallattempts'] = 'すべてのSCORM受験を削除する';
$string['deleteattemptcheck'] = '本当にこれらの受験を完全に削除してもよろしいですか?';
$string['details'] = 'トラック詳細';
$string['directories'] = 'ディレクトリリンクを表示する';
$string['display'] = 'パッケージの表示';
$string['displayattemptstatus'] = '受験状況を表示する';
$string['displayattemptstatusdesc'] = 'ここでは受験状況の表示に関するデフォルト値を設定します。';
$string['displayattemptstatus_help'] = 'このオプションを有効にした場合、学生の受験状況をSCORMアウトラインページに表示します。';
$string['displaycoursestructure'] = 'エントリページにコース構造を表示する';
$string['displaycoursestructuredesc'] = 'ここではエントリページ設定のコース構造表示に関するデフォルト値を設定します。';
$string['displaycoursestructure_help'] = 'このオプションを有効にした場合、コンテンツのSCORMテーブルをSCORMアウトラインページに表示します。';
$string['displaydesc'] = 'ここでは活動に対してパッケージを表示するかどうか設定します。';
$string['domxml'] = 'DOMXML外部ライブラリ';
$string['duedate'] = '終了日時';
$string['element'] = '要素';
$string['enter'] = '問題に入る';
$string['entercourse'] = 'コースに入る';
$string['errorlogs'] = 'エラーログ';
$string['everyday'] = '毎日';
$string['everytime'] = '毎回使用されるたびに';
$string['exceededmaxattempts'] = 'あなたは最大受験数に到達しました。';
$string['exit'] = 'コースから抜ける';
$string['exitactivity'] = '活動から抜ける';
$string['expired'] = '申し訳ございません、この活動は {$a} に終了しているため、これ以上利用することはできません。';
$string['external'] = '外部パッケージを更新するタイミング';
$string['failed'] = '失敗';
$string['finishscorm'] = 'あなたがこのリソースの閲覧を終了した場合、{$a}';
$string['finishscormlinkname'] = 'ここをクリックしてコースに戻ってください。';
$string['firstaccess'] = '最初のアクセス';
$string['firstattempt'] = '最初の受験';
$string['forcecompleted'] = '完了を強制する';
$string['forcecompleteddesc'] = 'ここでは完了の強制に関するデフォルト値を設定します。';
$string['forcecompleted_help'] = 'このオプションを有効にした場合、SCORM 1.2パッケージのみに関連するcmi.core.score.rawが含まれているコンテンツに対して、現在の受験状況を確実に「完了」状態にします。
レビューまたはブラウズモードにおいて、SCORMパッケージが正常に再受験を処理できない場合、この設定が有用です。このような状態で完了を強制しない場合、正しくない完了状況が設定されてしまいます。';
$string['forcejavascript'] = 'ユーザにJavaスクリプトの有効化を強制する';
$string['forcejavascript_desc'] = 'このオプションを有効にした場合 (推奨)、ユーザのブラウザでJavaスクリプトをサポートしていない場合にSCORMオブジェクトへのアクセスを防ぎます。無効にした場合、ユーザはSCORMを閲覧することはできますが、API接続が失敗するため、評定情報が保存されることはありません。';
$string['forcejavascriptmessage'] = 'このオブジェクトを閲覧するにはJavaスクリプトが必要です。あなたのブラウザのJavaスクリプトを有効にして、再度お試しください。';
$string['forcenewattempt'] = '新しい受験を強制する';
$string['forcenewattemptdesc'] = 'ここでは新しい受験の強制に関するデフォルト値を設定します。';
$string['forcenewattempt_help'] = 'このオプションを有効にした場合、SCORMパッケージへのアクセスすべてを新しい受験とします。';
$string['found'] = 'マニフェストファイルが見つかりました。';
$string['frameheight'] = 'ここではステージフレームまたはウィンドウのデフォルトの高さを設定します。';
$string['framewidth'] = 'ここではステージフレームまたはウィンドウのデフォルトの幅を設定します。';
$string['fullscreen'] = 'フルスクリーンモード';
$string['general'] = '一般データ';
$string['gradeaverage'] = '平均評点';
$string['gradeforattempt'] = '受験の評点';
$string['gradehighest'] = '最高評点';
$string['grademethod'] = '評定方法';
$string['grademethoddesc'] = 'ここでは活動に対するデフォルト評定方法を設定します。';
$string['grademethod_help'] = '評定方法では活動の受験がどのように評定されるか決定します。

以下4つの評定方法があります:

* 学習オブジェクト - 完了/パスした活動の学習オブジェクト数です。
* 最高評点 - すべてのパスした学習オブジェクトにおけるユーザの最高評点です。</li>
* 平均評点 - すべての評点の平均です。
* 評点の合計 - すべての評点の合計です。';
$string['gradereported'] = '記録済み評定';
$string['gradescoes'] = '学習オブジェクト';
$string['gradesum'] = '評点の合計';
$string['height'] = '高さ';
$string['hidden'] = '隠す';
$string['hidebrowse'] = 'プレビューモードを無効にする';
$string['hidebrowsedesc'] = 'ここではプレビューモードの無効または有効に関するデフォルトを設定します。';
$string['hidebrowse_help'] = 'プレビューモードでは受験の前に、学生が活動を閲覧することができます。このオプションを有効にした場合、SCORM/AICCパッケージ活動ページのプレビューボタンは非表示にされます。';
$string['hideexit'] = 'コースから抜けるボタンを隠す';
$string['hidenav'] = 'ナビゲーションボタンを隠す';
$string['hidenavdesc'] = 'ここではナビゲーションボタンの表示または非表示に関するデフォルトを設定します。';
$string['hidereview'] = 'レビューボタンを隠す';
$string['hidetoc'] = 'プレイヤーでコース構造を表示する';
$string['hidetocdesc'] = 'ここではSCORMプレイヤーにおけるコース構造 (TOC) の表示または非表示に関するデフォルトを設定します。';
$string['hidetoc_help'] = 'ここではSCORMプレイヤー内でどのように目次が表示されるか設定します。';
$string['highestattempt'] = '最高評点';
$string['identifier'] = '問題識別子';
$string['incomplete'] = '不完全';
$string['info'] = '情報';
$string['interactions'] = '相互作用';
$string['invalidactivity'] = 'SCORM活動が正しくありません。';
$string['last'] = '最新アクセス日時';
$string['lastaccess'] = '最新のアクセス';
$string['lastattempt'] = '最新の受験';
$string['lastattemptlock'] = '最終受験後、ロックする';
$string['lastattemptlockdesc'] = 'ここでは最終受験後のロックに関するデフォルト値を設定します。';
$string['lastattemptlock_help'] = '<p>この設定を有効にした場合、学生が割り当てられた受験をすべて完了した後、SCORMプレイヤーをロックします。</p>
<p>学生はコースアウトラインページにアクセスして、受験状況の情報を閲覧することができます。しかし、「Enter」をクリックして、SCORMプレイヤーを起動することはできません。</p>';
$string['location'] = 'ロケーションバーを表示する';
$string['max'] = '最大評点';
$string['maximumattempts'] = '受験回数';
$string['maximumattemptsdesc'] = 'ここでは活動に対するデフォルトの最大受験回数を設定します。';
$string['maximumattempts_help'] = 'ここではユーザに許可される最大受験回数を設定します。この設定値はSCORM1.2およびAICCパッケージのみで動作します。';
$string['maximumgradedesc'] = 'ここでは活動に対するデフォルトの最大評点を設定します。';
$string['menubar'] = 'メニューバーを表示する';
$string['min'] = '最小評点';
$string['missing_attribute'] = 'タグ {$a->tag} に属性 {$a->attr} がありません。';
$string['missingparam'] = '必要項目が設定されていないか、間違っています。';
$string['missing_tag'] = '{$a->tag} タグがありません。';
$string['mode'] = 'モード';
$string['modulename'] = 'SCORMパッケージ';
$string['modulename_help'] = 'SCORMおよびAICCはウェブベース学習コンテンツの相互運用性、アクセシビリティおよび再利用性を有効にする一連の仕様です。SCORM/AICCパッケージにより、SCORM/AICCパッケージをコースに含むことができます。';
$string['modulenameplural'] = 'SCORMパッケージ';
$string['navigation'] = 'ナビゲーション';
$string['newattempt'] = '新しい受験を開始する';
$string['next'] = '次へ進む';
$string['noactivity'] = '報告内容はありません。';
$string['noattemptsallowed'] = '許可された受験数';
$string['noattemptsmade'] = 'あなたの受験数';
$string['no_attributes'] = 'タグ {$a->tag} にアトリビュートがありません。';
$string['no_children'] = 'タグ {$a->tag} に子タグがありません。';
$string['nolimit'] = '受験制限なし';
$string['nomanifest'] = 'マニフェストファイルが見つかりませんでした。';
$string['noprerequisites'] = '申し訳ございません、あなたはこの学習オブジェクトにアクセスするための十分な必要条件に到達していません。';
$string['noreports'] = '表示するレポートはありません。';
$string['normal'] = 'ノーマル';
$string['noscriptnoscorm'] = 'あなたのブラウザがJava スクリプトをサポートしていないか、Java スクリプトサポートが無効にされています。このSCORMパッケージが実行されないか、データが正常に保存されません。';
$string['notattempted'] = '未受験';
$string['not_corr_type'] = 'タグ {$a->tag} のタイプが合致しません。';
$string['notopenyet'] = '申し訳ございません、この活動は {$a} まで利用することができません。';
$string['objectives'] = '学習目標';
$string['onchanges'] = '変更時いつでも';
$string['optallstudents'] = 'すべてのユーザ';
$string['optattemptsonly'] = '受験済みのユーザ';
$string['options'] = 'オプション (ブラウザにより動作しない場合もあります)';
$string['optnoattemptsonly'] = '未受験のユーザ';
$string['organization'] = '組織';
$string['organizations'] = '組織';
$string['othersettings'] = '追加設定';
$string['othertracks'] = '他のトラック';
$string['package'] = 'パッケージファイル';
$string['packagedir'] = 'ファイルシステムエラー: パッケージディレクトリを作成できません。';
$string['packagefile'] = 'パッケージファイルが指定されていません。';
$string['package_help'] = 'パッケージは有効なAICCまたはSCORMコース定義ファイルを含む、zip (または pif) 拡張子の付いたファイルです。';
$string['packageurl'] = 'URI';
$string['packageurl_help'] = 'この設定ではファイルピッカよりファイルを選択するのではなく、SCORMパッケージを指定するためのURIを有効にします。';
$string['pagesize'] = 'ページサイズ';
$string['passed'] = 'パス';
$string['php5'] = 'PHP 5 (DOMXMLネイティブライブラリ)';
$string['pluginadministration'] = 'SCORM/AICC管理';
$string['pluginname'] = 'SCORMパッケージ';
$string['popup'] = '新しいウィンドウ';
$string['popupmenu'] = 'ドロップダウンメニュー';
$string['popupopen'] = 'パッケージを新しいウィンドウで開く';
$string['popupsblocked'] = 'ポップアップウィンドウがブロックされたため、SCORMモジュールの実行を停止します。再度開始する前、あなたのブラウザ設定を確認してください。';
$string['position_error'] = '{$a->tag} タグは {$a->parent} タグの子タグになりません';
$string['preferencespage'] = 'このページ限定のプリファレンス';
$string['preferencesuser'] = 'このレポートのプリファレンス';
$string['prev'] = '前に戻る';
$string['raw'] = '実評点';
$string['regular'] = '標準マニフェストファイル';
$string['report'] = 'レポート';
$string['reportcountallattempts'] = '受験回数: {$a->nbattempts} / ユーザ数: {$a->nbusers} (該当数: {$a->nbresults})';
$string['reportcountattempts'] = '受験回数: {$a->nbresults} ({$a->nbusers} ユーザ)';
$string['resizable'] = 'ウィンドウのリサイズを許可する';
$string['result'] = '結果';
$string['results'] = '結果';
$string['review'] = 'レビュー';
$string['reviewmode'] = 'レビューモード';
$string['scoes'] = '学習オブジェクト';
$string['score'] = '評点';
$string['scormclose'] = '終了日時';
$string['scormcourse'] = '学習コース';
$string['scorm:deleteresponses'] = 'SCORM受験を削除する';
$string['scormloggingoff'] = 'APIログイン: OFF';
$string['scormloggingon'] = 'APIログイン: ON';
$string['scormopen'] = '開始日時';
$string['scormresponsedeleted'] = 'ユーザ受験が削除されました。';
$string['scorm:savetrack'] = 'トラックを保存する';
$string['scorm:skipview'] = '概要をスキップする';
$string['scormtype'] = 'タイプ';
$string['scormtype_help'] = 'ここではパッケージがどのようにコースに含まれるか設定します。以下4つのオプションがあります:

* アップロード済みパッケージ - SCORMパッケージをファイルピッカで選択できるようにします。
* 外部SCORMマニフェスト - imsmanifest.xmlのURIを指定できるようにします。注意: URIがあなたのサイトと異なるドメインの場合、評定が保存されないため、「ダウンロード済みパッケージ」を選択することをお勧めします。
* ダウンロード済みパッケージ - パッケージのURIを指定できるようにします。パッケージは解凍され、ローカルに保存されます。また、外部SCORMパッケージが更新された場合、ローカルに保存されたパッケージも更新されます。
* ローカルIMSコンテンツパッケージ - IMSリポジトリ内のパッケージを選択できるようにします。';
$string['scorm:viewreport'] = 'レポートを表示する';
$string['scorm:viewscores'] = '評点を表示する';
$string['scrollbars'] = 'ウィンドウのスクロールを許可する';
$string['selectall'] = 'すべてを選択する';
$string['selectnone'] = 'すべての選択を解除する';
$string['show'] = '表示';
$string['sided'] = 'サイド';
$string['skipview'] = '学生によるコンテンツ構造ページスキップ';
$string['skipviewdesc'] = 'ここではページに対するコンテンツ構造のスキップタイミングに関するデフォルトを設定します。';
$string['skipview_help'] = 'この設定ではコンテンツ構造ページをスキップ (非表示) するかどうか指定します。パッケージが学習オブジェクトのみ含む場合、コンテンツ構造ページは常にスキップされます。';
$string['slashargs'] = '警告: このサイトではスラッシュ引数が無効にされています。期待されたとおりにオブジェクトが動作しない場合があります!';
$string['stagesize'] = 'ステージサイズ';
$string['stagesize_help'] = 'これら2つの設定では、学習オブジェクトフレーム/ウィンドウの高さおよび幅を定義します。';
$string['started'] = '開始日時';
$string['status'] = 'ステータス';
$string['statusbar'] = 'ステータスバーを表示する';
$string['student_response'] = 'レスポンス';
$string['suspended'] = '一時停止';
$string['syntax'] = '構文エラー';
$string['tag_error'] = 'コンテンツに不明なタグ ({$a->tag}) があります:  {$a->value}';
$string['time'] = '時間';
$string['timerestrict'] = '解答期間を制限する';
$string['title'] = 'タイトル';
$string['toc'] = 'TOC';
$string['toolbar'] = 'ツールバーを表示する';
$string['too_many_attributes'] = 'タグ {$a->tag} のアトリビュートが多すぎます。';
$string['too_many_children'] = 'タグ {$a->tag} の子タグが多すぎます。';
$string['totaltime'] = '時間';
$string['trackingloose'] = '警告: このパッケージのトラッキングデータは消滅します!';
$string['type'] = 'タイプ';
$string['typeexternal'] = '外部SCORMマニフェスト';
$string['typeimsrepository'] = 'ローカルIMSコンテンツリポジトリ';
$string['typelocal'] = 'アップロード済みパッケージ';
$string['typelocalsync'] = 'ダウンロード済みパッケージ';
$string['unziperror'] = 'パッケージの解凍処理中にエラーが発生しました。';
$string['updatefreq'] = '自動更新の頻度';
$string['updatefreqdesc'] = 'ここでは活動に対する自動更新の頻度を設定します。';
$string['validateascorm'] = 'パッケージの確認';
$string['validation'] = '確認結果';
$string['validationtype'] = 'ここではSCORMマニフェストファイルを確認するDOMXMLライブラリを設定します。分からない場合は、このままにしてください。';
$string['value'] = '値';
$string['versionwarning'] = 'マニフェストファイルのバージョンが1.3より古いため、{$a->tag} タグに警告があります。';
$string['viewallreports'] = '{$a} 件の受験レポートを表示する';
$string['viewalluserreports'] = '{$a} 件のユーザレポートを表示する';
$string['whatgrade'] = '複数回受験時の評点';
$string['whatgradedesc'] = 'ここでは複数回受験時の評点に関するデフォルトを設定します。';
$string['whatgrade_help'] = '複数回の受験を許可した場合、ここでは最高、平均、最初または最後の受験のどれを評定表に記録するか設定します。

複数受験の処理は下記のとおりです:

* 新しい受験を開始するオプションはコース構造ページ内の「Enter」ボタンの上にチェックボックスとして提供されます。あなたが複数受験を許可したい場合、このページにユーザがアクセスできることを確認してください。
* 他とは異なり、SCORMパッケージは新しい受験に関して洗練されています。学習者が既存の受験に再度入った場合、SCORMコンテンツに上書きを禁止する内部ロジックがないとしても、また受験が「完了」または「合格」にされていたとしても、上書きすることができます。
* 「完了を強制する」「新しい受験を強制する」「最終受験後、ロックする」設定もさらに複数の受験の管理を提供します。';
$string['width'] = '幅';
$string['window'] = 'ウィンドウ設定';
$string['zlibwarning'] = '警告: このサイトでは、PHP Zlib圧縮が有効にされています。一部のユーザが特定のブラウザでのSCORMオブジェクトのローディングに関して問題を経験することがあります。';
