<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  2013 NPO CCC-TIES <info@cccties.org>
 * @author Codia <system.info@codia.co.jp>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
**/

?>

<script type="text/javascript">
function fnModeSubmit(mode, keyname, keyid, otherkeyname, otherkeyid) {
    switch(mode) {
    case 'manage':
        if(!window.confirm('管理対象にしてもよろしいでしょうか?この操作は戻すことは出来ません。')){
            return;
        }
        break;
    default:
        break;
    }
    document.form1['mode'].value = mode;
    if(keyname != "" && keyid != "") {
        document.form1[keyname].value = keyid;
        if(otherkeyname != "" && otherkeyid != "") {
            document.form1[otherkeyname].value = otherkeyid;
        }
    }
    document.form1.submit();
}
</script>

<?php


// Check that config.php exists, if not then call the install script
if (!file_exists('../../../config.php')) {
    header('Location: ../install.php');
    die();
}
// ライブラリなどの読み込み
require_once("../../../config.php");
require_once($CFG->dirroot."/course/lib.php");
require_once($CFG->dirroot.'/local/ties/lib.php');
require_once($CFG->libdir . '/adminlib.php');
define('INPUTFILENAME', 'file_data1');

admin_externalpage_setup('ties_settings');

// ログインチェック
require_login(0, false);

// 権限チェック（管理者のみ）
$context = get_context_instance(CONTEXT_SYSTEM);
require_capability('moodle/site:config', $context);

$site = get_site();

$systemcontext = get_context_instance(CONTEXT_SYSTEM);

// モードの取得
$mode = optional_param('mode', false, PARAM_ALPHANUM);
$form = optional_param('form', false, PARAM_ALPHANUM);

// ファイルをアップロードした場合
$upfile_test = true;
$upfile_exists_error = true;
$upfile_maxsize_error = true;
$upfile_error = true;
$uploadmsg = "";
if($form === 'upload' ){
    if($mode === 'upload' ){
        // アップロード操作を記録
        //add_to_log(SITEID, 'ties', 'upload', 'admin/settings.php?id='.$id, $COURSE->fullname);
        if($_FILES[INPUTFILENAME]['error'] == 4 ){
            $upfile_exists_error = false;
        }elseif($_FILES[INPUTFILENAME]['error'] == 1 ){
            $upfile_maxsize_error = false;
        }elseif(!upfiletype(INPUTFILENAME)){
            $upfile_test = false;
        }else{
            $uploadmsg = upload_module();
        }
    }else{
        if(array_key_exists(INPUTFILENAME, $_FILES) && !is_uploaded_file($_FILES[INPUTFILENAME]['tmp_name'])){
            $upfile_error = false;
        }
    }
}

// 初期設定
$PAGE->set_url('/local/ties/admin/settings.php');
$PAGE->set_context($systemcontext);
$PAGE->set_pagelayout('admin');

// レイアウト設定
$PAGE->set_title("$site->shortname: " .get_string('title', 'local_ties') );
$PAGE->set_heading($COURSE->fullname);
echo $OUTPUT->header();
echo html_writer::tag('h2', get_string('pagetitle', 'local_ties'), array('class'=> 'headingblock header'));


// 選択されたモジュールを管理対象にする
if(array_key_exists('mode', $_POST)){
    if(array_key_exists('module_name', $_POST) && array_key_exists('module_name', $_POST)){
        manage_module($_POST['module_name'], $_POST['module_path']);
    }
}

// 管理対象になっていないモジュールを表示する
$manage_modules = check_modules();
if(count($manage_modules) > 0){
echo html_writer::start_tag(
    'div', array('class' => 'ties_block'));
echo html_writer::tag('h3', get_string('manage_modules', 'local_ties'), array('class'=> 'headingblock header'));
echo html_writer::tag('p', get_string('manage_modules_info', 'local_ties'));

    echo html_writer::start_tag('form', array('name' => 'form1', 'method' => 'post', 'action' => 'settings.php'));
    echo html_writer::tag('input', '', array('type' => 'hidden', 'name' => 'mode', 'value' => ''));
    echo html_writer::tag('input', '', array('type' => 'hidden', 'name' => 'module_name', 'value' => ''));
    echo html_writer::tag('input', '', array('type' => 'hidden', 'name' => 'module_path', 'value' => ''));
    echo html_writer::start_tag(
        'table', array('class' => 'generaltable')),
    html_writer::tag(
        'tr',
        html_writer::tag('th', get_string('installed_module_list', 'local_ties'), array('class'=> 'header'))
        . html_writer::tag('th', get_string('module_install_version', 'local_ties'), array('class'=> 'header')));
    foreach($manage_modules as $module){
        echo html_writer::tag(
            'tr',
            html_writer::tag('td', $module['name'])
            . html_writer::tag('td', html_writer::tag('a', get_string('manage_modules_link', 'local_ties'), array('href' => '#', 'onclick' => 'fnModeSubmit("manage", "module_name", "'. $module['name'] . '", "module_path", "' . $module['path'] . '");'))));
    }
    echo html_writer::end_tag('table');
    echo html_writer::end_tag('form');
    echo html_writer::end_tag('div');
}


if(file_exists('../../../theme/ties')){
    $theme = $DB->get_records_select("config", "name = ? AND value = ?", array('theme', 'ties'));
    if(empty($theme)){
        echo html_writer::tag('p', get_string('themesetting', 'local_ties', $CFG->wwwroot . '/theme/index.php') ,array('class' => 'attention'));
    }

}

// 更新確認処理
// 強制的にモジュールの更新をチェックする
if($mode === 'checkupdate'){
    // 更新操作を記録
    //add_to_log(SITEID, 'ties', 'update', 'admin/settings.php?id='.$id, $COURSE->fullname);
    if(!update_modules(true)){
        global $CFG;
        redirect($CFG->wwwroot .'/local/ties/admin/error.php');
    }
}

if ( check_exist_updatemodule()){
    echo html_writer::tag('p', get_string('display_update_comment', 'local_ties'), array('class' => 'attention'));
}



// ログの記録
$id = optional_param('id', 0, PARAM_INT);// Course ID
if(empty($mode)){
    // 表示操作を記録
    //add_to_log(SITEID, 'ties', 'view', 'admin/settings.php?id='.$id, $COURSE->fullname);
}

// モジュールのインストールフォーム
disp_upload_form();

// ファイルをアップロードした場合
if($mode === 'upload'){
    // アップロード操作を記録
    //add_to_log(SITEID, 'ties', 'upload', 'admin/settings.php?id='.$id, $COURSE->fullname);
    if(!$upfile_test){
        echo html_writer::tag('p', get_string('upload_filetype', 'local_ties') ,array('class' => 'attention'));
    }
    if(!$upfile_maxsize_error){
        echo html_writer::tag('p', get_string('upload_maxsize_error', 'local_ties') ,array('class' => 'attention'));
    }
    if(!$upfile_exists_error){
        echo html_writer::tag('p', get_string('upload_exists_error', 'local_ties') ,array('class' => 'attention'));
    }
    if($uploadmsg  !== "" && $uploadmsg !== true){
        echo html_writer::tag('p', $uploadmsg ,array('class' => 'attention'));
    }
}

if($form === 'upload') {
    if(!$upfile_error){
        echo html_writer::tag('p', get_string('upload_error', 'local_ties') ,array('class' => 'attention'));
    }
}

/* 変更を禁止させる（強制的に裏側で保存するため）
// 保存期間を変更した場合
$error_msg = false;
if($mode === 'backup' ){
    // バックアップ操作を記録
    //add_to_log(SITEID, 'ties', 'backup', 'admin/settings.php?id='.$id, $COURSE->fullname);
    $day = $_POST['day'];
    if(is_numeric($day) && $day >= 0 ){
        if(!preg_match('/^0[\d]/', $day)){
            $period = $DB->get_records_select('config','name=?',array('backup_period'));
            $period = reset($period);
            $period->value = $day;
            $DB->update_record('config', $period);
        }else{
            $error_msg = get_string('error_leading_character', 'local_ties');
        }
    }else{
        $error_msg = get_string('error_range', 'local_ties');
    }
}
*/

// バックアップの保存期間の設定フォーム 
//disp_backup_form($error_msg);

// モジュールの手動確認処理
disp_update_modules_form();

// インストールしているモジュール一覧
disp_install_modules();

// ダウンロードしているモジュールの一覧（インストールしているモジュールは除く）
disp_download_modules();

echo $OUTPUT->footer();

/**
 * インストールしているモジュール一覧を表示する 
 */
function disp_install_modules(){
    $moduleList = get_install_modules_list();
    // 更新の有無の文言設定
    $exists_update = get_string('exist_update', 'local_ties');
    $not_exists_update = get_string('not_exist_update', 'local_ties');

    echo html_writer::start_tag(
            'div', array('class' => 'ties_block'));
    echo html_writer::tag('h3', get_string('installed_module_list', 'local_ties'), array('class'=> 'headingblock header'));
    if(count($moduleList) > 0){

        echo html_writer::start_tag(
            'table', array('class' => 'generaltable')),
        html_writer::tag(
            'tr',
            html_writer::tag('th', get_string('installed_module_list', 'local_ties'), array('class'=> 'header'))
            . html_writer::tag('th', get_string('module_install_version', 'local_ties'), array('class'=> 'header'))
            . html_writer::tag('th', get_string('display_update', 'local_ties'), array('class'=> 'header')));
        foreach($moduleList as $module){
            echo html_writer::tag(
                'tr',
                html_writer::tag('td', html_writer::tag('span', $module->name, array('id' => $module->name)))
                . html_writer::tag('td', 'ver.' . $module->dispversion . '(' . $module->version . ')')
                . html_writer::tag('td', (($module->update_flg) ? html_writer::tag('a', '無償利用の方はこちら', array('href' => 'http://www.cccties.org/service/download/', 'target' => 'brank')) . ' <br> ' . html_writer::tag('a', $exists_update, array('href' => $module->link, 'target' => 'brank')) : $not_exists_update)));
        }
        echo html_writer::end_tag('table');
    }else{
        echo html_writer::tag('p', get_string('not_installed', 'local_ties'));
    }
    echo html_writer::end_tag('div');
}

/**
 * 配布サイトで配布しているモジュール一覧を表示する 
 */
function disp_download_modules(){
    global $CFG;
    $moduleList = get_download_modules_list();
    $exists_update = get_string('exist_update', 'local_ties');
    $downloadurl = get_downloadpage_url();
    if(!is_object($downloadurl)){
        redirect($CFG->wwwroot .'/local/ties/admin/error.php');
    }

    $url = $downloadurl->url;

    echo html_writer::start_tag(
            'div', array('class' => 'ties_block'));
    echo html_writer::tag('h3', get_string('download_module_list', 'local_ties'), array('class'=> 'headingblock header'));

    if(count($moduleList) > 0){
        echo html_writer::start_tag(
            'table', array('class' => 'generaltable')),
        html_writer::tag(
            'tr',
            html_writer::tag('th', get_string('download_module', 'local_ties'), array('class'=> 'header'))
            . html_writer::tag('th', get_string('download_version', 'local_ties'), array('class'=> 'header'))
            . html_writer::tag('th', get_string('download_link', 'local_ties'), array('class'=> 'header')));
        foreach($moduleList as $module){
            echo html_writer::tag(
                'tr',
                html_writer::tag('td', $module->module_name)
                . html_writer::tag('td', $module->latestversion)
                //. html_writer::tag('td', html_writer::tag('a', 'link', array('href' => $url.$module->link, 'target' => 'brank'))));
                . html_writer::tag('td', html_writer::tag('a', '無償利用の方はこちら', array('href' => 'http://www.cccties.org/service/download/', 'target' => 'brank')) . ' <br> ' . html_writer::tag('a', $exists_update, array('href' => $url . $module->link, 'target' => 'brank'))));
        }
        echo html_writer::end_tag('table');
    }else{
        echo html_writer::tag('p', get_string('not_download', 'local_ties'));
    }
    echo html_writer::end_tag('div');
}

/*
 * モジュールをアップロードするフォームの表示
 */
function disp_upload_form(){
    global $CFG;
    $url = $CFG->downloadurl;
    $id = optional_param('id', 0, PARAM_INT);// Course ID
    echo html_writer::start_tag(
            'div', array('class' => 'ties_block'));
    echo html_writer::tag('h3', get_string('installmodule', 'local_ties'), array('class'=> 'headingblock header'));
    echo html_writer::tag('p', get_string('installmodule_attention', 'local_ties', $url));
    echo "<form enctype='multipart/form-data' action = 'settings.php?id=$id&form=upload' method = 'post' >";
    echo "<input type='file' name=".INPUTFILENAME." size = 70>";
    echo "<input type='hidden' name='mode' value = 'upload'>";
    echo "<input type='submit' name='upload' value='" . get_string('install_button', 'local_ties') . "'>";
    echo "</form>";
    echo html_writer::end_tag('div');
}
/*
 * モジュールのバックアップ期間の設定フォームの表示
 */
function disp_backup_form($error_msg = false){
    $id = optional_param('id', 0, PARAM_INT);// Course ID
    // モジュールの保存期間の取得
    global $DB;
    $period = $DB->get_records_select('config','name=?',array('backup_period'));
    $period = reset($period);
    echo html_writer::start_tag(
            'div', array('class' => 'ties_block'));
    echo html_writer::tag('h3', get_string('setting_period', 'local_ties'), array('class'=> 'headingblock header'));
    echo html_writer::tag('p', get_string('setting_period_attention', 'local_ties'));
    echo "<form enctype='multipart/form-data' action = 'settings.php?id=$id' method = 'post' >";
    echo get_string('period', 'local_ties', $period->value) . "<br>";
    echo "<input type='text' name='day' size = 2 >" . get_string('day', 'local_ties');
    echo "<input type='hidden' name='mode' value = 'backup'>";
    echo "<input type='submit' name='save' value='" . get_string('save', 'local_ties') . "'>";
    echo "</form>";
    if($error_msg){
        echo html_writer::tag('p', $error_msg,array('class' => 'attention'));
    }
    echo html_writer::end_tag('div');
}

/*
 * モジュールの更新確認を行うフォームの表示
 */
function disp_update_modules_form(){
    $id = optional_param('id', 0, PARAM_INT);// Course ID
    echo html_writer::start_tag(
            'div', array('class' => 'ties_block'));
    echo html_writer::tag('h3', get_string('check_module_update', 'local_ties'), array('class'=> 'headingblock header'));
    echo html_writer::tag('p', get_string('check_module_update_attention', 'local_ties'));

    // ToDo:配置が変なので修正したい
    echo "<form class='mform' id='mform1' accept-charset='utf-8' method='post' action='settings.php?id=$id' autocomplete='off'><div style='display: none;'><input type='hidden' value='Jv2ylPAwgI' name='sesskey'><input type='hidden' value='checkupdate' name='mode'></div><div><div class='singlebutton' id='fitem_id_submitbutton'><div class='fitemtitle'><label for='id_submitbutton'> </label></div><div class='felement fsubmit'>";
    echo "<input type='submit' id='id_submitbutton' value='" . get_string('update_modules', 'local_ties') ."' name='submitbutton'>";
    echo "</div></div></div></form>";
    echo html_writer::end_tag('div');
}


/**
 * アップロードしたモジュールを展開する 
 *
 * return booloean true:ファイルの配置成功 string:失敗時のメッセージ
 */
function upload_module(){
    global $CFG;

    // モジュールのバックアップ置き場所関連の処理
    $basedir = $CFG->dataroot . "/ties";
    if(($msg = setting_dir($basedir)) !== true){
        return $msg;
    }

    // アップロードファイルを一時格納するディレクトリの処理
    $savedir = $CFG->dataroot . "/ties/tmp";
    if(($msg = setting_dir($savedir)) !== true){
        return $msg;
    }

    // アップロードされたファイルの保存処理
    $uploadfilepath = $savedir . '/' . date('YmdHis') . $_FILES[INPUTFILENAME]["name"] ;
    if(($msg = save_upload_file($uploadfilepath)) !== true){
        return $msg;
    }

    // アップロードしたファイルを解凍する
    $extractpath = $savedir . '/' . date('YmdHis');
    if(($msg = unzip_uploadfile($extractpath, $uploadfilepath)) !== true){
        return $msg;
    }


    // 展開されたディレクトリの中身を取得する
    $dir = opendir( $extractpath . '/'  );
    if(!$dir){
        return $extractpath . get_string('cant_open_directory', 'local_ties');
    }
    if(($files = glob($extractpath . '/*')) === false){
        return get_string('cant_get_contents', 'local_ties');
    }
    // ディレクトリクローズ
    closedir( $dir );

    // 取得したファイルの数をチェックする
    if(($msg =  upload_module_check($files, $extractpath)) !== true){
        return $msg;
    }

    foreach($files as $filepath){
        $file = str_replace($extractpath . '/', '', $filepath);

        // ファイルチェック
        var_dump($filepath,$file,$extractpath);
        if(!is_dir( $extractpath . '/' . $file ) ) {
            var_dump('not dir');
            return get_string('need_directory', 'local_ties');
        } else {
            if(!preg_match('/^\./', $file)){
                // 移動先のディレクトリを動的に取得するためにinstaller.phpを取得
                $installer_path = $extractpath . '/' . $file . '/installer.php' ;
                if(($msg = get_replace_directory($installer_path)) !== true){
                    return $msg;
                }

                // 移動先のディレクトリを取得する
                require_once($installer_path);
                if(!empty($module->install_path)){
                    $install_path = $module->install_path;
                }else if(!empty($plugin->install_path)){
                    $install_path = $plugin->install_path;
                }
                if(empty($install_path)){
                    return get_string('cant_get_replace_directory', 'local_ties');
                }

                $mv_dir =  $CFG->dirroot . '/' . $install_path . '/'; 

                if(($msg = check_writable($mv_dir)) !== true){
                    return $msg;
                }

                // ファイルのパスの定義
                $before_file      = $extractpath . '/' . $file;
                $after_file       = $mv_dir . $file;
                $backupdir        = $CFG->dataroot . "/ties/backup";
                $backupmoduledir  = $backupdir . '/' . $file;
                $backup_file      = $backupmoduledir . date('YmdHis');

                $backup           = false;

                // すでにファイルがある場合はバックアップを取る。
                if(file_exists($after_file)){
                    $backup = true;

                    // バックアップディレクトリ作成処理
                    if(($msg = setting_dir($backupdir)) !== true){
                        return $msg;
                    }

                    // モジュールごとのバックディレクトリ作成処理
                    if(($msg = setting_dir($backupmoduledir)) !== true){
                        return $msg;
                    }

                    // 同名で同時刻のモジュールがある場合は削除しておく
                    // 1秒単位で一致しないとありえないが念のため。
                    if(file_exists($backup_file)){
                        remove_directory($backup_file);
                    }

                    if(!rename($after_file, $backup_file)){
                        return get_string('backupfailed', 'local_ties', array('name' => $after_file, 'dataroot' => $CFG->dataroot));
                    }

                    // 指定時間以上のバックアップファイルは削除する
                    //remove_backup($backupmoduledir, $CFG->backup_period);
                }

                // モジュールを移動する
                if(($msg = move_module_finalpath($before_file, $after_file, $backup_file, $extractpath, $backup)) !== true){
                    return $msg;
                }else{
                    $result = true;
                }
            }
        }
    }

    // 移動が成功している場合
    if($result){
        // admin/index.phpにリダイレクトさせる
        remove_directory($extractpath);
        redirect($CFG->wwwroot .'/admin/index.php');
    }else{
        return get_string('unknown_error', 'local_ties');
    }

    return true;
}



/**
 * ディレクトリを削除する(ファイルが存在しても再帰的に削除する) 
 *
 * @param  string $dir (削除するディレクトリ)
 */
function remove_directory($dir) {
    if ($handle = opendir("$dir")) {
        while (false !== ($item = readdir($handle))) {
            if ($item != "." && $item != "..") {
                if (is_dir("$dir/$item")) {
                    remove_directory("$dir/$item");
                } else {
                    unlink("$dir/$item");
                }
            }
        }
        closedir($handle);
        rmdir($dir);
    }
}

/**
 * 指定した期間より古いバックアップファイルの削除 
 *
 * @param  string $dir (削除するディレクトリ)
 * @param  int    $day (期間:日)
 */
function remove_backup($path, $day = 30){
    $files = glob($path . '/*');
    $deadline = $day * 24 * 60 * 60;
    foreach($files as $path){
        if((time() - filemtime($path) > $deadline)){
            remove_directory($path);
        }
    }
}

/**
 * 指定した期間より古いバックアップファイルの削除 
 * 複数タイプに対応してもよいが、今回はzipのみしか扱わない
 * @param string $upfile (テンポラリーファイルのキー名)
 * return boolean true:ファイルがzipの場合,false:ファイルがzipでない場合
 */
function upfiletype($upfile){
    if(!is_uploaded_file($_FILES[$upfile]["tmp_name"])){
        return false; //ファイルがアップされてない場合
    }else{
        if($_FILES[$upfile]["type"] == "application/zip" || $_FILES[$upfile]['type'] == 'application/x-zip-compressed'){
            return true;
        }else{
            return false;
        }
    }
}

/**
 * 指定した期間より古いバックアップファイルの削除 
 * 複数タイプに対応してもよいが、今回はzipのみしか扱わない
 * @param string $upfile (テンポラリーファイルのキー名)
 * return boolean true:ファイルがzipの場合,false:ファイルがzipでない場合
 */
function upfilesize($upfile){
    if($_FILES[$upfile]["error"] == 1 || $_FILES[$upfile]["error"] == 2){
        return false;
    }else{
        return true;
    }
}

/**
 * ディレクトリの作成と書き込み権限をチェックする
 * @param string $dir (ディレクトリの絶対パス)
 * return boolean true:ディレクトリの作成成功・書き込み権限がある string:失敗時のメッセージ
 * 
 **/
function setting_dir($dir){
    if(($msg = make_dir($dir)) !== true ){
        return $msg;
    }
    if(($msg = check_writable($dir)) !== true ){
        return $msg;
    }
    return true;
}

/**
 * ディレクトリを作成する
 * ディレクトリの作成は既に存在している場合は作成しない
 * @param string $dir (作成するディレクトリの絶対パス)
 * return boolean true:ディレクトリの作成成功 string:失敗時のメッセージ
 **/
function make_dir($dir){
    if(!file_exists($dir)){
        if(!mkdir($dir)){
            return get_string('cant_make_directory', 'local_ties', $dir);
        }
    }

    return true;
}

/**
 * ディレクトリをの書き込み権限の有無を判定する
 * ディレクトリの作成は既に存在している場合は作成しない
 * @param string $dir (作成するディレクトリの絶対パス)
 * return boolean true:ディレクトリに書き込み権限がある string:失敗時のメッセージ
 **/
function check_writable($dir){
    if(!is_writable($dir)){
        return get_string('cant_writable', 'local_ties', $dir);
    }
    return true;
}

/**
 * アップロードしたファイルを解凍する
 * 解凍後はファイルを削除する
 * @param string $extractpath (解凍先のパス) 
 * @param string $filename (解凍するファイル) 
 * return boolean true:ファイルの解凍・削除に成功 string:失敗時のメッセージ
 **/
function unzip_uploadfile($extractpath, $filename){
    $zip = new ZipArchive();
    $zip->open($filename);
    $zip_result = $zip->extractTo($extractpath);
    $zip->close();

    if(!$zip_result){
        return get_string('cant_unzip', 'local_ties', $filename);
    }else{
        // 解凍後は不要なので削除する
        if(!unlink($filename)){
            // ToDo:非表示にする
            // echo get_string('cant_remove', 'local_ties', $filename) . "<BR>";
        }
    }
    return true;
}

/**
 * アップロードしたファイルを保存する
 * @param $string $uploadfilepath (アップロードしたファイルを保存するパス)
 * return booloean true:保存に成功 string:失敗時のメッセージ
 **/
function save_upload_file($uploadfilepath){
    if ( $_FILES[INPUTFILENAME]["size"] === 0 ) {
        return get_string('cant_get_uploadfile', 'local_ties');
    } else {
        // アップロードファイルされたテンポラリファイルをファイル格納パスにコピーする
        if(!@move_uploaded_file( $_FILES[INPUTFILENAME]["tmp_name"], $uploadfilepath)){
            return get_string('upload_failed', 'local_ties');
        }
    }
    return true;
}

/**
 * 展開したモジュールを正規の場所に移動する
 * @param string $before_file (展開したファイルのパス)
 * @param string $after_file  (モジュールで定められている正規のパス)
 * @param string $backup_file (バックアップしたファイルのパス)
 * @param string $extractpath (展開したファイルのディレクトリ)
 * return booloean true:移動に成功 string:失敗時のメッセージ
 **/
function move_module_finalpath($before_file, $after_file, $backup_file, $extractpath, $backup){
    $rename_result = rename($before_file, $after_file);
    if(!$rename_result){
        // 失敗した場合は移動したファイルを戻す
        if($backup && !rename($backup_file, $after_file)){
            // echo $backup_file . 'から' . $after_file . "へのファイルの移動に失敗しました。<BR>";
        }
        return $before_file . 'から' . $after_file . "へのファイルの移動に失敗しました。";
    }
    return true;
}

/**
 * 展開したモジュールのファイルの数を判定
 * 展開したモジュールのディレクトリ直下にはディレクトリが一つである必要があるため
 * @param array $files (取得したファイル群)
 * @param string $extractpath (展開したファイルのディレクトリ)
 * return booloean true:ファイルが一つ string:失敗時のメッセージ
 **/
function upload_module_check($files, $extractpath){
    // ToDo:複数のディレクトリの場合はエラーとするほうがよいか
    //      二次開発では一つのみとする
    if(!$files){
        return get_string('cant_get_contents', 'local_ties');
    }elseif(count($files) === 0){
        return get_string('contents_is_nothing', 'local_ties');
    }elseif(count($files) > 1){
        // ToDo:メッセージが変な気がする
        //return get_string('directory_only', 'local_ties');
    }
    return true;
}

/**
 * 展開したファイル直下にinstaller.phpがあるか判定 
 * @param string $installer_path (展開したファイルのパス)
 * return booloean true:インストールパスの取得成功 string:失敗時のメッセージ
 **/
function get_replace_directory($installer_path){
    if(is_file($installer_path) === false){
        return get_string('cant_get_file', 'local_ties');
    }

    return true;

}
