<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  2013 NPO CCC-TIES <info@cccties.org>
 * @author Codia <system.info@codia.co.jp>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
**/

$hasheading = ($PAGE->heading);
$hasnavbar = (empty($PAGE->layout_options['nonavbar']) && $PAGE->has_navbar());
$hasfooter = (empty($PAGE->layout_options['nofooter']));
$hassidepre = $PAGE->blocks->region_has_content('side-pre', $OUTPUT);
$hassidepost = $PAGE->blocks->region_has_content('side-post', $OUTPUT);

$custommenu = $OUTPUT->custom_menu();
$hascustommenu = (empty($PAGE->layout_options['nocustommenu']) && !empty($custommenu));

$bodyclasses = array();
if ($hassidepre && !$hassidepost) {
    $bodyclasses[] = 'side-pre-only';
} else if ($hassidepost && !$hassidepre) {
    $bodyclasses[] = 'side-post-only';
} else if (!$hassidepost && !$hassidepre) {
    $bodyclasses[] = 'content-only';
}

if ($hascustommenu) {
    $bodyclasses[] = 'has-custom-menu';
}

echo $OUTPUT->doctype() ?>
<html <?php echo $OUTPUT->htmlattributes() ?>>
<head>
  <title><?php echo $PAGE->title; ?></title>
  <link rel="shortcut icon" href="<?php echo $OUTPUT->pix_url('favicon', 'theme')?>" />
  <?php echo $OUTPUT->standard_head_html() ?>
</head>

<body id="<?php p($PAGE->bodyid) ?>" class="<?php p($PAGE->bodyclasses.' '.join(' ', $bodyclasses)) ?>">

<?php echo $OUTPUT->standard_top_of_body_html() ?>

<?php if ($hasheading || $hasnavbar) { ?>

<div id="page-wrapper">
  <div id="page" class="clearfix">

      <div id="headerbloc">
    <div id="page-header" class="clearfix">
      <?php if ($PAGE->heading) { ?>
        <h1 class="headermain">
            <a href='<?php echo $CFG->wwwroot ?>' class="logo"><span class='hidden'><?php echo $PAGE->heading ?></span></a>
            <span class="header_logo_link">
                <a href='<?php echo $CFG->wwwroot ?>/local/ties/admin/forum_ties.php' class="forumlink"><span class='hidden'>forum Link</span></a>
                <a href='http://hub.cccties.org/' class="hublink"><span class='hidden'>Moodle Hub Link</span></a>
            </span>
        </h1>
        <div class="headermenu">
          <?php echo $OUTPUT->login_info();
            echo $OUTPUT->lang_menu();
          echo $PAGE->headingmenu; ?>
        </div>
        <?php if ($hascustommenu) { ?>
        <div id="custommenu"><?php echo $custommenu; ?></div>
        <?php } ?>
        <span id="bit1"><a href="http://www.nii.ac.jp/index.php?action=pages_view_main&block_id=9504&page_id=
2517&active_action=announcement_view_main_init#_9504"><img src="<?php echo $CFG->wwwroot ?>/theme/ties/pix/bit1.gif" ></a></span>
      <?php } ?>
    </div>
    </div>

<?php } ?>

    <div id="page-content">
        <div id="region-main-box">
            <div id="region-post-box">

                <div id="region-main-wrap">
                    <div id="region-main">
                        <div class="region-content">
                            <?php echo $OUTPUT->main_content() ?>
                        </div>
                    </div>
                </div>

                <?php if ($hassidepre) { ?>
                <div id="region-pre">
                    <div class="region-content">
                        <?php echo $OUTPUT->blocks_for_region('side-pre') ?>
                    </div>
                </div>
                <?php } ?>

                <?php if ($hassidepost) { ?>
                <div id="region-post">
                    <div class="region-content">
                        <?php echo $OUTPUT->blocks_for_region('side-post') ?>
                    </div>
                </div>
                <?php } ?>

            </div>
        </div>
    </div>

    <div class="clearfix"></div>
<?php if ($hasfooter) { ?>

    <div id="page-footer" class="clearfix">
      <p class="helplink"><?php echo page_doc_link(get_string('moodledocslink')) ?></p>
      <?php echo $OUTPUT->login_info(); ?>
    </div>


<?php }

if ($hasheading || $hasnavbar) { ?>

 	<div class="myclear"></div>
  </div> <!-- END #page -->

</div> <!-- END #page-wrapper -->

<?php } ?>

<div id="page-footer-bottom">

        <span id="bit2"><a href="http://www.nii.ac.jp/index.php?action=pages_view_main&block_id=9504&page_id=
2517&active_action=announcement_view_main_init#_9504"><img src="<?php echo $CFG->wwwroot ?>/theme/ties/pix/bit2.gif" ></a></span>
<?php if ($hasfooter) {
  echo $OUTPUT->home_link();
  echo $OUTPUT->standard_footer_html();
} ?>

</div>

<?php echo $OUTPUT->standard_end_of_body_html() ?>
</body>
</html>
