<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  2013 NPO CCC-TIES <info@cccties.org>
 * @author Codia <system.info@codia.co.jp>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
**/

// Check that config.php exists, if not then call the install script
if (!file_exists('../../../config.php')) {
    header('Location: ../install.php');
    die();
}
// ライブラリなどの読み込み
require_once("../../../config.php");
require_once($CFG->dirroot."/course/lib.php");
require_once($CFG->dirroot.'/local/ties/lib.php');
require_once($CFG->libdir . '/adminlib.php');

admin_externalpage_setup('ties_count');

// ログインチェック
require_login(0, false);

// 権限チェック（管理者のみ）
$context = get_context_instance(CONTEXT_SYSTEM);
require_capability('moodle/site:config', $context);

$site = get_site();

$systemcontext = get_context_instance(CONTEXT_SYSTEM);

// モードの取得
//$mode = optional_param('mode', false, PARAM_ALPHANUM);
//$form = optional_param('form', false, PARAM_ALPHANUM);

// 初期設定
$PAGE->set_url('/local/ties/admin/installcheck.php');
$PAGE->set_context($systemcontext);
$PAGE->set_pagelayout('admin');

// レイアウト設定
$PAGE->set_title("$site->shortname: " .get_string('title', 'local_ties') );
$PAGE->set_heading($COURSE->fullname);
echo $OUTPUT->header();
echo html_writer::tag('h2', get_string('pagetitle', 'local_ties'), array('class'=> 'headingblock header'));


// 講義数の取得
$count_course = $DB->count_records_sql("select count(*)-1 from mdl_course");

echo html_writer::start_tag('div', array('class' => 'ties_block'));
echo html_writer::tag('h3', '講義数', array('class'=> 'headingblock header'));
echo html_writer::start_tag(
    'table', array('class' => 'generaltable')),
html_writer::tag(
    'tr',
    html_writer::tag('th', '講義数', array('class'=> 'header')));
    echo html_writer::tag(
        'tr',
        html_writer::tag('td', $count_course));
echo html_writer::end_tag('table');
echo html_writer::end_tag('div');


// 講義別ユーザー数の取得
$sql  = "SELECT c.fullname, count(u.id) as user_count ";
$sql .= "FROM mdl_user u ";
$sql .= "JOIN mdl_user_enrolments ue ON (ue.userid = u.id) ";
$sql .= "JOIN mdl_enrol e ON (e.id = ue.enrolid) ";
$sql .= "JOIN mdl_course c ON (c.id = e.courseid) ";
$sql .= "LEFT JOIN mdl_user_lastaccess ul ON (ul.courseid = e.courseid AND ul.userid = u.id) " ;
$sql .= "GROUP BY e.courseid ";
$sql .= "ORDER BY u.lastname ASC, u.firstname ASC;";
$course_users = $DB->get_records_sql($sql);

echo html_writer::start_tag('div', array('class' => 'ties_block'));
echo html_writer::tag('h3', '講義にロールされているユーザー数', array('class'=> 'headingblock header'));
if(count($course_users) > 0){
    echo html_writer::start_tag(
        'table', array('class' => 'generaltable')),
    html_writer::tag(
        'tr',
        html_writer::tag('th', '講義名', array('class'=> 'header'))
        . html_writer::tag('th', 'ユーザー数', array('class'=> 'header')));
    foreach($course_users as $course_info){
        echo html_writer::tag(
            'tr',
            html_writer::tag('td', $course_info->fullname)
            . html_writer::tag('td', $course_info->user_count));
    }
    echo html_writer::end_tag('table');
}else{
    echo html_writer::tag('p', '講義にロールされているユーザーはいません。');
}
echo html_writer::end_tag('div');


// リソース数
// リソース数の取得
$courses = $DB->get_records_sql("select id, fullname from mdl_course");
array_shift($courses);

$sql  = "SELECT id, sequence FROM mdl_course_sections where course = ? ";
$resouce_sum = 0;

echo html_writer::start_tag('div', array('class' => 'ties_block'));
echo html_writer::tag('h3', '講義ごとのリソース数', array('class'=> 'headingblock header'));
echo html_writer::start_tag(
    'table', array('class' => 'generaltable')),
html_writer::tag(
    'tr',
    html_writer::tag('th', '講義名', array('class'=> 'header'))
    . html_writer::tag('th', 'リソース数'), array('class'=> 'header'));
foreach($courses as $course){
    $sections = $DB->get_records_sql($sql, array($course->id));
    $count = count_resouce($sections);
    $resouce_sum += $count;
    echo html_writer::tag(
        'tr',
        html_writer::tag('td', $course->fullname)
        . html_writer::tag('td', $count));
}
    echo html_writer::tag(
        'tr',
        html_writer::tag('td', '合計')
        . html_writer::tag('td', $resouce_sum), array('class' => 'tr_strong'));
echo html_writer::end_tag('table');
echo html_writer::end_tag('div');



echo $OUTPUT->footer();


// セクションごとのリソースをカウントする
// フォーラムをカウントする場合は$forum_countをtrueにすること
function count_resouce($sections){
    unset($sections['']);
    $count = 0;
    foreach($sections as $key => $section){
        if(strlen($section->sequence) == 0){
            continue;
        }
        $ids = explode(',',$section->sequence);
        $count += count($ids);
    }

    return $count;
}
