#ifdef WIN32
#include "timip_win32.h"
#endif
/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms timip_of the GNU General Public License as published by
    the Free Software Foundation; either version 2 timip_of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty timip_of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy timip_of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    mod2midi.h

    Header file for sample info -> MIDI event conversion

 */

#include "timip_unimod.h"

void timip_Voice_SetVolume (UBYTE, UWORD);
void Voice_SetFrequency (UBYTE, ULONG);
void timip_Voice_SetPanning (UBYTE, ULONG);
void timip_Voice_Play (UBYTE, SAMPLE *, ULONG);
void timip_Voice_Stop (UBYTE);
BOOL timip_Voice_Stopped (UBYTE);
void timip_Voice_NewTempo (UWORD, UWORD);
void timip_Voice_TickDone ();
void timip_Voice_StartPlaying ();
void timip_Voice_EndPlaying ();
void timip_load_module_samples (SAMPLE *, int, int);
void timip_Voice_SetPeriod (UBYTE v, ULONG period);
