#ifdef WIN32
#include "timip_win32.h"
#endif
/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms timip_of the GNU General Public License as published by
    the Free Software Foundation; either version 2 timip_of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty timip_of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy timip_of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    rtsyn.h
        Copyright (c) 2003  Keishi Suenaga <s_keishi@mutt.freemail.ne.jp>

    I referenced following sources.
        alsaseq_c.c - ALSA sequencer server interface
            Copyright (c) 2000  Takashi Iwai <tiwai@suse.de>
        readmidi.c
*/
#include "timip_interface.h"

#include <stdio.h>

#include <stdarg.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif /* HAVE_SYS_TYPES_H */
#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#endif
#ifndef NO_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <math.h>
#include <signal.h>

#include "timip_server_defs.h"

#ifdef TIMIP___W32__
#include <windows.h>
#include <mmsystem.h>
#endif


#ifndef TIMIP___W32__
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#endif



#include "timip_timidity.h"
#include "timip_common.h"
#include "timip_controls.h"
#include "timip_instrum.h"
#include "timip_playmidi.h"
#include "timip_readmidi.h"
#include "timip_recache.h"
#include "timip_output.h"
#include "timip_aq.h"
#include "timip_timer.h"


#define  USE_PORTMIDI 1

/******************************************************************************/
/*                                                                            */
/*  Interface independent functions (see rtsyn_common.c)                      */
/*                                                                            */
/******************************************************************************/

/* peek playmidi.c */
LIBTIMIPDLL_API extern int32 timip_current_sample;

/* peek timidity.c */
LIBTIMIPDLL_API extern VOLATILE int timip_intr;

/* How often data pass to the buffer */
#define TICKTIME_HZ 200

/* latency (sec)  > 1.0 / TICKTIME_HZ * 4.0 */
#define RTSYN_LATENCY 0.20


LIBTIMIPDLL_API extern double timip_rtsyn_latency;   /* = RTYSN_LATENCY */
LIBTIMIPDLL_API extern int timip_rtsyn_system_mode;

/* reset synth    */
void timip_rtsyn_gm_reset(void);
void timip_rtsyn_gs_reset(void);
void timip_rtsyn_xg_reset(void);
void timip_rtsyn_normal_reset(void);

/* mode change                                            *
 * only in nomalmode program can accept reset(sysex) data */
void timip_rtsyn_gm_modeset(void);
void timip_rtsyn_gs_modeset(void);
void timip_rtsyn_xg_modeset(void);
void timip_rtsyn_normal_modeset(void);

void timip_rtsyn_init(void);
void timip_rtsyn_close(void);
double timip_rtsyn_set_latency(double latency);
void timip_rtsyn_play_event(MidiEvent *timip_ev);
void timip_rtsyn_play_event_time(MidiEvent *timip_ev, double event_time);
void timip_rtsyn_server_reset(void);
void timip_rtsyn_reset(void);
void timip_rtsyn_stop_playing(void);
int timip_rtsyn_play_one_data (int port, int32 dwParam1, double event_time);
void timip_rtsyn_play_one_sysex (char *sysexbuffer, int exlen, double event_time );
void timip_rtsyn_play_calculate(void);



/******************************************************************************/
/*                                                                            */
/*  Interface dependent functions (see rtsyn_winmm.c rtsyn_portmidi.c)        */
/*                                                                            */
/******************************************************************************/
#define MAX_PORT 4
LIBTIMIPDLL_API extern int timip_rtsyn_portnumber;
LIBTIMIPDLL_API extern unsigned int timip_portID[MAX_PORT];
LIBTIMIPDLL_API extern char  timip_rtsyn_portlist[32][80];
LIBTIMIPDLL_API extern int timip_rtsyn_nportlist;

void timip_rtsyn_get_port_list(void);
int timip_rtsyn_synth_start(void);
void timip_rtsyn_synth_stop(void);
int timip_rtsyn_play_some_data (void);
void timip_rtsyn_midiports_close(void);


#if defined(IA_WINSYN) || defined(IA_W32G_SYN)
int timip_rtsyn_buf_check(void);
#endif



#ifdef USE_WINSYN_TIMER_I

#if defined(TIMIP___W32__)
typedef CRITICAL_SECTION  rtsyn_mutex_t;
#define rtsyn_mutex_init(_m)	InitializeCriticalSection(&_m)
#define rtsyn_mutex_destroy(_m) DeleteCriticalSection(&_m)
#define rtsyn_mutex_lock(_m)    EnterCriticalSection(&_m)
#define rtsyn_mutex_unlock(_m)  LeaveCriticalSection(&_m)

#else
typedef pthread_mutex_t rtsyn_mutex_t;
#define rtsyn_mutex_init(_m)      pthread_mutex_init(&(_m), NULL)
#define rtsyn_mutex_destroy(_m)   pthread_mutex_destroy(&(_m))
#define rtsyn_mutex_lock(_m)      pthread_mutex_lock(&(_m))
#define rtsyn_mutex_unlock(_m)    pthread_mutex_unlock(&(_m))
#endif

#endif
