#include "dice_funcs.h"
#include <ctime>



namespace ray {
  namespace dice {

    int getRandom(int imin, int imax) {
      static boost::uniform_real<> std_dst( 0.0, 1.0 );
      static boost::variate_generator< boost::mt19937, boost::uniform_real<> >
        std_rand_ob( RangeRandom::default_mt_gen, std_dst );

      return (int)(std_rand_ob() * (imax - imin + 1)) + imin;
    }
// =====================================================================
    const RangeRandom::seed_type RangeRandom::default_seed
      = static_cast<RangeRandom::seed_type>( std::time(0) );
    const RangeRandom::gen_type RangeRandom::default_mt_gen
      = RangeRandom::gen_type( static_cast<RangeRandom::gen_result_type>(RangeRandom::default_seed) );

    RangeRandom::RangeRandom(int _min, int _max)
         : m_overflow( false ), m_count( 0 ), m_seed( RangeRandom::default_seed ),
           m_gen( RangeRandom::default_mt_gen ), m_dst( _min, _max ), m_rand( m_gen, m_dst )
      {
      }
/*
    RangeRandom::RangeRandom(int _min, int _max, gen_type& _gen)
         : m_gen( _gen ), m_dst( _min, _max ), m_rand( m_gen, m_dst ),
           m_overflow( false ), m_count( 0 )
      {
      }
*/
    RangeRandom::RangeRandom(int _min, int _max, gen_result_type _seed)
         : m_overflow( false ), m_count( 0 ), m_seed( static_cast<seed_type>(_seed) ),
           m_gen( _seed ), m_dst( _min, _max ), m_rand( m_gen, m_dst )
      {
      }

    int RangeRandom::next() {
      if( ++m_count == 0 ) m_overflow = true;
      return m_rand();
    }

    bool RangeRandom::isOverflow() const { return m_overflow; }
    RangeRandom::count_type RangeRandom::getCount() const { return m_count; }
    RangeRandom::seed_type RangeRandom::getSeed() const { return m_seed; }
    RangeRandom::dst_type::result_type RangeRandom::getMin() const { return m_dst.min(); }
    RangeRandom::dst_type::result_type RangeRandom::getMax() const { return m_dst.max(); }

    RangeRandom& RangeRandom::skipTo(unsigned long count) {
      // ˥Ȥ̤᤮Ƥˤ㳰򥹥٤
      while( m_count < count ){
        next();
      }
      return *this;
    }

    RangeRandom& RangeRandom::skipBefore(unsigned long count) {
      return skipTo(count - 1);
    }

      static RangeRandom s_rand( 0, INT_MAX );

      int nDm(int num, int face) {
          RangeRandom rnd(1, face, s_rand.next());
          int ret = 0;
          for( int i = 0; i < num; ++i ) {
              ret += rnd.next();
          }
          return ret;
      }
  }
}

