<?php

/**
  * Plugin for Nucleus CMS (http://plugins.nucleuscms.org/)
  * Copyright (C) 2008 The Nucleus Plugins Project
  *
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
  *
  * see license.txt for the full license
  * or visit http://www.gnu.org/copyleft/gpl.html
  */

/**
  * Usage: Description available under http://plugins.nucleuscms.org
  *
  * Versions:
  *  3.0.7	2008-04-15 yama (http://kyms.ne.jp)
  *  						- Updated TinyMCE editor to version 3.0.7
  *  3.0.6.2	2008-04-14 yama (http://kyms.ne.jp)
  *  						- Updated TinyMCE editor to version 3.0.6.2
  *  3.0.6.1np1	2008-04-05 yama (http://kyms.ne.jp)
  *  						- Optimized custom css class list, quick apply
  *  						- Updated TinyMCE editor to version 3.0.6.1
  *  						- Added enter-key mode, <p> or <br />
  *  						- Added textarea detect mode, inputbody/inputmore or all
  *  3.0.5np1	2008-03-10 yama (http://kyms.ne.jp)
  *  						- TinyMCE editor updated to version 3.0.5
  *  						- modify global option, url output style
  *  						- add global option, editable toolbar settings
  *  						- add member option, editable toolbar settings
  *  						- add global option, custom style list (css) settings
  *  						- add option skin select "o2k7_black"
  *  						- The specification of the member option is changed (advanced -> custom)
  *  						- option value set default 'GZip compression'
  *  						- popup_css_add
  *  						- tuned little, filemanager/mediaphp/media.php
  *  3.0.4.1np1	2008-03-08 yama (http://kyms.ne.jp)
  *  						- TinyMCE editor updated to version 3.0.4.1
  *  						- add option skin select
  *  3.0.3np1	2008-03-04 yama (http://kyms.ne.jp)
  *  						- TinyMCE editor updated to version 3.0.3
  *  						- Fixed bug where the file was not able to be put with bundled media.php.
  *  3.0.2.1np1	2008-03-03 yama (http://kyms.ne.jp)
  *  						- TinyMCE editor updated to version 3.0.2.1
  *  						- add option relative_urls yes/no
  *  						- add option accessibility warnings yes/no
  *  3.0.1np3	2008-02-25 yama (http://kyms.ne.jp)
  *  						- TinyMCE editor updated to version 3.0.1
  *  						- added extended_valid_elements, a[rel], img[style]
  *  						- change font list style
  *  3.0.1np2	2008-02-13 shizuki (http://shizuki.kinezumi.net/)
  *  						- Fix NP_Mediatocu cooperation code
  *  3.0.1np1	2008-02-15 yama (http://kyms.ne.jp)
  *  						- solves various Safari compatibility issues (http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/safari)
  *  						- TinyMCE editor updated to version 3.0.1(from svn)
  *  3.0.0np4	2008-02-14 shizuki (http://shizuki.kinezumi.net/)
  *  						- gZip compression could mount a transmission.
  *  						- An unnecessary comment line was eliminated.
  *  3.0.0np3	2008-02-14 yama (http://kyms.ne.jp)
  *  						- It corresponds to SQLite wrapper for Nucleus(http://wakka.xiffy.nl/sqlite)
  *  						- Conversion <%image%> tags
  *  3.0.0np2	2008-02-13 shizuki (http://shizuki.kinezumi.net/)
  *  						- media.php and NP_Mediatocu corresponds to dhtml popup dialog
  *  						- Optimization source code
  *  3.0.0np1	2008-02-05 yama (http://kyms.ne.jp)
  *  						- The directory composition is changed
  *  						- multi language
  *  3.0.0	2008-02-04 yama (http://kyms.ne.jp)
  *  						- TinyMCE editor updated to version 3.0
  *  1.40	2008-02-02 yama (http://kyms.ne.jp)
  *  						- TinyMCE editor updated to version 2.1.3
  *  						- contextmenu and inlinepopups(dhtml popup dialog)
  *  						  plugins enabled
  *  						- css tuned
  *  						- only enabled, textarea of inputbody and inputmore
  *  1.30	2007-05-18 kg (Kai Greve - http://kgblog.de)
  *  						- TinyMCE editor updated to version 2.1.1.1
  *  						- media plugin enabled (new button besides the image
  *  						  button)
  *  						- nucleus media browser support also
  *  						  for other media files types (includeOtherMedia) 
  *  						- tiny_mce_gzip.php updated to version 1.1.0 (still
  *  						  experimental) 
  *  1.20	2006-07-29 kg (Kai Greve - http://kgblog.de)
  *  						- allow html tags that are necessary for videos
  *  						  (object, param, embed) 
  *  						- lost focus bug (IE) solved  
  *  						- member option for the advanced features
  *  						- second butoon bar with advanced features 
  *  1.10	2006-06-29 kg
  *  						- javascript also works in IE (bug fixed)  
  *  1.00	2006-06-28 kg
  *  						- bypass the linebreak convention instead of
  *  						  changing it 
  *  						- allow vertical resizing of the textfield  
  *  						- added buttons for outdent and indent 
  *  						- don't use relative urls (neeeded for fancy urls) 
  *  						- regard member options also on bookmarklet pages
  *  						  (bug removed)
  *  0.91	2006-06-14 kg
  *  						- enable/disable wysiwyg as a memberoption
  *  						- additional button for backgroundcolor and image
  *  						- recover nucleus tags before saving the item to the
  *  						  database 
  *  						- using the inbuild nucleus media manager for images
  *  0.9c	2005-09-28  eph
  *  						- upgrade to TinyMCE 2RC3
  *  						- lots of path fixes
  *  						- experimental GZip option. Should load quicker if
  *  						  it works
  *  0.9b	2005-09-24  eph
  *  						- upgrade to TinyMCE 2RC2
  *  						- addition of File Manager
  *  						- bugfixes and cleaner uninstall
  *  0.9 	2005-07-16	roel
  *  						- initial implementation, mostly copied over from
  *  						  NP_EditControls by karma - http://demuynck.org 
  *
  */

class NP_TinyMCE extends NucleusPlugin
{

var $memberid, $LinebreakConversion; 

	function NP_TinyMCE()
	{
//		hardcoded relative path to avoid domain security issues (IE6 'Access is denied' error) 
		global $CONF;
		$this->baseUrl = str_replace ($CONF['AdminURL'], '', $this->getAdminURL()); 
	}

	function getName()
	{
		return 'TinyMCE';
	}

	function getAuthor()
	{
		return 'karma | roel | eph | kg | shizuki | yama';
	}

	function getURL()
	{
		return 'http://plugins.nucleuscms.org/';
	}

	function getVersion()
	{
		return '3.0.7';
	}

	function getMinNucleusVersion()
	{
		return 300;
	}

	function getDescription()
	{
		return _NP_TINYMCE01;
	}

	/**
	  * Make sure plugin still works when a database table prefix is activated for 
	  * the Nucleus installation. (Nucleus refuses to install plugins which do not
	  * support SqlTablePrefix when a database prefix is active)
	  **/
	function supportsFeature($what)
	{
		switch($what) {
			case 'HelpPage':
				return 0;
				break;
			case 'SqlTablePrefix':
				return 1;
				break;
			default:
				return 0;
		}
	}

	function install()
	{
		// create plugin options (member options)
		$this->createMemberOption(
			'use_tinymce',
			_NP_TINYMCE02,
			'yesno',
			'yes'
		);
		$this->createMemberOption(
			'member_custom',
			_NP_TINYMCE03,
			'yesno',
			'no'
		);
		$this->createMemberOption(
			'member_custom_plugin',
			_NP_TINYMCE_PLUGIN_MEMBERCUSTOM_LABEL,
			'textarea',
			_NP_TINYMCE_PLUGIN_MEMBERCUSTOM_DEAULTVALUE
		);
		$this->createMemberOption(
			'member_custom_btn1',
			_NP_TINYMCE_TOOLBAR_1_MEMBERCUSTOM_LABEL,
			'textarea',
			_NP_TINYMCE_TOOLBAR_1_MEMBERCUSTOM_DEAULTVALUE
		);
		$this->createMemberOption(
			'member_custom_btn2',
			_NP_TINYMCE_TOOLBAR_2_MEMBERCUSTOM_LABEL,
			'textarea',
			_NP_TINYMCE_TOOLBAR_2_MEMBERCUSTOM_DEAULTVALUE
		);
		$this->createMemberOption(
			'member_custom_btn3',
			_NP_TINYMCE_TOOLBAR_3_MEMBERCUSTOM_LABEL,
			'textarea',
			_NP_TINYMCE_TOOLBAR_3_MEMBERCUSTOM_DEAULTVALUE
		);
		$this->createMemberOption(
			'member_custom_btn4',
			_NP_TINYMCE_TOOLBAR_4_MEMBERCUSTOM_LABEL,
			'textarea',
			_NP_TINYMCE_TOOLBAR_4_MEMBERCUSTOM_DEAULTVALUE
		);

		// create plugin options (admin)
		$this->createOption(
			'enterkey_mode',
			_NP_TINYMCE_ENTERKEY_MODE_LABEL,
			'select',
			'p',
			_NP_TINYMCE_ENTERKEY_MODE_VALUE
		);
		$this->createOption(
			'extended_elements',
			_NP_TINYMCE04,
			'text',
			'object[*],param[*],embed[*]'
		);
		$this->createOption(
			'use_tgzip',
			_NP_TINYMCE05,
			'yesno',
			'yes'
		);
		$this->createOption(
			'path_style',
			_NP_TINYMCE06,
			'select',
			'absolute',
			_NP_TINYMCE10
		);
		$this->createOption(
			'accessibility',
			_NP_TINYMCE07,
			'yesno',
			'no'
		);
		$this->createOption(
			'skin_select',
			_NP_TINYMCE08,
			'select',
			'default',
			_NP_TINYMCE09
		);
		$this->createOption(
			'plugin',
			_NP_TINYMCE_PLUGIN_LABEL,
			'textarea',
			_NP_TINYMCE_PLUGIN_DEAULTVALUE
		);
		$this->createOption(
			'btn1',
			_NP_TINYMCE_TOOLBAR_1_LABEL,
			'textarea',
			_NP_TINYMCE_TOOLBAR_1_DEAULTVALUE
		);
		$this->createOption(
			'btn2',
			_NP_TINYMCE_TOOLBAR_2_LABEL,
			'textarea',
			_NP_TINYMCE_TOOLBAR_2_DEAULTVALUE
		);
		$this->createOption(
			'custom_css',
			_NP_TINYMCE_CUSTOM_CSS,
			'textarea',
			_NP_TINYMCE_CUSTOM_CSS_DEFAULTVALUE
		);
		$this->createOption(
			'detect_mode',
			_NP_TINYMCE_DETECT_MODE_LABEL,
			'select',
			'exact',
			_NP_TINYMCE_DETECT_MODE_VALUE
		);
		
		
		// disable the default javascript editbar that comes with nucleus
		sql_query(
			"UPDATE "
			. sql_table('config')
			. " SET   value = '1'"
			. " WHERE name  = 'DisableJSTools'"
		);
	}

	function unInstall()
	{
		// restore to standard settings
		sql_query(
			"UPDATE "
			. sql_table('config')
			. " SET   value = '2'"
			. " WHERE name  = 'DisableJSTools'"
		);
	}

	/**
	  * List of events we want to subscribe to
	  */
	function getEventList()
	{
		return array(
			'AdminPrePageHead', 	// include javascript on admin add/edit pages
			'BookmarkletExtraHead',	// include javascript on bookmarklet pages
			'PreSendContentType', 	// we need to force text/html instead of application/xhtml+xml
			'PreUpdateItem', 		// to recover Nucleus tags before the database is updated
			'PreAddItem', 			// to recover Nucleus tags before a new item is stored in the database
			'PrepareItemForEdit'	// to add breaks for the Editor if necessary
		);
	}

	function init()
	{
		// include language file for this plugin
		$language = ereg_replace( '[\\|/]', '', getLanguageName());
		$langDir  = $this->getDirectory() . 'language/';
		$incFile  = (file_exists($langDir . $language . '.php')) ? $language : 'english';
		include_once($langDir . $incFile . '.php');
		$this->language = $incFile;
		switch($incFile) {
			case "english":
			case "english-utf8":
				$this->mcelang = "en";
				break;
			case "japanese-utf8":
			case "japanese-euc":
				$this->mcelang = "ja";
				break;
			default:
				$this->mcelang = "en";
		}
	}

	/**
	  * Check NP_Mediatocu
	  */
	function _checkMediatocu()
	{
		global $manager;
		if (!$manager->pluginInstalled('NP_Mediatocu')) {
			return false;
		}
		$mediaTocu =& $manager->getPlugin('NP_Mediatocu');
		if (intval($mediaTocu->getVersion()) > 0) return $mediaTocu;
		return false;
	}

	/**
	  * Recover the default nucleus tags after TinyMCE  
	  * has converted the brackets to entities
	  */
	function _recoverTags(&$data)
	{
		$data['body'] = preg_replace('/(&lt;)%(.*)%(&gt;)/Usi', '<%\2%>', $data['body']);
		$data['more'] = preg_replace('/(&lt;)%(.*)%(&gt;)/Usi', '<%\2%>', $data['more']);
	}

	/**
	  * Add '<br />' tag when LinebreakConversion is true
	  */
	function _addBreaks(&$data)
	{
		$data['item']['body'] = addBreaks($data['item']['body']);
		$data['item']['more'] = addBreaks($data['item']['more']);
	}

	/**
	  * Remove '<br />' tag when LinebreakConversion is true
	  */
	function _removeBreaks(&$data)
	{
		$data['item']['body']= removeBreaks ($data['item']['body']);
		$data['item']['more']= removeBreaks ($data['item']['more']);
	}

	/**
	  * Use TinyMCE Editor ?
	  */
	function _usingCheck($aid, $bid)
	{
		if ($this->_memberCheck($aid) && $this->_getLinebreakConversion($bid)) {
				return true;
		}
		return false;
	}

	/**
	  * Current member using TinyMCE Editor ?
	  */
	function _memberCheck($aid)
	{
		if ($this->getMemberOption($aid, 'use_tinymce') == 'yes') {
			return true;
		}
		return false;
	}

	/**
	  * LinebreakConversion detection
	  */
	function _getLinebreakConversion($bid)
	{
		$sql = "SELECT bconvertbreaks as result "
			 . "FROM " . sql_table('blog')
			 . " WHERE bnumber = '" . $bid . "'";
		$res = quickQuery($sql);
		if ($res == 1) {
			return true;
		}
		return false;
	}

	/**
	  * Before an item is updated or add in(to) the database
	  */
	function _preUpdateOrAddItem(&$data)
	{
		$this->_recoverTags($data);
		if ($this->_usingCheck($data['item']['authorid'], $data['item']['blogid'])) {
			$this->_removeBreaks($data);
		}
	}

	/**
	  * Add extra header
	  */
	function _addExtraHead(&$data)
	{
		global $member, $blogid;
		$this->memberid = $member->id;
		$this->LinebreakConversion = $this->_getLinebreakConversion($blogid);
		$this->_getExtraHead($data);
	}

	/**
	  * Returns the extra code that needs to be inserted in the <head>...</head> section of pages that
	  * use tinyMCE
	  */
	function _getExtraHead(&$extrahead)
	{
		global $CONF;

		// get the options for the current blog
		$bUseEditor = ($this->_memberCheck($this->memberid));

		// add code for html editor
		if ($bUseEditor) {
			// To avoid conflicts if a other user use only textmode we must set this on all calls
			$CONF['DisableJsTools'] = 1; // overrule simple global settings
			$enterkey_mode          = "";
			$mediaURL               = $CONF['MediaURL'];
			$indexURL               = $CONF['IndexURL'];
			$adminURL               = $this->getAdminURL();
			$baseURL                = $this->baseUrl;
//			$baseURL                = $this->getAdminURL();
			$mceLanguage            = $this->mcelang;
			$detect_mode            = $this->getOption('detect_mode');
			$extendedElements       = "";
			$plugins                = '';
			$toolBar1               = '';
			$toolBar2               = '';
			$toolBar3               = '';
			$toolBar4               = '';
			$gZipini                = '';
			$relativeUrls           = ($this->getOption('path_style') == 'relative') ? 'true':'false'; //edited yama 20080310 v3041np2
			$convertUrls            = ($this->getOption('path_style') !== 'url') ? 'true':'false'; //added yama 20080310 v3041np2

			$accessibilityWarnings  = ($this->getOption('accessibility') == 'yes') ? 'true':'false'; //added yama 20080303 v3021np1
			

			if ($this->getOption('enterkey_mode') == 'br') {
				$enterkey_mode	=	"forced_root_block : false,
									force_br_newlines : true,
									force_p_newlines : false,";
									}

			// Extended element ?
			if ($this->getOption('extended_elements')) {
				$elements         = explode(',', $this->getOption('extended_elements'));
				$jointParts       = '," +' . "\n\t\t\t\t\t\t\t  " . '"';
				$extendedElements = $jointParts . implode($jointParts, $elements);
			}

			// NP_Mediatocu installed ?
			if ($mediatoku = $this->_checkMediatocu()) {
				$mediaPHPURL = $mediatoku->getAdminURL() . 'media.php';
			} else {
//				$mediaPHPURL = $CONF['AdminURL'] . 'media.php';
				$mediaPHPURL = $this->getAdminURL() . 'filemanager/mediaphp/media.php';
//				$mediaPHPURL = $this->baseUrl . 'media.php';
			}
			// TEST CODE
//			$mediaPHPURL = $this->getAdminURL() . 'media.php';

			// Advanced tool bar ?
			if ($this->getMemberOption($this->memberid, 'member_custom')=='yes') {
				$plugins = $this->getMemberOption($this->memberid, 'member_custom_plugin');
				$toolBar1 = $this->getMemberOption($this->memberid, 'member_custom_btn1');
				$toolBar2 = $this->getMemberOption($this->memberid, 'member_custom_btn2');
				$toolBar3 = $this->getMemberOption($this->memberid, 'member_custom_btn3');
				$toolBar4 = $this->getMemberOption($this->memberid, 'member_custom_btn4');
			} else {
				$plugins  = $this->getOption('plugin');
				$toolBar1 = $this->getOption('btn1');
				$toolBar2 = $this->getOption('btn2');
				$toolBar3 = "";
				$toolBar4 = "";
			}

			// Skin Select
			switch ($this->getOption('skin_select')) {
			case "default":
				$skinSelect ="";
				break;
			case "o2k7":
				$skinSelect ="	skin : \"o2k7\",";
				break;
			case "o2k7_silver":
				$skinSelect ="	skin : \"o2k7\",	skin_variant : \"silver\",";
				break;
			case "o2k7_black":
				$skinSelect ="	skin : \"o2k7\",	skin_variant : \"black\",";
				break;
			}


			// GZip compression ?
			if ($this->getOption('use_tgzip') == 'yes') {
//				$tinyMCE = 'tiny_mce_gzip.php';
				$tinyMCE = 'tiny_mce_gzip.js';
				$gZipini = <<<_GZIPINIT_

<script type="text/javascript">
tinyMCE_GZ.init({
	plugins : "$plugins",
	themes : "advanced",
	$skinSelect
	languages : "{$mceLanguage}",
	disk_cache : true,
	debug : false
});
</script>

_GZIPINIT_;
			} else {
				$tinyMCE = 'tiny_mce.js';
			}

			$editorCode .= <<<_EDITORCODE_

<style type=text/css>
	div.contextMenu table,
	div.mceMenu table {
		width : auto;
		margin : 0;
	}
</style>
<script type="text/javascript" src="{$baseURL}jscripts/tiny_mce/{$tinyMCE}"></script>
<script type="text/javascript">
var file_path, f_n, w_n, mediapopup;

function includeImage(collection, filename, type , width, height) {
	w_n.document.forms[0].elements[f_n].value = "{$mediaURL}" + collection + "/" + filename;
	w_n.document.forms[0].elements["width"].value = width;
	w_n.document.forms[0].elements["height"].value = height;
	w_n.focus();
	mediapopup.close();
}
function includeOtherMedia(collection, filename) {
	w_n.document.forms[0].elements[f_n].value = "{$mediaURL}" + collection + "/" + filename;
	w_n.focus();
	mediapopup.close();
}
</script>
{$gZipini}
<script type="text/javascript">
tinyMCE.init({ 
	language : "{$mceLanguage}",
	mode : "{$detect_mode}",
	$enterkey_mode
	convert_fonts_to_spans : true,
	font_size_style_values : "xx-small,x-small,small,medium,large,x-large,xx-large",
	elements : "inputbody,inputmore",
	width : "100%",
	theme : "advanced",
	$skinSelect
	convert_urls : $convertUrls,
	relative_urls : $relativeUrls,
	accessibility_warnings : $accessibilityWarnings,
	button_tile_map : true,
	popup_css_add : "{$adminURL}style/popup_add.css",
	theme_advanced_blockformats : "h3,h4,h5,h6,p,dt,dd,div",
	document_base_url : "{$indexURL}",  
	content_css : "{$adminURL}style/style.css",
	plugins : "{$plugins}",
	theme_advanced_buttons1 : "{$toolBar1}",
	theme_advanced_buttons1_add : "",
	theme_advanced_buttons2 : "{$toolBar2}",
	theme_advanced_buttons3 : "{$toolBar3}",
	theme_advanced_buttons4 : "{$toolBar4}",
	theme_advanced_toolbar_location : "top",
	theme_advanced_toolbar_align : "left",
	theme_advanced_path_location : "bottom",
	theme_advanced_resizing : true,
	theme_advanced_resize_horizontal : false,
	extended_valid_elements : "a[name|href|target|title|onclick|linkcnt|rel]," +
							  "img[class|src|border=0|alt|title|hspace|vspace|width|height|align|onmouseover|onmouseout|name|float|style]," +
							  "hr[class|width|size|noshade],span[class|align|style]{$extendedElements}",
	paste_create_paragraphs : true,
	paste_use_dialog : true,
	paste_auto_cleanup_on_paste : true,
	cleanup : true,
	file_browser_callback : "myCustomFileBrowser"
});
/*
function myCustomFileBrowser(field_name, url, type, win) {
	// Do custom browser logic
	mediapopup = window.open("{$mediaPHPURL}","name", "status=yes,toolbar=no,scrollbars=yes,resizable=yes,width=500,height=450,top=0,left=0,dependent=yes");
	f_n = field_name;
	w_n = win;
	//win.document.forms[0].elements[field_name].value = fn;
}
*/
function myCustomFileBrowser (field_name, url, type, win) {
//	alert("Field_Name: " + field_name + "\\nURL: " + url + "\\nType: " + type + "\\nWin: " + win); //debug code
	var cmsURL = "{$mediaPHPURL}";
	tinyMCE.activeEditor.windowManager.open({
		file : cmsURL,
		width : 500,  // Your dimensions may differ - toy around with them!
		height : 450,
		resizable : "yes",
		inline : "yes",  // This parameter only has an effect if you use the inlinepopups plugin!
		close_previous : "no"
	}, {
		w_n : win,
		f_n : field_name,
		file_path : field_name,
		file_type : type
	});
	return false;
}
</script>

_EDITORCODE_;

			$extrahead .= $editorCode;
		} else {
			// enable nucleus toolbar if wysiwyg editor isn't used
			$CONF['DisableJsTools'] = 2;
		}
	}

	/**
	  * Before an item is sent to the textarea for editing
	  */
	function event_PrepareItemForEdit(&$data)
	{ 
		if ($this->_usingCheck($data['item']['authorid'], $data['item']['blogid'])) {
			$this->_addBreaks($data);
		}
	}

	/**
	  * Before an item is updated in the database
	  */
	function event_PreUpdateItem(&$data)
	{
		$this->_preUpdateOrAddItem($data);
	}

	/**
	  * Before a new item is written into the database
	  */
	function event_PreAddItem(&$data)
	{
		$this->_preUpdateOrAddItem($data);
	}

	/**
	  * Hook into the <head> section of bookmarkler area pages.
	  * Insert extra script/css includes there.
	  */
	function event_BookmarkletExtraHead(&$data)
	{
		$this->_addExtraHead($data['extrahead']);
	}

	/**
	  * Hook into the <head> section of admin area pages. When the requested page is an "add item" or
	  * "edit item" form, get the memberid and include the extra code.
	  */
	function event_AdminPrePageHead(&$data) 
	{
		global $member, $blogid;
		$action = $data['action']; 
		if (($action != 'createitem') && ($action != 'itemedit')) {
			return;
		}
		$this->_addExtraHead($data['extrahead']);
	}

	/**
	  * Nucleus sends its admin area pages as application/xhtml+xml to browsers that can handle this.
	  *
	  * Unfortunately, this causes javascripts that alter page contents through non-DOM methods
	  * to stop working correctly. As the jscalendar and htmlarea both need this, we're forcing
	  * the content-type to text/html for add/edit item forms.
	  */
	function event_PreSendContentType(&$data)
	{
		$pageType = $data['pageType'];
		switch($pageType) {
			case 'bookmarklet-add':
			case 'bookmarklet-edit':
			case 'admin-createitem':
			case 'admin-itemedit':
				if ($data['contentType'] == 'application/xhtml+xml') {
					$data['contentType'] = 'text/html';
				}
		}
	}


}

