/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2013 Yuichi Watanabe
 */

#include <core/assert.h>
#include <core/cpu.h>
#include <core/mm.h>
#include <core/param.h>
#include <core/printf.h>
#include <core/string.h>
#include "current.h"
#include "guest_boot.h"
#include "panic.h"
#include "regs.h"

static u8 bios_boot_drive;
static bool boot_once = false;

void
set_bios_boot_drive(u8 drive)
{
	bios_boot_drive = drive;
}

void
setup_guestboot(void)
{
	void *p;
	u8 boot_drive;

	ASSERT(cpu_is_bsp());

	/*
	 * vm0 boots from host BOIS.
	 */
	p = mapmem_hphys (GUEST_BOOT_OFFSET, GUEST_BOOT_LENGTH,
			  MAPMEM_WRITE);
	if (p == NULL) {
		panic("Failed to map the guest boot area.");
	}
	memcpy (p, guest_boot_start, GUEST_BOOT_LENGTH);
	unmapmem (p, GUEST_BOOT_LENGTH);
	current->vmctl.write_realmode_seg (SREG_CS, 0x0);
	current->vmctl.write_ip (GUEST_BOOT_OFFSET);

	if (param_get_str(VM0_NAME ".boot_int18", 0, NULL, 0)
	    == VMMERR_SUCCESS) {
		if (boot_once) {
			current->vmctl.write_general_reg(
				GENERAL_REG_RCX, 0x80);
			printf("Boot from 0x%x drive.\n", 0x80);
		} else {
			current->vmctl.write_general_reg (GENERAL_REG_RDI, 1);
			printf("Boot using int18.\n");
		}
	} else {
		if (param_get_u8(VM0_NAME ".boot_drive", 0,
				 &boot_drive) == VMMERR_SUCCESS) {
			current->vmctl.write_general_reg(
				GENERAL_REG_RCX, boot_drive);
			printf("Boot from 0x%x drive.\n", boot_drive);
		} else {
			current->vmctl.write_general_reg(
				GENERAL_REG_RCX, bios_boot_drive);
			printf("Boot from 0x%x drive.\n",
			       bios_boot_drive);
		}
		if (param_get_str(VM0_NAME ".boot_partition",
				  0, NULL, 0) == VMMERR_SUCCESS) {
			current->vmctl.write_general_reg(
				GENERAL_REG_RSI, 1);
			printf("Use loader of active partition\n");
		}
	}
	boot_once = true;
}
