/*
 * Copyright (c) 2010-2013 Yuichi Watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _IO_IOAPIC_REGS_H
#define _IO_IOAPIC_REGS_H

#define IOAPIC_MEM_START		0xfec00000
#define IOAPIC_MEM_SIZE			0x00001000

#define IOAPIC_INDEX_REG_OFFSET		0x00000000
#define IOAPIC_DATA_REG_OFFSET		0x00000010

#define IOAPIC_ID_REG_INDEX		0x00
#define IOAPIC_VER_REG_INDEX		0x01

#define IOAPIC_VER_REG_MRE		0x00ff0000
#define IOAPIC_VER_REG_SHIFT		16

#define IOAPIC_REDIR_TBL0_LOW_INDEX	0x10
#define IOAPIC_REDIR_TBL_SIZE		2

#define IOAPIC_REDIR_LOW_VECTOR_MASK		0x000000ff
#define IOAPIC_REDIR_LOW_VECTOR_SHIFT		0
#define IOAPIC_REDIR_LOW_DELIVERY_MODE_MASK	0x00000700
#define IOAPIC_REDIR_LOW_DELIVERY_MODE_FIXED	0x00000000
#define IOAPIC_REDIR_LOW_DELIVERY_MODE_LOWEST_PRIO 0x00000100
#define IOAPIC_REDIR_LOW_DELIVERY_MODE_EXTINT	0x00000700

#define IOAPIC_REDIR_LOW_LOGICAL_DEST_BIT	0x00000800
#define IOAPIC_REDIR_LOW_LEVEL_TRIGGER_BIT	0x00008000
#define IOAPIC_REDIR_LOW_MASK_BIT		0x00010000

#define IOAPIC_REDIR_HIGH_DEST_MASK		0xff000000
#define IOAPIC_REDIR_HIGH_DEST_SHIFT		24

#endif /* _IO_IOAPIC_REGS_H */
