/*
 * Copyright (c) 2014 Yuichi Watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#include <common.h>
#include <core/printf.h>
#include "pci.h"

#define XUSB2PR		0xd0
#define XUSB2PRM	0xd4

static void
xhci_new(struct pci_device *dev)
{
	u32 reg_val;

	if (!dev->assigned) {
		return;
	}

	reg_val = pci_read_config32(dev, XUSB2PRM);
	printf("xHCI %s is assigned. Route USB2 port to xHCI. 0x%x\n",
	       dev->name, reg_val);
	pci_write_config32(dev, XUSB2PR, reg_val);
	pci_update_saved_config(dev, XUSB2PR, &reg_val, 4);
}

static struct pci_driver xhci_driver = {
	.id = {0x1e318086, 0xffffffff},
	.new = xhci_new,
	.name = "xhci",
	.reinit = xhci_new,
};

static void
xhci_init(void)
{
	pci_register_driver(&xhci_driver);
}

PCI_DRIVER_INIT(xhci_init);
