/*
 * Copyright (c) 2010-2012 Yuichi Watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __IO_PIC_H
#define __IO_PIC_H

#define PIC_MASTER_CMD_PORT	0x20
#define PIC_MASTER_IMR_PORT	0x21
#define PIC_SLAVE_CMD_PORT	0xa0
#define PIC_SLAVE_IMR_PORT	0xa1

/* CMD PORT */
#define PIC_ICW1_SELECT_MASK		0x10
#define PIC_ICW1_SELECT_MATCH		0x10
#define PIC_NON_SPECIFIC_EOI_MASK	0xf8
#define PIC_NON_SPECIFIC_EOI_MATCH	0x20
#define PIC_SPECIFIC_EOI_MASK		0xf8
#define PIC_SPECIFIC_EOI_MATCH		0x60
#define PIC_EOI_IRQ_MASK		0x07
#define PIC_OCW3_SELECT_MASK		0x98
#define PIC_OCW3_SELECT_MATCH		0x08
#define PIC_OCW3_READ_REG_MASK		0x03
#define PIC_OCW3_READ_ISR		0x03
#define PIC_OCW3_READ_IRR		0x02

/* IMR PORT */
#define PIC_ICW2_SELECT_MASK	0x18
#define PIC_ICW2_SELECT_MATCH	0x00
#define PIC_ICW3_SELECT_MASK	0x18
#define PIC_ICW3_SELECT_MATCH	0x01
#define PIC_ICW2_VECTOR_MASK	0xf8
#define PIC_ICW4_AUTO_EOI	0x02

#endif /* __IO_PIC_H */
