/*
 * Decompiled with CFR 0.152.
 */
package tinytoolkits.weboard;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import tinytoolkits.weboard.Board;

public class BoardDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private Board _currnetBoard;
    private TextField _inputText = new TextField();
    private boolean _changedItem;

    public BoardDialog(Frame frame) {
        super(frame, true);
        this.init();
    }

    private void init() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BoardDialog.this.setVisible(false);
            }
        });
        this.setSize(200, 80);
        this.setLayout(new BorderLayout());
        this.add((Component)this._inputText, "Center");
        Panel panel = new Panel();
        Button button = new Button("OK");
        Button button2 = new Button("\u30ad\u30e3\u30f3\u30bb\u30eb");
        panel.add(button);
        panel.add(button2);
        this.add((Component)panel, "South");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardDialog.this.checkChangeAndSetAllToItem();
                BoardDialog.this.setVisible(false);
            }
        });
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardDialog.this._changedItem = false;
                BoardDialog.this.setVisible(false);
            }
        });
    }

    public void setBoard(Board board) {
        this._changedItem = false;
        this._currnetBoard = board;
        this._inputText.setText(board.getName());
    }

    private void checkChangeAndSetAllToItem() {
        if (this._currnetBoard.getName().trim().length() == 0 && this._inputText.getText().equals(this._currnetBoard.getName())) {
            return;
        }
        this._changedItem = true;
        this._currnetBoard.setName(this._inputText.getText());
    }

    public boolean isChanged() {
        return this._changedItem;
    }
}

