/*
 * Decompiled with CFR 0.152.
 */
package tinytoolkits.weboard;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.StringTokenizer;
import tinytoolkits.weboard.Board;
import tinytoolkits.weboard.MemoItem;
import tinytoolkits.weboard.WEBoardDomain;

public class HTTPGate {
    private URL _url;
    private HttpURLConnection _urlconn;
    private WEBoardDomain _domain;

    public HTTPGate(String string, WEBoardDomain wEBoardDomain) throws MalformedURLException, IOException {
        this._url = new URL(string + "/cgi-bin/items.rb");
        this._domain = wEBoardDomain;
    }

    private void reset() throws IOException {
        this._urlconn = (HttpURLConnection)this._url.openConnection();
        this._urlconn.setRequestMethod("POST");
        this._urlconn.setDoOutput(true);
    }

    public void getBoard(int n) throws IOException {
        this.reset();
        PrintWriter printWriter = new PrintWriter(this._urlconn.getOutputStream());
        printWriter.print("draw_command=getBoard");
        printWriter.print("&");
        printWriter.print("id=" + n);
        printWriter.close();
        String string = this.post();
        this.loadCurrentBoard(string);
    }

    private void loadCurrentBoard(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!"board".equals(string2)) continue;
                String string3 = stringTokenizer.nextToken();
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                String string4 = stringTokenizer.nextToken().substring(1);
                Board board = new Board(Integer.parseInt(string3), n, n2, string4);
                this._domain.setCurrentBoard(board);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(string);
            numberFormatException.printStackTrace();
        }
    }

    public void getAll() throws IOException {
        this.reset();
        PrintWriter printWriter = new PrintWriter(this._urlconn.getOutputStream());
        printWriter.print("draw_command=getAll");
        printWriter.print("&");
        printWriter.print("currentBoardID=" + this._domain.getCurrentBoard().getID());
        printWriter.close();
        String string = this.post();
        this.loadItems(string);
    }

    public void addBoard(Board board) throws IOException {
        this.reset();
        PrintWriter printWriter = new PrintWriter(this._urlconn.getOutputStream());
        printWriter.print("draw_command=addBoard");
        printWriter.print("&");
        this.addBoardAttributes(printWriter, board);
        printWriter.close();
        String string = this.post();
        this.loadItems(string);
    }

    public void changeBoard(Board board) throws IOException {
        this.reset();
        PrintWriter printWriter = new PrintWriter(this._urlconn.getOutputStream());
        printWriter.print("draw_command=changeBoard");
        printWriter.print("&");
        this.addBoardAttributes(printWriter, board);
        printWriter.close();
        String string = this.post();
        this.loadItems(string);
    }

    private void addBoardAttributes(PrintWriter printWriter, Board board) {
        printWriter.print("currentBoardID=" + this._domain.getCurrentBoard().getID());
        printWriter.print("&");
        printWriter.print("itemID=" + board.getID());
        printWriter.print("&");
        printWriter.print("x=" + board.getX());
        printWriter.print("&");
        printWriter.print("y=" + board.getY());
        printWriter.print("&");
        printWriter.print("name=" + board.getName());
    }

    public void addMemo(MemoItem memoItem) throws IOException {
        this.reset();
        PrintWriter printWriter = new PrintWriter(this._urlconn.getOutputStream());
        printWriter.print("draw_command=addMemo");
        printWriter.print("&");
        this.addMemoAttributes(printWriter, memoItem);
        printWriter.close();
        String string = this.post();
        this.loadItems(string);
    }

    public void removeMemo(MemoItem memoItem) throws IOException {
        this.reset();
        PrintWriter printWriter = new PrintWriter(this._urlconn.getOutputStream());
        printWriter.print("currentBoardID=" + this._domain.getCurrentBoard().getID());
        printWriter.print("&");
        printWriter.print("draw_command=removeMemo");
        printWriter.print("&");
        printWriter.print("itemID=" + memoItem.getID());
        printWriter.close();
        String string = this.post();
        this.loadItems(string);
    }

    public void changeMemo(MemoItem memoItem) throws IOException {
        this.reset();
        PrintWriter printWriter = new PrintWriter(this._urlconn.getOutputStream());
        printWriter.print("draw_command=changeMemo");
        printWriter.print("&");
        this.addMemoAttributes(printWriter, memoItem);
        printWriter.close();
        String string = this.post();
        this.loadItems(string);
    }

    private void addMemoAttributes(PrintWriter printWriter, MemoItem memoItem) {
        printWriter.print("currentBoardID=" + this._domain.getCurrentBoard().getID());
        printWriter.print("&");
        printWriter.print("itemID=" + memoItem.getID());
        printWriter.print("&");
        printWriter.print("x=" + memoItem.getX());
        printWriter.print("&");
        printWriter.print("y=" + memoItem.getY());
        printWriter.print("&");
        printWriter.print("w=" + memoItem.getW());
        printWriter.print("&");
        printWriter.print("h=" + memoItem.getH());
        printWriter.print("&");
        printWriter.print("text=" + memoItem.getText());
        printWriter.print("&");
        printWriter.print("fColor=" + memoItem.getForeColor().getRGB());
        printWriter.print("&");
        printWriter.print("bColor=" + memoItem.getBackColor().getRGB());
        printWriter.print("&");
        printWriter.print("lColor=" + memoItem.getLineColor().getRGB());
    }

    public String post() throws IOException {
        String string;
        this._urlconn.connect();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this._urlconn.getInputStream(), Charset.forName("UTF-8")));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string + "\n");
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    private void loadItems(String string) {
        this._domain.getCurrentBoardItemList().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        try {
            while (stringTokenizer.hasMoreTokens()) {
                int n;
                int n2;
                String string2;
                String string3 = stringTokenizer.nextToken();
                if ("item".equals(string3)) {
                    string2 = stringTokenizer.nextToken();
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    String string4 = stringTokenizer.nextToken().substring(1);
                    Color color = new Color(Integer.parseInt(stringTokenizer.nextToken()));
                    Color color2 = new Color(Integer.parseInt(stringTokenizer.nextToken()));
                    Color color3 = new Color(Integer.parseInt(stringTokenizer.nextToken()));
                    MemoItem memoItem = new MemoItem(Integer.parseInt(string2), n2, n, n3, n4, string4);
                    memoItem.setForeColor(color);
                    memoItem.setBackColor(color2);
                    memoItem.setLineColor(color3);
                    this._domain.getCurrentBoardItemList().add(memoItem);
                    continue;
                }
                if (!"board".equals(string3)) continue;
                string2 = stringTokenizer.nextToken();
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                n = Integer.parseInt(stringTokenizer.nextToken());
                String string5 = stringTokenizer.nextToken().substring(1);
                Board board = new Board(Integer.parseInt(string2), n2, n, string5);
                this._domain.getCurrentBoardItemList().add(board);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(string);
            numberFormatException.printStackTrace();
        }
    }

    public void disconnect() {
        this._urlconn.disconnect();
    }
}

