/*
 * Decompiled with CFR 0.152.
 */
package tinytoolkits.weboard;

import tinytoolkits.weboard.MemoItem;
import tinytoolkits.weboard.RectangleItem;

public class MousePoint {
    private boolean _click;
    private int _clickX;
    private int _clickY;
    private int _lastDragX;
    private int _lastDragY;
    private int _dragX;
    private int _dragY;
    private RectangleItem _dragItem;
    private MemoItem _handle = new MemoItem(-1, 0, 0, 5, 5, null);
    private boolean _dragHandle;

    public void setDragItem(RectangleItem rectangleItem) {
        this._dragItem = rectangleItem;
        this._dragHandle = false;
        if (this._dragItem != null) {
            this._handle.setX(this._dragItem.getX() + this._dragItem.getW());
            this._handle.setY(this._dragItem.getY() + this._dragItem.getH());
        }
    }

    public boolean existDragItem() {
        return this._dragItem != null;
    }

    public RectangleItem getDragItem() {
        return this._dragItem;
    }

    public MemoItem getHandle() {
        return this._handle;
    }

    public void dragHandle() {
        this._dragHandle = true;
    }

    public boolean isDragHandle() {
        return this._dragHandle;
    }

    public void click(int n, int n2) {
        this._clickX = n;
        this._clickY = n2;
        this._dragX = this._clickX;
        this._dragY = this._clickY;
        this._lastDragX = this._clickX;
        this._lastDragY = this._clickY;
        this._click = true;
    }

    public boolean isClick() {
        return this._click;
    }

    public int getClickX() {
        return this._clickX;
    }

    public int getClickY() {
        return this._clickY;
    }

    public void drag(int n, int n2) {
        this._lastDragX = this._dragX;
        this._lastDragY = this._dragY;
        this._dragX = n;
        this._dragY = n2;
    }

    public void resetDragPoint() {
        if (this._dragItem != null) {
            this._handle.setX(this._dragItem.getX() + this._dragItem.getW());
            this._handle.setY(this._dragItem.getY() + this._dragItem.getH());
        }
    }

    public String toString() {
        return "click=" + this._clickX + "," + this._clickY + " lastDrag=" + this._lastDragX + "," + this._lastDragY + " drag=" + this._dragX + "," + this._dragY;
    }

    public int getDragX() {
        return this._dragX;
    }

    public int getDragY() {
        return this._dragY;
    }

    public boolean isMove() {
        return this.getMoveX() != 0 || this.getMoveY() != 0;
    }

    public int getMoveX() {
        return this._dragX - this._lastDragX;
    }

    public int getMoveY() {
        return this._dragY - this._lastDragY;
    }

    public void released() {
        this._click = false;
        this._dragHandle = false;
    }
}

