package tinytoolkits.weboard;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class BoardDialog extends Dialog {

	private static final long serialVersionUID = 1L;

	private Board _currnetBoard;

	private TextField _inputText = new TextField();

	private boolean _changedItem;

	public BoardDialog(Frame owner) {
		super(owner, true);
		init();
	}

	private void init() {
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
			}
		});

		this.setSize(200, 80);

		this.setLayout(new BorderLayout());
		this.add(_inputText, BorderLayout.CENTER);

		{
			Panel panel = new Panel();
			Button okBtn = new Button("OK");
			Button cancelBtn = new Button("LZ");

			panel.add(okBtn);
			panel.add(cancelBtn);
			this.add(panel, BorderLayout.SOUTH);

			okBtn.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					checkChangeAndSetAllToItem();
					setVisible(false);
				}
			});

			cancelBtn.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					_changedItem = false;
					setVisible(false);
				}
			});
		}

	}

	public void setBoard(Board item) {
		_changedItem = false;

		_currnetBoard = item;
		_inputText.setText(item.getName());

	}

	private void checkChangeAndSetAllToItem() {
		if (_currnetBoard.getName().trim().length() == 0 && _inputText.getText().equals(_currnetBoard.getName())) {
			return;
		}
		_changedItem = true;

		_currnetBoard.setName(_inputText.getText());

	}

	public boolean isChanged() {
		return _changedItem;
	}
}
