package tinytoolkits.weboard;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.StringTokenizer;

public class HTTPGate {

	private URL _url;
	private HttpURLConnection _urlconn;

	private WEBoardDomain _domain;

	public HTTPGate(String path, WEBoardDomain domain) throws MalformedURLException, IOException {
		//System.out.println("path=" + path);
		_url = new URL(path + "/cgi-bin/items.rb");

		_domain = domain;
	}

	private void reset() throws IOException {
		//System.out.println("reset start");

		_urlconn = (HttpURLConnection) _url.openConnection();

		_urlconn.setRequestMethod("POST");
		_urlconn.setDoOutput(true);

		//System.out.println("reset ok");
	}

	public void getBoard(int id) throws IOException {
		reset();

		PrintWriter pw = new PrintWriter(_urlconn.getOutputStream());
		pw.print("draw_command=getBoard");
		pw.print("&");
		pw.print("id=" + id);
		pw.close();

		String ret = post();
		loadCurrentBoard(ret);
	}

	private void loadCurrentBoard(String serverData) {

		StringTokenizer st = new StringTokenizer(serverData, "\t");

		try {
			while (st.hasMoreTokens()) {
				String type = st.nextToken();

				if ("board".equals(type)) {
					String id = st.nextToken();

					int x = Integer.parseInt(st.nextToken());
					int y = Integer.parseInt(st.nextToken());

					//eLXg󕶎̎̑΍̂߁A1ڂ"@"ǉĂ
					String name = st.nextToken().substring(1);

					Board board = new Board(Integer.parseInt(id), x, y, name);

					_domain.setCurrentBoard(board);
				}
			}
		} catch (NumberFormatException e) {
			System.out.println(serverData);
			e.printStackTrace();
		}

	}

	public void getAll() throws IOException {
		reset();

		PrintWriter pw = new PrintWriter(_urlconn.getOutputStream());
		pw.print("draw_command=getAll");
		pw.print("&");
		pw.print("currentBoardID=" + _domain.getCurrentBoard().getID());
		pw.close();

		String ret = post();
		loadItems(ret);
	}
	
	public void addBoard(Board board) throws IOException {
		reset();

		PrintWriter pw = new PrintWriter(_urlconn.getOutputStream());
		pw.print("draw_command=addBoard");
		pw.print("&");
		addBoardAttributes(pw, board);

		pw.close();

		String ret = post();
		loadItems(ret);
	}

	public void changeBoard(Board board) throws IOException {
		reset();

		PrintWriter pw = new PrintWriter(_urlconn.getOutputStream());
		pw.print("draw_command=changeBoard");
		pw.print("&");
		addBoardAttributes(pw, board);

		pw.close();

		String ret = post();
		loadItems(ret);
	}

	private void addBoardAttributes(PrintWriter pw, Board board) {
		pw.print("currentBoardID=" + _domain.getCurrentBoard().getID());
		pw.print("&");
		pw.print("itemID=" + board.getID());
		pw.print("&");
		pw.print("x=" + board.getX());
		pw.print("&");
		pw.print("y=" + board.getY());
		pw.print("&");
		pw.print("name=" + board.getName());
	}

	public void addMemo(MemoItem item) throws IOException {
		reset();

		PrintWriter pw = new PrintWriter(_urlconn.getOutputStream());
		pw.print("draw_command=addMemo");
		pw.print("&");
		addMemoAttributes(pw, item);

		pw.close();

		String ret = post();
		loadItems(ret);
	}

	public void removeMemo(MemoItem item) throws IOException {
		reset();

		PrintWriter pw = new PrintWriter(_urlconn.getOutputStream());
		pw.print("currentBoardID=" + _domain.getCurrentBoard().getID());
		pw.print("&");
		pw.print("draw_command=removeMemo");
		pw.print("&");
		pw.print("itemID=" + item.getID());

		pw.close();

		String ret = post();
		loadItems(ret);
	}

	public void changeMemo(MemoItem item) throws IOException {
		reset();

		PrintWriter pw = new PrintWriter(_urlconn.getOutputStream());
		pw.print("draw_command=changeMemo");
		pw.print("&");
		addMemoAttributes(pw, item);
		pw.close();

		String ret = post();
		loadItems(ret);
	}

	private void addMemoAttributes(PrintWriter pw, MemoItem item) {
		pw.print("currentBoardID=" + _domain.getCurrentBoard().getID());
		pw.print("&");
		pw.print("itemID=" + item.getID());
		pw.print("&");
		pw.print("x=" + item.getX());
		pw.print("&");
		pw.print("y=" + item.getY());
		pw.print("&");
		pw.print("w=" + item.getW());
		pw.print("&");
		pw.print("h=" + item.getH());
		pw.print("&");
		pw.print("text=" + item.getText());
		pw.print("&");
		pw.print("fColor=" + item.getForeColor().getRGB());
		pw.print("&");
		pw.print("bColor=" + item.getBackColor().getRGB());
		pw.print("&");
		pw.print("lColor=" + item.getLineColor().getRGB());
	}

	public String post() throws IOException {
		_urlconn.connect();

		BufferedReader reader = new BufferedReader(new InputStreamReader(_urlconn.getInputStream(), Charset.forName("UTF-8")));

		StringBuffer sb = new StringBuffer();
		while (true) {
			String line = reader.readLine();
			if (line == null) {
				break;
			}
			sb.append(line + "\n");
		}

		reader.close();

		//_urlconn.disconnect();
		return sb.toString();
	}

	private void loadItems(String serverData) {

		_domain.getCurrentBoardItemList().clear();

		StringTokenizer st = new StringTokenizer(serverData, "\t");

		try {
			while (st.hasMoreTokens()) {
				String type = st.nextToken();

				if ("item".equals(type)) {
					String id = st.nextToken();

					int x = Integer.parseInt(st.nextToken());
					int y = Integer.parseInt(st.nextToken());
					int w = Integer.parseInt(st.nextToken());
					int h = Integer.parseInt(st.nextToken());

					//eLXg󕶎̎̑΍̂߁A1ڂ"@"ǉĂ
					String text = st.nextToken().substring(1);

					Color fColor = new Color(Integer.parseInt(st.nextToken()));
					Color bColor = new Color(Integer.parseInt(st.nextToken()));
					Color lColor = new Color(Integer.parseInt(st.nextToken()));

					MemoItem item = new MemoItem(Integer.parseInt(id), x, y, w, h, text);
					item.setForeColor(fColor);
					item.setBackColor(bColor);
					item.setLineColor(lColor);

					_domain.getCurrentBoardItemList().add(item);
				} else if ("board".equals(type)) {
					String id = st.nextToken();

					int x = Integer.parseInt(st.nextToken());
					int y = Integer.parseInt(st.nextToken());

					//eLXg󕶎̎̑΍̂߁A1ڂ"@"ǉĂ
					String name = st.nextToken().substring(1);

					Board board = new Board(Integer.parseInt(id), x, y, name);

					_domain.getCurrentBoardItemList().add(board);
				}
			}
		} catch (NumberFormatException e) {
			System.out.println(serverData);
			e.printStackTrace();
		}

	}

	public void disconnect() {
		_urlconn.disconnect();
	}
}
