package tinytoolkits.weboard;

import java.awt.Color;

import tinytoolkits.weboard.RectangleItem.AbstractRectangleItem;

public class MemoItem extends AbstractRectangleItem {

	private int _w;
	private int _h;
	private String _text;
	private Color _foreColor = Color.BLACK;
	private Color _backColor = Color.WHITE;
	private Color _lineColor = Color.BLACK;

	public MemoItem(int id, int x, int y, int w, int h, String text) {
		super(id, x, y);
		_w = w;
		_h = h;
		_text = text;
	}

	public int getW() {
		return _w;
	}

	public void setW(int w) {
		this._w = w;
	}

	public int getH() {
		return _h;
	}

	public void setH(int h) {
		this._h = h;
	}

	public String getText() {
		return _text;
	}

	public void setText(String text) {
		this._text = text;
	}

	public Color getForeColor() {
		return _foreColor;
	}

	public void setForeColor(Color color) {
		this._foreColor = color;
	}

	public Color getBackColor() {
		return _backColor;
	}

	public void setBackColor(Color color) {
		this._backColor = color;
	}

	public Color getLineColor() {
		return _lineColor;
	}

	public void setLineColor(Color color) {
		this._lineColor = color;
	}

	public String toString() {
		return "id=" + getID() + ",(" + getX() + "," + getY() + "," + _w + "," + _h + //
				",Color=" + _foreColor.getRGB() + "," + _backColor.getRGB() + "," + _lineColor.getRGB() + //
				")[" + _text + "]";
	}

}
