package tinytoolkits.weboard;

public class MousePoint {

	private boolean _click;
	private int _clickX;
	private int _clickY;

	private int _lastDragX;
	private int _lastDragY;

	private int _dragX;
	private int _dragY;

	private RectangleItem _dragItem;

	private MemoItem _handle = new MemoItem(-1, 0, 0, 5, 5, null);
	private boolean _dragHandle;

	public void setDragItem(RectangleItem item) {
		_dragItem = item;
		_dragHandle = false;

		if (_dragItem != null) {
			_handle.setX(_dragItem.getX() + _dragItem.getW());
			_handle.setY(_dragItem.getY() + _dragItem.getH());
		}
	}

	public boolean existDragItem() {
		return _dragItem != null;
	}

	public RectangleItem getDragItem() {
		return _dragItem;
	}

	public MemoItem getHandle() {
		return _handle;
	}

	public void dragHandle() {
		_dragHandle = true;
	}

	public boolean isDragHandle() {
		return _dragHandle;
	}

	public void click(int x, int y) {
		_clickX = x;
		_clickY = y;

		_dragX = _clickX;
		_dragY = _clickY;

		_lastDragX = _clickX;
		_lastDragY = _clickY;

		_click = true;
	}

	public boolean isClick() {
		return _click;
	}

	public int getClickX() {
		return _clickX;
	}

	public int getClickY() {
		return _clickY;
	}

	public void drag(int x, int y) {
		_lastDragX = _dragX;
		_lastDragY = _dragY;

		_dragX = x;
		_dragY = y;
	}

	public void resetDragPoint() {
		if (_dragItem != null) {
			_handle.setX(_dragItem.getX() + _dragItem.getW());
			_handle.setY(_dragItem.getY() + _dragItem.getH());
		}
	}

	public String toString() {
		return "click=" + _clickX + "," + _clickY + " lastDrag=" + _lastDragX + "," + _lastDragY + " drag=" + _dragX + "," + _dragY;
	}

	public int getDragX() {
		return _dragX;
	}

	public int getDragY() {
		return _dragY;
	}

	public boolean isMove() {
		return (getMoveX() != 0) || (getMoveY() != 0);
	}

	public int getMoveX() {
		return _dragX - _lastDragX;
	}

	public int getMoveY() {
		return _dragY - _lastDragY;
	}

	public void released() {
		_click = false;
		_dragHandle = false;
	}

}
