package tinytoolkits.weboard;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import tinytoolkits.color.SVGColors;
import tinytoolkits.color.TinyNamedColor;

public class SelectColorDialog extends Dialog {

	private static final long serialVersionUID = 1L;

	private final static TinyNamedColor[] COLORS = SVGColors.getAllColors();

	private Panel _btnPanel = new Panel();

	private Color _selectedColor = Color.WHITE;

	private boolean _okEnd;

	private final static int COL_LENGTH = 4;

	public SelectColorDialog(Frame owner) {
		super(owner, true);

		init();
	}

	public void init() {
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
			}
		});

		this.setLayout(new BorderLayout());
		this.setSize(300, 50 + (COLORS.length / COL_LENGTH) * 13);

		{
			Panel panel = new Panel();
			this.add(panel, BorderLayout.CENTER);

			panel.setLayout(new GridLayout(0, COL_LENGTH));

			for (int i = 0; i < COLORS.length; i++) {
				Label label = new Label(COLORS[i].getName());
				label.setBackground(COLORS[i].getColor());
				panel.add(label);

				label.addMouseListener(new MouseAdapter() {
					public void mousePressed(MouseEvent e) {
						panel_mousePressed(e);
					}
				});
			}
		}

		{
			Button okBtn = new Button("OK");
			Button cancelBtn = new Button("LZ");

			_btnPanel.add(okBtn);
			_btnPanel.add(cancelBtn);
			this.add(_btnPanel, BorderLayout.SOUTH);

			okBtn.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					_okEnd = true;
					setVisible(false);
				}
			});

			cancelBtn.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					_okEnd = false;
					setVisible(false);
				}
			});
		}

	}

	private void panel_mousePressed(MouseEvent e) {

		String name = ((Label) e.getSource()).getText();
		for (int i = 0; i < COLORS.length; i++) {
			if (COLORS[i].getName().equals(name)) {
				setSelectedColor(COLORS[i].getColor());
				return;
			}
		}
	}

	public void setSelectedColor(Color color) {
		_selectedColor = color;
		_btnPanel.setBackground(_selectedColor);
	}

	public Color getSelectedColor() {
		return _selectedColor;
	}

	public boolean isOKEnd() {
		return _okEnd;
	}

}
