package tinytoolkits.weboard;

import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;

import tinytoolkits.weboard.DrawView.DrawPaneListner;

public class WEBoardController implements DrawPaneListner {
	private HTTPGate _httpGate;

	private WEBoardDomain _domain;

	/**
	 * View.
	 */
	private WEBoardView _view;

	//private State _steate = State.MAP_MODE;

	public WEBoardController(HTTPGate httpGate, WEBoardDomain domain, Frame parentFrame) {
		_httpGate = httpGate;
		_domain = domain;

		_view = new WEBoardView(_domain, this, parentFrame);
	}

	public Component getMainPanel() {
		return _view.getCurrentView();
	}

	public void disconnect() {
		_httpGate.disconnect();
	}

	/**
	 * DrawPaneĂ΂
	 */
	public void listnerCall_getAllItem() {
		try {
			_httpGate.getAll();
		} catch (IOException e) {
			e.printStackTrace();
		}
		_view.repaint();
	}

	/**
	 * DrawPaneĂ΂
	 */
	public void listnerCall_addBoard(Board board) {
		try {
			_httpGate.addBoard(board);
			_view.repaint();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * DrawPaneĂ΂
	 */
	public void listnerCall_changeBoard(Board board) {
		try {
			_httpGate.changeBoard(board);
			_view.repaint();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * DrawPaneĂ΂
	 */
	public void listnerCall_addItem(MemoItem item) {
		try {
			_httpGate.addMemo(item);
			_view.repaint();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * DrawPaneĂ΂
	 */
	public void listnerCall_removeItem(MemoItem item) {
		try {
			_httpGate.removeMemo(item);
			_view.repaint();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * DrawPaneĂ΂
	 */
	public void listnerCall_changeItem(MemoItem item) {
		try {
			_httpGate.changeMemo(item);
			_view.repaint();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	//private final static class State {
	//	public final static State MAP_MODE = new State();
	//
	//	private State() {
	//		//RXgN^h~
	//	}
	//}
}
