/*
    Text maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __CHARLIST_H__
#define __CHARLIST_H__


#include "tmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:キャラクターセットリストダイアログ関数群                                 *
*                                                                             *
******************************************************************************/
/*  ja:キャラクターセットが正しいか判定する
    charset,キャラクターセット
        RET,TRUE:正しい,FALSE:不正                                          */
gboolean
charlist_is_valid (const gchar *charset);


/*  ja:キャラクターセットリストを整形する
    charlist,キャラクターセットリスト
         RET,整形されたキャラクターセットリスト                             */
gchar *
charlist_strip (const gchar *charlist);


/*  ja:キャラクターセットリストを置換する
    charlist0,キャラクターセットリスト
    charlist1,置換するキャラクターセットリスト
         RET,置換されたキャラクターセットリスト                             */
gchar *
charlist_rename (const gchar *charlist0,
                 const gchar *charlist1);


/*  ja:キャラクターセットリストを追加する
    charlist,キャラクターセットリスト
    charsets,追加するキャラクターセットリスト
         RET,追加されたキャラクターセットリスト                             */
gchar *
charlist_append (const gchar *charlist0,
                 const gchar *charlist1);


/*  ja:キャラクターセットを削除する
    charlist,キャラクターセットリスト
     charset,削除するキャラクターセット
         RET,削除されたキャラクターセットリスト                             */
gchar *
charlist_remove (const gchar *charlist,
                 const gchar *charset);


/*  ja:キャラクターセットを置換する
    charlist,置換するキャラクターセット
       ft_id,ファイルタイプのID(-1:追加なし)                                */
void
charlist_renewal_all (const gchar *charlist,
                      const gint ft_id);


/******************************************************************************
*                                                                             *
* ja:キャラクターセットリストダイアログ関数群                                 *
*                                                                             *
******************************************************************************/
/*  ja:キャラクターセットリストダイアログ表示
    charlist,キャラクターセットリスト                                       */
gchar *
charlist_dialog (gchar *charlist);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif
