/*
    Text maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "charset.h"
#include "edit.h"
#include "file.h"
#include "general.h"
#include "jump.h"
#include "sigfile.h"
#include "sigmain.h"
#include "misc/argument.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(テキスト)                                        *
*                                                                             *
******************************************************************************/
void
signal_style_set (GtkWidget *widget,
                  GtkStyle  *style,
                  gpointer   user_data)
{
  gint i;
  GList *glist;
  TmaidWindow *tmaid;

  /* ja:システム色 */
  style = gtk_widget_get_style (widget);
  system_color[0] = style->text[0];
  system_color[1] = style->base[0];
  system_color[2] = style->dark[0];
  system_color[3] = style->dark[0];
  system_color[4] = style->dark[0];
  system_color[5] = style->dark[0];
  system_color[6] = style->dark[0];
  system_color[7] = style->mid[0];
  system_color[8] = style->fg[3];
  system_color[9] = style->bg[3];
  if (system_font)
    pango_font_description_free (system_font);
  /* ja:システムフォント */
  system_font = pango_font_description_copy
                                    (pango_context_get_font_description
                                    (gtk_widget_get_pango_context (widget)));
  glist = gtk_container_children (GTK_CONTAINER (notebook));
  for (i = g_list_length (glist) - 1; i >= 0; i--)
    {
      tmaid = g_object_get_data (G_OBJECT (g_list_nth_data (glist, i)),
                                                                "user_data");
      if (tmaid->ft.syscol || !tmaid->ft.font_name)
        {
          if (!tmaid->ft.font_name)
            {
              /* ja:フォント変更 */
              g_object_unref (tmaid->layout);
              gtk_widget_modify_font (tmaid->drawing, system_font);
              tmaid->layout = gtk_widget_create_pango_layout
                                                        (tmaid->drawing, NULL);
              charset_size (tmaid->layout,
                    &tmaid->font_width, &tmaid->font_height, tmaid->font_buf);
              /* ja:スクロールバー */
              tmaid->cursor.x = tmaid->cursor.y
                                            = tmaid->top.x = tmaid->top.y = 0;
              modify_margin (tmaid);
              misc_set_scroll_bar (tmaid->hscroll,
                    G_CALLBACK (signal_value_changed_hscroll), tmaid,
                    0, edit_get_width_max (tmaid) + 1,
                    MAX (tmaid->drawing->allocation.width / tmaid->font_width,
                                                            1), tmaid->top.x);
              misc_set_scroll_bar (tmaid->vscroll,
                    G_CALLBACK (signal_value_changed_vscroll), tmaid,
                    0, tmaid->max,
                    MAX (tmaid->drawing->allocation.height
                                    / tmaid->font_height, 1), tmaid->top.y);
            }
          gtk_widget_draw (tmaid->drawing, NULL);/* ja:再描画 */
        }
    }
  g_list_free (glist);
}


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(メニュー)                                        *
*                                                                             *
******************************************************************************/
void
signal_activate_menu_window (GtkWidget *widget, GtkWidget *child)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (notebook),
                    gtk_notebook_page_num (GTK_NOTEBOOK (notebook), child));
  gtk_widget_grab_focus (((TmaidWindow *)
                g_object_get_data (G_OBJECT (child), "user_data"))->drawing);
}


void
signal_activate_menu_history (GtkWidget *widget,
                              gchar     *file)
{
  file_open_edit (file);
}


void
signal_destroy_menu_history (GtkWidget *widget,
                             gchar     *file)
{
  g_free (file);
}


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(ノート)                                          *
*                                                                             *
******************************************************************************/
void
signal_clicked (GtkWidget *widget,
                GtkWidget *child)
{
  if (prompt_close ((TmaidWindow *)g_object_get_data (G_OBJECT (child),
                                                                "user_data")))
    gtk_notebook_remove_page (GTK_NOTEBOOK (notebook),
                    gtk_notebook_page_num (GTK_NOTEBOOK (notebook), child));
}


void
signal_switch_page (GtkNotebook     *notebook,
                    GtkNotebookPage *page,
                    gint             page_num,
                    gpointer         user_data)
{
  TmaidWindow *tmaid;

  tmaid = g_object_get_data
                    (G_OBJECT (gtk_notebook_get_nth_page (notebook, page_num)),
                                                                "user_data");
  /* ja:メニュー表示 */
  set_menu_bar (tmaid);
}


void
signal_destroy_notebook (GtkWidget *widget,
                         gpointer   user_data)
{
  gtk_timeout_remove (timer_id);
}


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(セレクション)                                    *
*                                                                             *
******************************************************************************/
void
signal_drag_data_received (GtkWidget        *widget,
                           GdkDragContext   *context,
                           gint              x,
                           gint              y,
                           GtkSelectionData *selection_data,
                           guint             info,
                           guint             time)
{
  gchar *file, **files;
  gint i;

  files = g_strsplit (selection_data->data, "\r\n", G_MAXINT);
  for (i = 0; files[i] != NULL; i++)
    {
      file = g_filename_from_uri (files[i], NULL, NULL);
      if (file)
        {
          file_open_edit (file);
          g_free (file);
        }
    }
  g_strfreev (files);
}


gboolean
signal_selection_clear (GtkWidget         *widget,
                        GdkEventSelection *event,
                        gpointer           user_data)
{
  if (event->selection == GDK_SELECTION_CLIPBOARD)
    {
      /* ja:クリップボード */
      g_free (clipboard_text);
      clipboard_text = NULL;
    }
  return TRUE;
}


void
signal_selection_get (GtkWidget        *widget,
                      GtkSelectionData *data,
                      guint             info,
                      guint             time,
                      TmaidWindow      *tmaid)
{
  if (data->selection==GDK_SELECTION_PRIMARY && tmaid && tmaid->select.x >= 0)
    /* ja:プライマリセレクション */
    {
      gchar *text;
      gint length = 0;

      length = edit_get_sel_bytes (tmaid, &tmaid->select, &tmaid->cursor);
      text = g_malloc ((length + 1) * sizeof (gchar));
      edit_cpy_sel_mem (tmaid, &tmaid->select, &tmaid->cursor, text);
      text[length] = '\0';
      gtk_selection_data_set_text (data, text, length);
      g_free (text);
    }
  else if (data->selection == GDK_SELECTION_CLIPBOARD && clipboard_text)
    {
      /* ja:クリップボード */
      gtk_selection_data_set_text (data,
                                    clipboard_text, g_strlen (clipboard_text));
    }
}


void
signal_selection_received (GtkWidget        *widget,
                           GtkSelectionData *data,
                           guint             time,
                           gpointer          user_data)
{
  if (data->selection == GDK_SELECTION_PRIMARY
                                || data->selection == GDK_SELECTION_CLIPBOARD)
    {
      gchar *text = NULL;

      /* ja:プライマリセレクション/クリップボード */
      if (data->length >= 0)
        {
          if (data->type == GDK_SELECTION_TYPE_ATOM)
            {
              gint i,count;
              GdkAtom *atoms;

              atoms = (GdkAtom *)data->data;
              count = data->length / sizeof (GdkAtom);
              for (i = 0; i < count; i++)
                if (atoms[i] == atom_utf8)
                  break;
              if (i >= count)
                for (i = 0; i < count; i++)
                  if (atoms[i] == atom_compound || atoms[i] == atom_text)
                    break;
              if (i >= count)
                for (i = 0; i < count; i++)
                  if (atoms[i] == GDK_TARGET_STRING)
                    break;
              if (i < count)
                gtk_selection_convert (widget, data->selection, atoms[i],
                                                            GDK_CURRENT_TIME);
            }
          else
            {
              text = gtk_selection_data_get_text (data);
            }
        }
      if (text)
        {
          GdkPoint select;
          TmaidWindow *tmaid;
          TmaidHistory *d;

          tmaid = g_object_get_data(G_OBJECT
                    (gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
                    gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
                                                                "user_data");
          select = tmaid->select;
          d = edit_operation (tmaid, text, g_strlen (text),
                            data->selection == GDK_SELECTION_CLIPBOARD, FALSE);
          d->next = tmaid->undo;
          tmaid->undo = d;
          if (delete_list(&tmaid->redo) > 0 || !d->next || select.x >= 0)
            set_menu_bar(tmaid);
          tmaid_change_edit (tmaid, TRUE);
          g_free (text);
        }
    }
}


void
signal_selection_recv (GObject   *object,
                       gchar    **argv,
                       gpointer   user_data)
{
  gboolean *arg_files;
  gint i, array[2], def[2];
  ArgumentBool arg_n, arg_x;
  ArgumentValue arg_h, arg_l;
  ArgumentArray arg_s;
  ArgumentList arg_opts[] = {
{"history", 'h',  "NUM",          N_("History"),        ARGUMENT_TYPE_VALUE, &arg_h},
{"line",    'l',  "NUM",          N_("Caret Position"), ARGUMENT_TYPE_VALUE, &arg_l},
{"new",     'n',  "ON/OFF",       N_("New File"),       ARGUMENT_TYPE_BOOL,  &arg_n},
{"size",    's',  "WIDTH,HEIGHT", N_("Window Size"),    ARGUMENT_TYPE_ARRAY, &arg_s},
{"second",  'x',  "ON/OFF",       N_("Open Window"),    ARGUMENT_TYPE_BOOL,  &arg_x},
{NULL,      '\0', NULL,           NULL,                 0,                   NULL}};

  /* ja:プロセス間通信 */
  /* ja:ファイルの履歴 */
  arg_h.val = history;
  arg_h.def = 4;
  /* ja:初期のキャレット位置 */
  arg_l.val = 0;
  arg_l.def = 0;
  /* ja:新規ファイル */
  arg_n.flag = newfile;
  arg_n.def = FALSE;
  /* ja:ウインドウサイズ */
  array[0] = def_width;
  array[1] = def_height;
  def[0] = gdk_screen_width ()  * 2 / 3;
  def[1] = gdk_screen_height () * 2 / 3;
  arg_s.leng = 2;
  arg_s.array = array;
  arg_s.def = def;
  /* ja:新規ウインドウ */
  arg_x.flag = second;
  arg_x.def = FALSE;
  /* ja:コマンドラインの解析 */
  arg_files = arg_analyse (argv, arg_opts);
  if (history != arg_h.val && 0 <= arg_h.val && arg_h.val <= 10)
    {
      /* ja:履歴の整理 */
      GList *glist;
      GtkWidget *menu_shell;

      history = arg_h.val;
      menu_shell = gtk_item_factory_get_widget (ifactory_menu, "<main>/File");
      glist = gtk_container_children (GTK_CONTAINER (menu_shell));
      for (i = g_list_length (glist) - 3;
                            i > history - (history == 0) + MENUFILE - 2; i--)
        gtk_container_remove (GTK_CONTAINER
                                    (menu_shell), g_list_nth_data (glist, i));
      g_list_free (glist);
    }
  newfile = arg_n.flag;
  def_width = array[0];
  def_height = array[1];
  second = arg_x.flag;
  for (i = 1; argv[i]; i++)
    if (arg_files[i])
      {
        TmaidWindow *tmaid;

        tmaid = file_open_edit (argv[i]);
        if (arg_l.val != 0)   /* ja:指定行に移動 */
          jump_operation (tmaid, arg_l.val);
      }
  g_free (arg_files);
}


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(メイン)                                          *
*                                                                             *
******************************************************************************/
gboolean
signal_delete (GtkWidget *widget,
               GdkEvent  *event,
               gpointer   user_data)
{
  gint page;
  TmaidWindow *tmaid;

  while ((page = gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook))) >= 0)
    {
      tmaid = g_object_get_data (G_OBJECT
                (gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), page)),
                                                                "user_data");
      if (!prompt_close (tmaid))
        return TRUE;
      gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page);
    }
  return FALSE;
}


void
signal_destroy_window (GtkWidget *widget,
                       gpointer   user_data)
{
  gint i;
  GList *glist;
  GtkWidget *menu_shell;

  memset (history_files, 0, sizeof (gchar *) * 10);
  menu_shell = gtk_item_factory_get_widget (ifactory_menu, "<main>/File");
  glist = gtk_container_children (GTK_CONTAINER (menu_shell));
  for (i = 0; i < (gint)g_list_length (glist) - MENUFILE - 1; i++)
    history_files[i] = g_strdup (g_object_get_data
                        (G_OBJECT (g_list_nth_data (glist, i + MENUFILE - 1)),
                                                                "user_data"));
  g_list_free (glist);
  gtk_main_quit ();
}
