/*
    Text maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "version.h"
#include "misc/license.h"


/******************************************************************************
*                                                                             *
* バージョン情報関数群                                                        *
*                                                                             *
******************************************************************************/
/* ESCが押された */
static gboolean
version_dialog_key_press (GtkWidget   *widget,
                          GdkEventKey *event,
                          gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_widget_destroy (widget);
  return FALSE;
}


/*  ja:バージョン表示                                                       */
void
version_dialog (void)
{
  GdkBitmap *mask;
  GdkPixmap *pixmap;
  GtkTextBuffer *buffer;
  GtkTextIter where;
  GtkWidget *dialog, *button, *notebook, *hbox0, *hbox1, *vbox;
  GtkWidget *text, *scroll;
const static gchar *authors =
"Main Program :\n"
"    Kazuki IWAMOTO\n"
"Document :\n"
"\n"
"Logo :\n"
"\n"
"Translate :\n"
"\n"
"Packager :\n"
"    yasuo-s\n"
"Special Thanks :\n"
"    Takuro Ashie\n"
"    Koji SHIMIZU(21)\n"
"    And all Text maid users";
static gchar *tmaid_xpm[] = {
"32 32 11 1",
"   c None",
"+  c #000000",
"@  c #FF0000",
"#  c #FFFF00",
"$  c #008000",
"%  c #F304F3",
"&  c #F30404",
"*  c #0404F3",
"=  c #04F7F3",
"-  c #F3F704",
";  c #04F704",
"               +                ",
"              +++               ",
"             +++++              ",
"            +++++++             ",
"           +@#@#@#@+            ",
"          +@#@#@#@#@+           ",
"         +@#@#@#@#@#@+          ",
"        +@#@#@#@#@#@#@+         ",
"       +@#@#@#@#@#@#@#@+        ",
"      +@#@#@#@#@#@#@#@#@+       ",
"     +@#@#@#@#@#@#@#@#@#@+      ",
"    +@#@#@#+++#@#@#@#@#@+++     ",
"   +@#@#@#+$$$+#@#@#@#@+$$$+    ",
"  +@#@#@#+$$$$$+#@#@#@+$$$$$+   ",
"  ++@#@#+$$$$$$$+#@#@++$$$$$+   ",
"  +$+@#++$$$$$$%$+#@+$+$$$$$+   ",
"  +$$++$+$$$$$%%$$++$$+$$$$$+   ",
"  +$$$$$+$$$$%%%$$$$$$+$$$$$+   ",
"  +$$$$$+$$$$%%%$$$$$$+$$$$$+   ",
"  +$$$$$+&$$%%%%******+$$$$$+   ",
"  +$$$$$+&&&%%%%****$$+$$$$$+   ",
"  +$$$$$+$&&&&%%***=$$+$$$$$+   ",
"  +$$$$$+$&&&&&%*===$$+$$$$$+   ",
"  +$$$$$+$$&&&-;=====$+$$$$$+   ",
"  +$$$$$+$$&---;;====$+$$$$$+   ",
"  +$$$$$+$-----;;;;===+$$$$$+   ",
"  +$$$$$+------;;;;$$=+$$$$$+   ",
"  +$$$$$+$$$$$$;;;$$$$+$$$$$+   ",
"  +$$$$$+$$$$$$;;;$$$$+$$$$$+   ",
"  +$$$$$+$$$$$$;;$$$$$+$$$$$+   ",
"  +$$$$$+$$$$$$;$$$$$$+$$$$$+   ",
"  +$$$$$+$$$$$$$$$$$$$+$$$$$+   "};

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("About Text maid"));
  gtk_window_set_default_size (GTK_WINDOW (dialog),
                    gdk_screen_width () * 2 / 3, gdk_screen_height () * 2 / 3);
  g_signal_connect (G_OBJECT (dialog), "key-press-event",
                                G_CALLBACK (version_dialog_key_press), NULL);
  g_signal_connect (G_OBJECT (dialog), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  /* ja:ノートブック */
  notebook = gtk_notebook_new ();
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook), TRUE);
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), n_pos);

  /* ja:ライセンス */
  /* ja:テキスト */
  text = gtk_text_view_new ();
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text));
  gtk_text_buffer_set_text (buffer, gnu_gpl, -1);
  gtk_text_buffer_get_start_iter (buffer, &where);
  gtk_text_buffer_place_cursor (buffer, &where);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (text), FALSE);
  /* ja:スクロールウインドウ */
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (scroll), text);
  /* ja:ノートブック */
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), scroll,
                                                gtk_label_new (_("License")));

  /* ja:作者 */
  /* ja:テキスト */
  text = gtk_text_view_new ();
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text));
  gtk_text_buffer_set_text (buffer, authors, -1);
  gtk_text_buffer_get_start_iter (buffer, &where);
  gtk_text_buffer_place_cursor (buffer, &where);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (text), FALSE);
  /* ja:スクロールウインドウ */
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (scroll), text);
  /* ja:ノートブック */
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), scroll,
                                                gtk_label_new (_("Authors")));

  /* ja:ボタン */
  button = gtk_button_new_with_label (_("OK"));
  g_signal_connect_swapped (G_OBJECT (button), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  /* ja:ピクスマップ */
  pixmap = gdk_pixmap_create_from_xpm_d
                                    (window->window, &mask, NULL, tmaid_xpm);

  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  hbox0 = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox0),
                    gtk_image_new_from_pixmap (pixmap, mask), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0),
            gtk_label_new (TMAID_VERSION_NOTICE"\n"TMAID_COPYRIGHT_NOTICE), 
                                                            FALSE, FALSE, 0);
  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox1), hbox0, TRUE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), notebook, TRUE, TRUE, 0);
  hbox0 = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_end (GTK_BOX (hbox0), button, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);

  /* ja:表示 */
  gtk_widget_grab_focus (button);

  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);
  gtk_main ();
}
